/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.iomapping;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.iomapping.VariableLogDelegate;

public class InputOutputEventTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        VariableLogDelegate.reset();
    }

    @Deployment
    public void testMessageThrowEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Map<String, Object> mappedVariables = VariableLogDelegate.LOCAL_VARIABLES;
        InputOutputEventTest.assertEquals((int)1, (int)mappedVariables.size());
        InputOutputEventTest.assertEquals((Object)"mappedValue", (Object)mappedVariables.get("mappedVariable"));
        String variable = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "outVariable");
        InputOutputEventTest.assertEquals((String)"mappedValue", (String)variable);
    }

    @Deployment
    public void testMessageCatchEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution messageExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("messageCatch").singleResult();
        Map localVariables = this.runtimeService.getVariablesLocal(messageExecution.getId());
        InputOutputEventTest.assertEquals((int)1, (int)localVariables.size());
        InputOutputEventTest.assertEquals((Object)"mappedValue", localVariables.get("mappedVariable"));
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("messageVariable", "outValue");
        this.runtimeService.messageEventReceived("IncomingMessage", messageExecution.getId(), variables);
        String variable = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "outVariable");
        InputOutputEventTest.assertEquals((String)"outValue", (String)variable);
    }

    @Deployment
    public void testTimerCatchEvent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        Date dueDate = DateTimeUtil.now().plusMinutes(5).toDate();
        variables.put("outerVariable", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(dueDate));
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        TimerEntity timer = (TimerEntity)job;
        this.assertDateEquals(dueDate, timer.getDuedate());
    }

    protected void assertDateEquals(Date expected, Date actual) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        InputOutputEventTest.assertEquals((String)format.format(expected), (String)format.format(actual));
    }

    @Deployment
    public void testNoneThrowEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Map<String, Object> mappedVariables = VariableLogDelegate.LOCAL_VARIABLES;
        InputOutputEventTest.assertEquals((int)1, (int)mappedVariables.size());
        InputOutputEventTest.assertEquals((Object)"mappedValue", (Object)mappedVariables.get("mappedVariable"));
        String variable = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "outVariable");
        InputOutputEventTest.assertEquals((String)"mappedValue", (String)variable);
    }

    public void testMessageStartEvent() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputEventTest.testMessageStartEvent.bpmn20.xml").deploy();
            InputOutputEventTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("camunda:inputOutput mapping unsupported for element type 'startEvent'", e.getMessage());
        }
    }

    public void testNoneEndEvent() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputEventTest.testNoneEndEvent.bpmn20.xml").deploy();
            InputOutputEventTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("camunda:outputParameter not allowed for element type 'endEvent'", e.getMessage());
        }
    }

    @Deployment
    public void testMessageEndEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        InputOutputEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Map<String, Object> mappedVariables = VariableLogDelegate.LOCAL_VARIABLES;
        InputOutputEventTest.assertEquals((int)1, (int)mappedVariables.size());
        InputOutputEventTest.assertEquals((Object)"mappedValue", (Object)mappedVariables.get("mappedVariable"));
    }

    @Deployment
    public void testMessageCatchAfterEventGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.createMessageCorrelation("foo").processInstanceId(processInstance.getId()).correlate();
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName("foo").singleResult();
        InputOutputEventTest.assertNotNull((Object)variableInstance);
        InputOutputEventTest.assertEquals((Object)"bar", (Object)variableInstance.getValue());
    }

    @Deployment
    public void testTimerCatchAfterEventGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        this.managementService.executeJob(job.getId());
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName("foo").singleResult();
        InputOutputEventTest.assertNotNull((Object)variableInstance);
        InputOutputEventTest.assertEquals((Object)"bar", (Object)variableInstance.getValue());
    }

    @Deployment
    public void testSignalCatchAfterEventGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).signalEventSubscriptionName("foo").singleResult();
        InputOutputEventTest.assertNotNull((Object)execution);
        this.runtimeService.signalEventReceived("foo", execution.getId());
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName("foo").singleResult();
        InputOutputEventTest.assertNotNull((Object)variableInstance);
        InputOutputEventTest.assertEquals((Object)"bar", (Object)variableInstance.getValue());
    }

    @Deployment
    public void testConditionalCatchAfterEventGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.setVariable(processInstance.getId(), "var", (Object)1);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName("foo").singleResult();
        InputOutputEventTest.assertNotNull((Object)variableInstance);
        InputOutputEventTest.assertEquals((Object)"bar", (Object)variableInstance.getValue());
    }

    public void testMessageBoundaryEvent() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputEventTest.testMessageBoundaryEvent.bpmn20.xml").deploy();
            InputOutputEventTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("camunda:inputOutput mapping unsupported for element type 'boundaryEvent'", e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        VariableLogDelegate.reset();
    }
}

