/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.subprocess.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.variable.Variables;

public class TransactionSubProcessTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testSimpleCase.bpmn20.xml"})
    public void testSimpleCaseTxSuccessful() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        TransactionSubProcessTest.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").count());
        TransactionSubProcessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)true);
        this.taskService.complete(task.getId());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        TransactionSubProcessTest.assertTrue((boolean)activeActivityIds.contains("afterSuccess"));
        EventSubscriptionEntity eventSubscriptionEntity = (EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("tx").executionId(processInstance.getId()).singleResult();
        TransactionSubProcessTest.assertNotNull((Object)eventSubscriptionEntity.getConfiguration());
        Execution eventScopeExecution = (Execution)this.runtimeService.createExecutionQuery().executionId(eventSubscriptionEntity.getConfiguration()).singleResult();
        TransactionSubProcessTest.assertNotNull((Object)eventScopeExecution);
        EventSubscriptionEntity miBodyEventSubscriptionEntity = (EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("bookHotel#multiInstanceBody").executionId(eventScopeExecution.getId()).singleResult();
        TransactionSubProcessTest.assertNotNull((Object)miBodyEventSubscriptionEntity);
        String miBodyEventScopeExecutionId = miBodyEventSubscriptionEntity.getConfiguration();
        TransactionSubProcessTest.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").executionId(miBodyEventScopeExecutionId).count());
        TransactionSubProcessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").executionId(eventScopeExecution.getId()).count());
        TransactionSubProcessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoChargeCard").executionId(eventScopeExecution.getId()).count());
        TransactionSubProcessTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        TransactionSubProcessTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        TransactionSubProcessTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "undoChargeCard"));
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testSimpleCase.bpmn20.xml"})
    public void testActivityInstanceTreeAfterSuccessfulCompletion() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)true);
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterSuccess").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testWaitstateCompensationHandler.bpmn20.xml"})
    public void testWaitstateCompensationHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        TransactionSubProcessTest.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").count());
        TransactionSubProcessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        List undoBookHotel = this.taskService.createTaskQuery().taskDefinitionKey("undoBookHotel").list();
        List undoBookFlight = this.taskService.createTaskQuery().taskDefinitionKey("undoBookFlight").list();
        TransactionSubProcessTest.assertEquals((int)5, (int)undoBookHotel.size());
        TransactionSubProcessTest.assertEquals((int)1, (int)undoBookFlight.size());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        List undoBookHotelInstances = this.getInstancesForActivityId(rootActivityInstance, "undoBookHotel");
        List undoBookFlightInstances = this.getInstancesForActivityId(rootActivityInstance, "undoBookFlight");
        TransactionSubProcessTest.assertEquals((int)5, (int)undoBookHotelInstances.size());
        TransactionSubProcessTest.assertEquals((int)1, (int)undoBookFlightInstances.size());
        ActivityInstanceAssert.assertThat(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getId()).beginScope("tx").activity("failure").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookFlight").done());
        for (Task t : undoBookHotel) {
            this.taskService.complete(t.getId());
        }
        this.taskService.complete(((Task)undoBookFlight.get(0)).getId());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        TransactionSubProcessTest.assertTrue((boolean)activeActivityIds.contains("afterCancellation"));
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").count());
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testSimpleCase.bpmn20.xml"})
    public void testSimpleCaseTxCancelled() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        TransactionSubProcessTest.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").count());
        TransactionSubProcessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").count());
        TransactionSubProcessTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        TransactionSubProcessTest.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        TransactionSubProcessTest.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoChargeCard"));
        List<Execution> compensationHandlerExecutions = this.collectExecutionsFor("undoBookHotel", "undoBookFlight", "undoChargeCard");
        for (Execution execution : compensationHandlerExecutions) {
            this.runtimeService.signal(execution.getId());
        }
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        TransactionSubProcessTest.assertTrue((boolean)activeActivityIds.contains("afterCancellation"));
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            TransactionSubProcessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
            TransactionSubProcessTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
            TransactionSubProcessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoChargeCard").count());
        }
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testCancelEndConcurrent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        TransactionSubProcessTest.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").count());
        TransactionSubProcessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").count());
        TransactionSubProcessTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        TransactionSubProcessTest.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        List<Execution> compensationHandlerExecutions = this.collectExecutionsFor("undoBookHotel", "undoBookFlight");
        for (Execution execution : compensationHandlerExecutions) {
            this.runtimeService.signal(execution.getId());
        }
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        TransactionSubProcessTest.assertTrue((boolean)activeActivityIds.contains("afterCancellation"));
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            TransactionSubProcessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
            TransactionSubProcessTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testNestedCancelInner() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        TransactionSubProcessTest.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookHotel").count());
        TransactionSubProcessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookFlight").count());
        Task taskInner = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTxaskCustomer").singleResult();
        Task taskOuter = (Task)this.taskService.createTaskQuery().taskDefinitionKey("bookFlight").singleResult();
        TransactionSubProcessTest.assertNotNull((Object)taskInner);
        TransactionSubProcessTest.assertNotNull((Object)taskOuter);
        this.taskService.setVariable(taskInner.getId(), "confirmed", (Object)false);
        this.taskService.complete(taskInner.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookHotel").count());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookFlight").count());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        TransactionSubProcessTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "innerTxundoBookHotel"));
        TransactionSubProcessTest.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "innerTxundoBookFlight"));
        List<Execution> compensationHandlerExecutions = this.collectExecutionsFor("innerTxundoBookFlight", "innerTxundoBookHotel");
        for (Execution execution : compensationHandlerExecutions) {
            this.runtimeService.signal(execution.getId());
        }
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        TransactionSubProcessTest.assertTrue((boolean)activeActivityIds.contains("afterInnerCancellation"));
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            TransactionSubProcessTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("innerTxundoBookHotel").count());
            TransactionSubProcessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("innerTxundoBookFlight").count());
        }
        this.taskService.complete(taskOuter.getId());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().activityId("afterInnerCancellation").singleResult()).getId());
        this.assertProcessEnded(processInstance.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testNestedCancelOuter() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        TransactionSubProcessTest.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookHotel").count());
        TransactionSubProcessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookFlight").count());
        Task taskInner = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTxaskCustomer").singleResult();
        Task taskOuter = (Task)this.taskService.createTaskQuery().taskDefinitionKey("bookFlight").singleResult();
        TransactionSubProcessTest.assertNotNull((Object)taskInner);
        TransactionSubProcessTest.assertNotNull((Object)taskOuter);
        this.taskService.complete(taskOuter.getId());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        TransactionSubProcessTest.assertTrue((boolean)activeActivityIds.contains("afterOuterCancellation"));
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookHotel").count());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookFlight").count());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        TransactionSubProcessTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "innerTxundoBookHotel"));
        TransactionSubProcessTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "innerTxundoBookFlight"));
        TransactionSubProcessTest.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().activityId("afterOuterCancellation").singleResult()).getId());
        this.assertProcessEnded(processInstance.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testMultiInstanceTx() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().eventType("compensate").list();
        TransactionSubProcessTest.assertEquals((int)10, (int)eventSubscriptions.size());
        Task task = (Task)this.taskService.createTaskQuery().listPage(0, 1).get(0);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        TransactionSubProcessTest.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        TransactionSubProcessTest.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().activityId("afterCancellation").singleResult()).getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testMultiInstanceTx.bpmn20.xml"})
    public void testMultiInstanceTxSuccessful() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().eventType("compensate").list();
        TransactionSubProcessTest.assertEquals((int)10, (int)eventSubscriptions.size());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.setVariable(task.getId(), "confirmed", (Object)true);
            this.taskService.complete(task.getId());
        }
        List executions = this.runtimeService.createExecutionQuery().activityId("receive").list();
        for (Execution execution : executions) {
            this.runtimeService.signal(execution.getId());
        }
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().activityId("afterSuccess").singleResult()).getId());
        TransactionSubProcessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateSubprocess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        this.runtimeService.setVariable(instance.getId(), "cancelTx", (Object)true);
        this.runtimeService.setVariable(instance.getId(), "compensate", (Object)false);
        Task beforeCancelTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCancelTask.getId());
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertNotNull((Object)compensationTask);
        TransactionSubProcessTest.assertEquals((String)"undoInnerTask", (String)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        Task afterBoundaryTask = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertEquals((String)"afterCancel", (String)afterBoundaryTask.getTaskDefinitionKey());
        this.taskService.complete(afterBoundaryTask.getId());
        this.assertProcessEnded(instance.getId());
    }

    @Deployment
    public void testCompensateTransactionWithEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task beforeCancelTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCancelTask.getId());
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertNotNull((Object)compensationHandler);
        TransactionSubProcessTest.assertEquals((String)"blackBoxCompensationHandler", (String)compensationHandler.getTaskDefinitionKey());
        this.taskService.complete(compensationHandler.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCompensateTransactionWithEventSubprocess.bpmn20.xml"})
    public void testCompensateTransactionWithEventSubprocessActivityInstanceTree() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task beforeCancelTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCancelTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("cancelEnd").beginScope("innerSubProcess").activity("blackBoxCompensationHandler").beginScope("eventSubProcess").activity("eventSubProcessThrowCompensation").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCompensateSubprocess.bpmn20.xml"})
    public void testCompensateSubprocessNotTriggered() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        this.runtimeService.setVariable(instance.getId(), "cancelTx", (Object)false);
        this.runtimeService.setVariable(instance.getId(), "compensate", (Object)false);
        Task beforeEndTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeEndTask.getId());
        Task afterTxTask = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertEquals((String)"afterTx", (String)afterTxTask.getTaskDefinitionKey());
        this.taskService.complete(afterTxTask.getId());
        this.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCompensateSubprocess.bpmn20.xml"})
    public void testCompensateSubprocessAfterTxCompletion() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        this.runtimeService.setVariable(instance.getId(), "cancelTx", (Object)false);
        this.runtimeService.setVariable(instance.getId(), "compensate", (Object)true);
        Task beforeTxEndTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeTxEndTask.getId());
        Task afterTxTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(afterTxTask.getId());
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        TransactionSubProcessTest.assertNotNull((Object)compensationTask);
        TransactionSubProcessTest.assertEquals((String)"undoInnerTask", (String)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        this.assertProcessEnded(instance.getId());
    }

    @Deployment
    public void FAILURE_testMultipleCompensationOfCancellationOfMultipleTx() {
        ArrayList<String> devices = new ArrayList<String>();
        devices.add("device1");
        devices.add("device2");
        devices.add("fail");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("order", (Map)Variables.putValue((String)"devices", devices));
        int expected = 3;
        int actual = this.historyService.createHistoricActivityInstanceQuery().activityId("ServiceTask_CompensateConfiguration").list().size();
        TransactionSubProcessTest.assertEquals((int)expected, (int)actual);
    }

    public void testMultipleCancelBoundaryFails() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testMultipleCancelBoundaryFails.bpmn20.xml").deploy();
                TransactionSubProcessTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("multiple boundary events with cancelEventDefinition not supported on same transaction")) break block2;
                TransactionSubProcessTest.fail((String)"different exception expected");
            }
        }
    }

    public void testCancelBoundaryNoTransactionFails() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCancelBoundaryNoTransactionFails.bpmn20.xml").deploy();
                TransactionSubProcessTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("boundary event with cancelEventDefinition only supported on transaction subprocesses")) break block2;
                TransactionSubProcessTest.fail((String)"different exception expected");
            }
        }
    }

    public void testCancelEndNoTransactionFails() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCancelEndNoTransactionFails.bpmn20.xml").deploy();
                TransactionSubProcessTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("end event with cancelEventDefinition only supported inside transaction subprocess")) break block2;
                TransactionSubProcessTest.fail((String)"different exception expected");
            }
        }
    }

    @Deployment
    public void testParseWithDI() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("TransactionSubProcessTest");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("TransactionSubProcessTest");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariable(task.getId(), "confirmed", (Object)true);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    protected List<Execution> collectExecutionsFor(String ... activityIds) {
        ArrayList<Execution> executions = new ArrayList<Execution>();
        for (String activityId : activityIds) {
            executions.addAll(this.runtimeService.createExecutionQuery().activityId(activityId).list());
        }
        return executions;
    }
}

