/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.tasklistener.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;

public class RecorderTaskListener
implements TaskListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static List<RecordedTaskEvent> recordedEvents = new ArrayList<RecordedTaskEvent>();

    public void notify(DelegateTask task) {
        DelegateExecution execution = task.getExecution();
        recordedEvents.add(new RecordedTaskEvent(task.getId(), task.getExecutionId(), task.getEventName(), execution.getActivityInstanceId()));
    }

    public static void clear() {
        recordedEvents.clear();
    }

    public static List<RecordedTaskEvent> getRecordedEvents() {
        return recordedEvents;
    }

    public static class RecordedTaskEvent {
        protected String taskId;
        protected String executionId;
        protected String event;
        protected String activityInstanceId;

        public RecordedTaskEvent(String taskId, String executionId, String event, String activityInstanceId) {
            this.executionId = executionId;
            this.taskId = taskId;
            this.event = event;
            this.activityInstanceId = activityInstanceId;
        }

        public String getExecutionId() {
            return this.executionId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getEvent() {
            return this.event;
        }

        public String getActivityInstanceId() {
            return this.activityInstanceId;
        }
    }
}

