/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.decisiontask;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;

public class CmmnDecisionTaskResultMappingTest
extends CmmnProcessEngineTestCase {
    protected static final String TEST_DECISION = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml";
    protected static final String SINGLE_ENTRY_MAPPING_CMMN = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testSingleEntryMapping.cmmn";
    protected static final String SINGLE_RESULT_MAPPING_CMMN = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testSingleResultMapping.cmmn";
    protected static final String COLLECT_ENTRIES_MAPPING_CMMN = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testCollectEntriesMapping.cmmn";
    protected static final String RESULT_LIST_MAPPING_CMMN = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testResultListMapping.cmmn";
    protected static final String DEFAULT_MAPPING_CMMN = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testDefaultResultMapping.cmmn";
    protected static final String OVERRIDE_DECISION_RESULT_CMMN = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testFailedToOverrideDecisionResultVariable.cmmn";

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testSingleEntryMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testSingleEntryMapping() {
        CaseInstance caseInstance = this.createTestCase("single entry");
        CmmnDecisionTaskResultMappingTest.assertEquals((Object)"foo", (Object)this.caseService.getVariable(caseInstance.getId(), "result"));
        CmmnDecisionTaskResultMappingTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)this.caseService.getVariableTyped(caseInstance.getId(), "result"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testSingleResultMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testSingleResultMapping() {
        CaseInstance caseInstance = this.createTestCase("multiple entries");
        Map output = (Map)this.caseService.getVariable(caseInstance.getId(), "result");
        CmmnDecisionTaskResultMappingTest.assertEquals((int)2, (int)output.size());
        CmmnDecisionTaskResultMappingTest.assertEquals((Object)"foo", output.get("result1"));
        CmmnDecisionTaskResultMappingTest.assertEquals((Object)"bar", output.get("result2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testCollectEntriesMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testCollectEntriesMapping() {
        CaseInstance caseInstance = this.createTestCase("single entry list");
        List output = (List)this.caseService.getVariable(caseInstance.getId(), "result");
        CmmnDecisionTaskResultMappingTest.assertEquals((int)2, (int)output.size());
        CmmnDecisionTaskResultMappingTest.assertEquals((String)"foo", (String)((String)output.get(0)));
        CmmnDecisionTaskResultMappingTest.assertEquals((String)"foo", (String)((String)output.get(1)));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testResultListMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testResultListMapping() {
        CaseInstance caseInstance = this.createTestCase("multiple entries list");
        List resultList = (List)this.caseService.getVariable(caseInstance.getId(), "result");
        CmmnDecisionTaskResultMappingTest.assertEquals((int)2, (int)resultList.size());
        for (Map valueMap : resultList) {
            CmmnDecisionTaskResultMappingTest.assertEquals((int)2, (int)valueMap.size());
            CmmnDecisionTaskResultMappingTest.assertEquals((Object)"foo", valueMap.get("result1"));
            CmmnDecisionTaskResultMappingTest.assertEquals((Object)"bar", valueMap.get("result2"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testDefaultResultMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testDefaultResultMapping() {
        CaseInstance caseInstance = this.createTestCase("multiple entries list");
        List resultList = (List)this.caseService.getVariable(caseInstance.getId(), "result");
        CmmnDecisionTaskResultMappingTest.assertEquals((int)2, (int)resultList.size());
        for (Map valueMap : resultList) {
            CmmnDecisionTaskResultMappingTest.assertEquals((int)2, (int)valueMap.size());
            CmmnDecisionTaskResultMappingTest.assertEquals((Object)"foo", valueMap.get("result1"));
            CmmnDecisionTaskResultMappingTest.assertEquals((Object)"bar", valueMap.get("result2"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testSingleEntryMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testSingleEntryMappingFailureMultipleOutputs() {
        try {
            this.createTestCase("single entry list");
            CmmnDecisionTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-22001", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testSingleEntryMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testSingleEntryMappingFailureMultipleValues() {
        try {
            this.createTestCase("multiple entries");
            CmmnDecisionTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-22001", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testSingleResultMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testSingleResultMappingFailure() {
        try {
            this.createTestCase("single entry list");
            CmmnDecisionTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-22001", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testCollectEntriesMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testCollectEntriesMappingFailure() {
        try {
            this.createTestCase("multiple entries");
            CmmnDecisionTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-22002", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testDefaultResultMapping.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testTransientDecisionResult() {
        CaseInstance caseInstance = this.createTestCase("single entry");
        CmmnDecisionTaskResultMappingTest.assertNull((Object)this.caseService.getVariable(caseInstance.getId(), "decisionResult"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTableResultMappingTest.testFailedToOverrideDecisionResultVariable.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testFailedToOverrideDecisionResultVariable() {
        try {
            this.createTestCase("single entry");
            CmmnDecisionTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("transient variable with name decisionResult to non-transient", e.getMessage());
        }
    }

    protected CaseInstance createTestCase(String input) {
        return this.createCaseInstanceByKey("case", Variables.createVariables().putValue("input", (Object)input));
    }
}

