/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.handler.CaseHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CaseHandlerTest
extends CmmnElementHandlerTest {
    protected CaseHandler handler = new CaseHandler();
    protected CmmnHandlerContext context;

    @Before
    public void setUp() {
        this.context = new CmmnHandlerContext();
        DeploymentEntity deployment = new DeploymentEntity();
        deployment.setId("aDeploymentId");
        this.context.setDeployment((Deployment)deployment);
        this.context.setModel(this.modelInstance);
    }

    @Test
    public void testCaseActivityName() {
        String name = "A Case";
        this.caseDefinition.setName(name);
        CmmnCaseDefinition activity = this.handler.handleElement(this.caseDefinition, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testActivityBehavior() {
        CmmnCaseDefinition activity = this.handler.handleElement(this.caseDefinition, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertNull((Object)behavior);
    }

    @Test
    public void testCaseHasNoParent() {
        CmmnCaseDefinition activity = this.handler.handleElement(this.caseDefinition, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testCaseDefinitionKey() {
        CaseDefinitionEntity activity = (CaseDefinitionEntity)this.handler.handleElement(this.caseDefinition, this.context);
        Assert.assertEquals((Object)this.caseDefinition.getId(), (Object)activity.getKey());
    }

    @Test
    public void testDeploymentId() {
        CaseDefinitionEntity activity = (CaseDefinitionEntity)this.handler.handleElement(this.caseDefinition, this.context);
        String deploymentId = this.context.getDeployment().getId();
        Assert.assertEquals((Object)deploymentId, (Object)activity.getDeploymentId());
    }

    @Test
    public void testHistoryTimeToLiveNull() {
        CaseDefinitionEntity activity = (CaseDefinitionEntity)this.handler.handleElement(this.caseDefinition, this.context);
        Assert.assertNull((Object)activity.getHistoryTimeToLive());
    }

    @Test
    public void testHistoryTimeToLive() {
        Integer historyTimeToLive = 6;
        this.caseDefinition.setCamundaHistoryTimeToLive(historyTimeToLive);
        CaseDefinitionEntity activity = (CaseDefinitionEntity)this.handler.handleElement(this.caseDefinition, this.context);
        Assert.assertEquals((Object)historyTimeToLive, (Object)activity.getHistoryTimeToLive());
    }

    @Test
    public void testHistoryTimeToLiveNegative() {
        Integer historyTimeToLive = -6;
        this.caseDefinition.setCamundaHistoryTimeToLive(historyTimeToLive);
        try {
            this.handler.handleElement(this.caseDefinition, this.context);
            Assert.fail((String)"Exception is expected, that negative value is not allowed.");
        }
        catch (NotValidException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative value is not allowed"));
        }
    }
}

