/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.listener;

import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.listener.FieldInjectionCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.MyCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.MySpecialCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.NotCaseExecutionListener;

public class CaseExecutionListenerTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCreateListenerByClass.cmmn"})
    public void testCreateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCreateListenerByDelegateExpression.cmmn"})
    public void testCreateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCreateListenerByExpression.cmmn"})
    public void testCreateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCreateListenerByScript.cmmn"})
    public void testCreateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testEnableListenerByClass.cmmn"})
    public void testEnableListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testEnableListenerByDelegateExpression.cmmn"})
    public void testEnableListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testEnableListenerByExpression.cmmn"})
    public void testEnableListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testEnableListenerByScript.cmmn"})
    public void testEnableListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDisableListenerByClass.cmmn"})
    public void testDisableListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDisableListenerByDelegateExpression.cmmn"})
    public void testDisableListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDisableListenerByExpression.cmmn"})
    public void testDisableListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDisableListenerByScript.cmmn"})
    public void testDisableListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testReEnableListenerByClass.cmmn"})
    public void testReEnableListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testReEnableListenerByDelegateExpression.cmmn"})
    public void testReEnableListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testReEnableListenerByExpression.cmmn"})
    public void testReEnableListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testReEnableListenerByScript.cmmn"})
    public void testReEnableListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testStartListenerByClass.cmmn"})
    public void testStartListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("start").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("startEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("startOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testStartListenerByDelegateExpression.cmmn"})
    public void testStartListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("start").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("startEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("startOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testStartListenerByExpression.cmmn"})
    public void testStartListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("start").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("startEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("startOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testStartListenerByScript.cmmn"})
    public void testStartListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("start").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("startEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("startOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testManualStartListenerByClass.cmmn"})
    public void testManualStartListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testManualStartListenerByDelegateExpression.cmmn"})
    public void testManualStartListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testManualStartListenerByExpression.cmmn"})
    public void testManualStartListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testManualStartListenerByScript.cmmn"})
    public void testManualStartListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCompleteListenerByClass.cmmn"})
    public void testCompleteListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCompleteListenerByDelegateExpression.cmmn"})
    public void testCompleteListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCompleteListenerByExpression.cmmn"})
    public void testCompleteListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCompleteListenerByScript.cmmn"})
    public void testCompleteListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testTerminateListenerByClass.cmmn"})
    public void testTerminateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testTerminateListenerByDelegateExpression.cmmn"})
    public void testTerminateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testTerminateListenerByExpression.cmmn"})
    public void testTerminateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testTerminateListenerByScript.cmmn"})
    public void testTerminateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testExitListenerByClass.cmmn"})
    public void testExitListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.exit(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("exit").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("exitEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("exitOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testExitListenerByDelegateExpression.cmmn"})
    public void testExitListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.exit(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("exit").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("exitEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("exitOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testExitListenerByExpression.cmmn"})
    public void testExitListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.exit(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("exit").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("exitEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("exitOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testExitListenerByScript.cmmn"})
    public void testExitListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.exit(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("exit").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("exitEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("exitOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentTerminateListenerByClass.cmmn"})
    public void testParentTerminateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.parentTerminate(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentTerminate").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentTerminateEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("parentTerminateOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentTerminateListenerByDelegateExpression.cmmn"})
    public void testParentTerminateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.parentTerminate(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentTerminate").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentTerminateEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("parentTerminateOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentTerminateListenerByExpression.cmmn"})
    public void testParentTerminateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.parentTerminate(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentTerminate").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentTerminateEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("parentTerminateOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentTerminateListenerByScript.cmmn"})
    public void testParentTerminateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.parentTerminate(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentTerminate").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentTerminateEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("parentTerminateOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testSuspendListenerByClass.cmmn"})
    public void testSuspendListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testSuspendListenerByDelegateExpression.cmmn"})
    public void testSuspendListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testSuspendListenerByExpression.cmmn"})
    public void testSuspendListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testSuspendListenerByScript.cmmn"})
    public void testSuspendListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentSuspendListenerByClass.cmmn"})
    public void testParentSuspendListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.parentSuspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentSuspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentSuspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentSuspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentSuspendListenerByDelegateExpression.cmmn"})
    public void testParentSuspendListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.parentSuspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentSuspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentSuspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentSuspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentSuspendListenerByExpression.cmmn"})
    public void testParentSuspendListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.parentSuspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentSuspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentSuspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentSuspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentSuspendListenerByScript.cmmn"})
    public void testParentSuspendListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.parentSuspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentSuspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentSuspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentSuspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testResumeListenerByClass.cmmn"})
    public void testResumeListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testResumeListenerByDelegateExpression.cmmn"})
    public void testResumeListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testResumeListenerByExpression.cmmn"})
    public void testResumeListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testResumeListenerByScript.cmmn"})
    public void testResumeListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentResumeListenerByClass.cmmn"})
    public void testParentResumeListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.parentResume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentResume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentResumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentResumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentResumeListenerByDelegateExpression.cmmn"})
    public void testParentResumeListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.parentResume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentResume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentResumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentResumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentResumeListenerByExpression.cmmn"})
    public void testParentResumeListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.parentResume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentResume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentResumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentResumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentResumeListenerByScript.cmmn"})
    public void testParentResumeListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.parentResume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentResume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentResumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentResumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testOccurListenerByClass.cmmn"})
    public void testOccurListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.occur(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("occur").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("occurEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("occurOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testOccurListenerByDelegateExpression.cmmn"})
    public void testOccurListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.occur(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("occur").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("occurEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("occurOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testOccurListenerByExpression.cmmn"})
    public void testOccurListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.occur(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("occur").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("occurEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("occurOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testOccurListenerByScript.cmmn"})
    public void testOccurListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.occur(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("occur").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("occurEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("occurOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testAllListenerByClass.cmmn"})
    public void testAllListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)25L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)8, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testAllListenerByDelegateExpression.cmmn"})
    public void testAllListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)26L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)8, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testAllListenerByExpression.cmmn"})
    public void testAllListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)26L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)8, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testAllListenerByScript.cmmn"})
    public void testAllListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)25L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)8, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testFieldInjectionByClass.cmmn"})
    public void testFieldInjectionByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)4L, (long)query.count());
        CaseExecutionListenerTest.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testFieldInjectionByDelegateExpression.cmmn"})
    public void testFieldInjectionByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new FieldInjectionCaseExecutionListener()).create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)5L, (long)query.count());
        CaseExecutionListenerTest.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testListenerByScriptResource.cmmn", "org/camunda/bpm/engine/test/cmmn/listener/caseExecutionListener.groovy"})
    public void testListenerByScriptResource() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseExecutionListenerTest.assertEquals((long)10L, (long)query.count());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        CaseExecutionListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        CaseExecutionListenerTest.assertEquals((Object)3, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDoesNotImplementCaseExecutionListenerInterfaceByClass.cmmn"})
    public void testDoesNotImplementCaseExecutionListenerInterfaceByClass() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-05016 Class 'org.camunda.bpm.engine.test.cmmn.listener.NotCaseExecutionListener' doesn't implement '" + CaseExecutionListener.class.getName() + "'", message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDoesNotImplementCaseExecutionListenerInterfaceByDelegateExpression.cmmn"})
    public void testDoesNotImplementCaseExecutionListenerInterfaceByDelegateExpression() {
        try {
            this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new NotCaseExecutionListener()).create();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.assertTextPresent("Delegate expression ${myListener} did not resolve to an implementation of interface " + CaseExecutionListener.class.getName(), message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testListenerDoesNotExist.cmmn"})
    public void testListenerDoesNotExist() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create().getId();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.assertTextPresent("Exception while instantiating class 'org.camunda.bpm.engine.test.cmmn.listener.NotExistingCaseExecutionListener'", message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testBusinessKeyAsCaseBusinessKey.cmmn"})
    public void testBusinessKeyAsCaseBusinessKey() {
        this.caseService.withCaseDefinitionByKey("case").businessKey("myBusinessKey").create().getId();
        VariableInstance v1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("businessKey").singleResult();
        VariableInstance v2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("caseBusinessKey").singleResult();
        CaseExecutionListenerTest.assertNotNull((Object)v1);
        CaseExecutionListenerTest.assertNotNull((Object)v2);
        CaseExecutionListenerTest.assertEquals((Object)"myBusinessKey", (Object)v1.getValue());
        CaseExecutionListenerTest.assertEquals((Object)v1.getValue(), (Object)v2.getValue());
    }
}

