/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.listener;

import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.listener.CloseCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.FieldInjectionCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.MyCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.MySpecialCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.NotCaseExecutionListener;

public class CaseInstanceListenerTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCreateListenerByClass.cmmn"})
    public void testCreateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCreateListenerByDelegateExpression.cmmn"})
    public void testCreateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCreateListenerByExpression.cmmn"})
    public void testCreateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCreateListenerByScript.cmmn"})
    public void testCreateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCompleteListenerByClass.cmmn"})
    public void testCompleteListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCompleteListenerByDelegateExpression.cmmn"})
    public void testCompleteListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCompleteListenerByExpression.cmmn"})
    public void testCompleteListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCompleteListenerByScript.cmmn"})
    public void testCompleteListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testTerminateListenerByClass.cmmn"})
    public void testTerminateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.terminate(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testTerminateListenerByDelegateExpression.cmmn"})
    public void testTerminateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        this.terminate(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testTerminateListenerByExpression.cmmn"})
    public void testTerminateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        this.terminate(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testTerminateListenerByScript.cmmn"})
    public void testTerminateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.terminate(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testSuspendListenerByClass.cmmn"})
    public void testSuspendListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.suspend(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testSuspendListenerByDelegateExpression.cmmn"})
    public void testSuspendListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        this.suspend(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testSuspendListenerByExpression.cmmn"})
    public void testSuspendListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        this.suspend(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testSuspendListenerByScript.cmmn"})
    public void testSuspendListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.suspend(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testReActivateListenerByClass.cmmn"})
    public void testReActivateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        this.reactivate(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reactivate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reactivateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("reactivateOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testReActivateListenerByDelegateExpression.cmmn"})
    public void testReActivateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        this.terminate(caseInstanceId);
        this.reactivate(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reactivate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reactivateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("reactivateOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testReActivateListenerByExpression.cmmn"})
    public void testReActivateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        this.suspend(caseInstanceId);
        this.reactivate(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reactivate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reactivateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("reactivateOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testReActivateListenerByScript.cmmn"})
    public void testReActivateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        this.reactivate(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reactivate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reactivateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("reactivateOnCaseExecutionId").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCloseListenerByClass.cmmn"})
    public void testCloseListenerByClass() {
        CloseCaseExecutionListener.clear();
        CaseInstanceListenerTest.assertNull((Object)CloseCaseExecutionListener.EVENT);
        CaseInstanceListenerTest.assertEquals((int)0, (int)CloseCaseExecutionListener.COUNTER);
        CaseInstanceListenerTest.assertNull((Object)CloseCaseExecutionListener.ON_CASE_EXECUTION_ID);
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        this.caseService.withCaseExecution(caseInstanceId).close();
        CaseInstanceListenerTest.assertEquals((String)"close", (String)CloseCaseExecutionListener.EVENT);
        CaseInstanceListenerTest.assertEquals((int)1, (int)CloseCaseExecutionListener.COUNTER);
        CaseInstanceListenerTest.assertEquals((String)caseInstanceId, (String)CloseCaseExecutionListener.ON_CASE_EXECUTION_ID);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCloseListenerByDelegateExpression.cmmn"})
    public void testCloseListenerByDelegateExpression() {
        CloseCaseExecutionListener.clear();
        CaseInstanceListenerTest.assertNull((Object)CloseCaseExecutionListener.EVENT);
        CaseInstanceListenerTest.assertEquals((int)0, (int)CloseCaseExecutionListener.COUNTER);
        CaseInstanceListenerTest.assertNull((Object)CloseCaseExecutionListener.ON_CASE_EXECUTION_ID);
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new CloseCaseExecutionListener()).create().getId();
        this.terminate(caseInstanceId);
        this.caseService.withCaseExecution(caseInstanceId).close();
        CaseInstanceListenerTest.assertEquals((String)"close", (String)CloseCaseExecutionListener.EVENT);
        CaseInstanceListenerTest.assertEquals((int)1, (int)CloseCaseExecutionListener.COUNTER);
        CaseInstanceListenerTest.assertEquals((String)caseInstanceId, (String)CloseCaseExecutionListener.ON_CASE_EXECUTION_ID);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCloseListenerByExpression.cmmn"})
    public void testCloseListenerByExpression() {
        CloseCaseExecutionListener.clear();
        CaseInstanceListenerTest.assertNull((Object)CloseCaseExecutionListener.EVENT);
        CaseInstanceListenerTest.assertEquals((int)0, (int)CloseCaseExecutionListener.COUNTER);
        CaseInstanceListenerTest.assertNull((Object)CloseCaseExecutionListener.ON_CASE_EXECUTION_ID);
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new CloseCaseExecutionListener()).create().getId();
        this.suspend(caseInstanceId);
        this.caseService.withCaseExecution(caseInstanceId).close();
        CaseInstanceListenerTest.assertEquals((String)"close", (String)CloseCaseExecutionListener.EVENT);
        CaseInstanceListenerTest.assertEquals((int)1, (int)CloseCaseExecutionListener.COUNTER);
        CaseInstanceListenerTest.assertEquals((String)caseInstanceId, (String)CloseCaseExecutionListener.ON_CASE_EXECUTION_ID);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testCloseListenerByScript.cmmn"})
    public void testCloseListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        this.caseService.withCaseExecution(caseInstanceId).close();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testAllListenerByClass.cmmn"})
    public void testAllListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        this.reactivate(caseInstanceId);
        this.terminate(caseInstanceId);
        this.reactivate(caseInstanceId);
        this.suspend(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)16L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reactivate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)2, (Object)((VariableInstance)query.variableName("reactivateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("reactivateOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)6, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testAllListenerByDelegateExpression.cmmn"})
    public void testAllListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        this.reactivate(caseInstanceId);
        this.terminate(caseInstanceId);
        this.reactivate(caseInstanceId);
        this.suspend(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)17L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reactivate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)2, (Object)((VariableInstance)query.variableName("reactivateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("reactivateOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)6, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testAllListenerByExpression.cmmn"})
    public void testAllListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        this.reactivate(caseInstanceId);
        this.terminate(caseInstanceId);
        this.reactivate(caseInstanceId);
        this.suspend(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)17L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reactivate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)2, (Object)((VariableInstance)query.variableName("reactivateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("reactivateOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)6, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testAllListenerByScript.cmmn"})
    public void testAllListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        this.reactivate(caseInstanceId);
        this.terminate(caseInstanceId);
        this.reactivate(caseInstanceId);
        this.suspend(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)16L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reactivate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)2, (Object)((VariableInstance)query.variableName("reactivateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("reactivateOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)6, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testFieldInjectionByClass.cmmn"})
    public void testFieldInjectionByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)4L, (long)query.count());
        CaseInstanceListenerTest.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testFieldInjectionByDelegateExpression.cmmn"})
    public void testFieldInjectionByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new FieldInjectionCaseExecutionListener()).create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)5L, (long)query.count());
        CaseInstanceListenerTest.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testListenerByScriptResource.cmmn", "org/camunda/bpm/engine/test/cmmn/listener/caseExecutionListener.groovy"})
    public void testListenerByScriptResource() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        this.reactivate(caseInstanceId);
        this.terminate(caseInstanceId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        CaseInstanceListenerTest.assertEquals((long)10L, (long)query.count());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        CaseInstanceListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)caseInstanceId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        CaseInstanceListenerTest.assertEquals((Object)3, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testDoesNotImplementCaseExecutionListenerInterfaceByClass.cmmn"})
    public void testDoesNotImplementCaseExecutionListenerInterfaceByClass() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-05016 Class 'org.camunda.bpm.engine.test.cmmn.listener.NotCaseExecutionListener' doesn't implement '" + CaseExecutionListener.class.getName() + "'", message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testDoesNotImplementCaseExecutionListenerInterfaceByDelegateExpression.cmmn"})
    public void testDoesNotImplementCaseExecutionListenerInterfaceByDelegateExpression() {
        try {
            this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new NotCaseExecutionListener()).create();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.assertTextPresent("Delegate expression ${myListener} did not resolve to an implementation of interface " + CaseExecutionListener.class.getName(), message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseInstanceListenerTest.testListenerDoesNotExist.cmmn"})
    public void testListenerDoesNotExist() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create().getId();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.assertTextPresent("Exception while instantiating class", message);
        }
    }
}

