/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.operation;

import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.model.CaseDefinitionBuilder;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.test.cmmn.operation.TaskWaitState;
import org.junit.Test;

public class CaseExecutionSuspensionTest
extends PvmTestCase {
    @Test
    public void testSuspendCaseInstance() {
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").createActivity("X").behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        caseInstance.suspend();
        CaseExecutionSuspensionTest.assertTrue((boolean)caseInstance.isSuspended());
        CaseExecutionSuspensionTest.assertTrue((boolean)stageX.isSuspended());
        CaseExecutionSuspensionTest.assertTrue((boolean)taskA.isSuspended());
        CaseExecutionSuspensionTest.assertTrue((boolean)taskB.isSuspended());
    }

    @Test
    public void testSuspendStage() {
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").createActivity("X").behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        stageX.suspend();
        CaseExecutionSuspensionTest.assertTrue((boolean)caseInstance.isActive());
        CaseExecutionSuspensionTest.assertTrue((boolean)stageX.isSuspended());
        CaseExecutionSuspensionTest.assertTrue((boolean)taskA.isSuspended());
        CaseExecutionSuspensionTest.assertTrue((boolean)taskB.isSuspended());
    }

    @Test
    public void testSuspendTask() {
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").createActivity("X").behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").behavior((CmmnActivityBehavior)new TaskWaitState()).property("manualActivationRule", this.defaultManualActivation()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.suspend();
        CaseExecutionSuspensionTest.assertTrue((boolean)caseInstance.isActive());
        CaseExecutionSuspensionTest.assertTrue((boolean)stageX.isActive());
        CaseExecutionSuspensionTest.assertTrue((boolean)taskA.isSuspended());
        CaseExecutionSuspensionTest.assertTrue((boolean)taskB.isEnabled());
    }
}

