/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.processtask;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.BooleanValue;
import org.camunda.bpm.engine.variable.value.IntegerValue;
import org.camunda.bpm.engine.variable.value.LongValue;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProcessTaskTest
extends CmmnProcessEngineTestCase {
    protected final String PROCESS_TASK = "PI_ProcessTask_1";
    protected final String ONE_PROCESS_TASK_CASE = "oneProcessTaskCase";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallProcessAsConstant() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testCallProcessAsExpressionStartsWithDollar.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallProcessAsExpressionStartsWithDollar() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", Variables.createVariables().putValue("process", (Object)"oneTaskProcess")).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testCallProcessAsExpressionStartsWithHash.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallProcessAsExpressionStartsWithHash() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", Variables.createVariables().putValue("process", (Object)"oneTaskProcess")).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testCallLatestProcess.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallLatestProcess() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        ProcessTaskTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String latestProcessDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().latestVersion().singleResult()).getId();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        ProcessTaskTest.assertEquals((String)latestProcessDefinitionId, (String)processInstance.getProcessDefinitionId());
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testCallProcessByDeployment.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallProcessByDeployment() {
        String firstDeploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        ProcessTaskTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String processDefinitionIdInSameDeployment = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(firstDeploymentId).singleResult()).getId();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        ProcessTaskTest.assertEquals((String)processDefinitionIdInSameDeployment, (String)processInstance.getProcessDefinitionId());
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testCallProcessByVersion.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallProcessByVersion() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        ProcessTaskTest.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String processDefinitionIdInSecondDeployment = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(secondDeploymentId).singleResult()).getId();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        ProcessTaskTest.assertEquals((String)processDefinitionIdInSecondDeployment, (String)processInstance.getProcessDefinitionId());
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testCallProcessByVersionAsExpressionStartsWithDollar.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallProcessByVersionAsExpressionStartsWithDollar() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        ProcessTaskTest.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", Variables.createVariables().putValue("myVersion", (Object)2)).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String processDefinitionIdInSecondDeployment = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(secondDeploymentId).singleResult()).getId();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        ProcessTaskTest.assertEquals((String)processDefinitionIdInSecondDeployment, (String)processInstance.getProcessDefinitionId());
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testCallProcessByVersionAsExpressionStartsWithHash.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallProcessByVersionAsExpressionStartsWithHash() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        ProcessTaskTest.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", Variables.createVariables().putValue("myVersion", (Object)2)).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String processDefinitionIdInSecondDeployment = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(secondDeploymentId).singleResult()).getId();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        ProcessTaskTest.assertEquals((String)processDefinitionIdInSecondDeployment, (String)processInstance.getProcessDefinitionId());
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputBusinessKey.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputBusinessKey() {
        String businessKey = "myBusinessKey";
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", businessKey).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        ProcessTaskTest.assertEquals((String)businessKey, (String)processInstance.getBusinessKey());
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputDifferentBusinessKey.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputDifferentBusinessKey() {
        String businessKey = "myBusinessKey";
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", businessKey).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).setVariable("myOwnBusinessKey", (Object)"myOwnBusinessKey").manualStart();
        ExecutionEntity processInstance = (ExecutionEntity)this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        ProcessTaskTest.assertEquals((String)processTaskId, (String)processInstance.getSuperCaseExecutionId());
        ProcessTaskTest.assertEquals((String)"myOwnBusinessKey", (String)processInstance.getBusinessKey());
        ProcessTaskTest.assertFalse((boolean)businessKey.equals(processInstance.getBusinessKey()));
        TaskEntity task = (TaskEntity)this.queryTask();
        ProcessTaskTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        ProcessTaskTest.assertNull((Object)task.getCaseExecutionId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputSource.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputSource() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", Variables.createVariables().putValue("aVariable", (Object)"abc").putValue("anotherVariable", (Object)999).putValue("aThirdVariable", (Object)"def")).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"aVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"anotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.taskService.complete(this.queryTask().getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputSourceDifferentTarget.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputSourceDifferentTarget() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).setVariable("aThirdVariable", (Object)"def").manualStart();
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("myVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"myVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("myAnotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"myAnotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.taskService.complete(this.queryTask().getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputSource.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputSourceNullValue() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if (!"aVariable".equals(name) && !"anotherVariable".equals(name)) {
                ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
            }
            ProcessTaskTest.assertNull((Object)variable.getValue());
        }
        this.taskService.complete(this.queryTask().getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputSourceExpression.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputSourceExpression() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", Variables.createVariables().putValue("aVariable", (Object)"abc").putValue("anotherVariable", (Object)999)).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"aVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"anotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.taskService.complete(this.queryTask().getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputAll.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputAll() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", Variables.createVariables().putValue("aVariable", (Object)"abc").putValue("anotherVariable", (Object)999)).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"aVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"anotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.taskService.complete(this.queryTask().getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputAllLocal.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputAllLocal() {
        this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariable", (Object)"abc").setVariableLocal("aLocalVariable", (Object)"def").manualStart();
        ProcessInstance subProcessInstance = this.queryProcessInstance();
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{subProcessInstance.getId()}).list();
        ProcessTaskTest.assertEquals((int)1, (int)variables.size());
        ProcessTaskTest.assertEquals((String)"aLocalVariable", (String)((VariableInstance)variables.get(0)).getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputOverlapping.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputOverlapping() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).manualStart();
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"aVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"anotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.taskService.complete(this.queryTask().getId());
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn"})
    public void testProcessNotFound() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).manualStart();
            ProcessTaskTest.fail((String)"It should not be possible to start a process instance.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.terminate(caseInstanceId);
        this.close(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCompleteSimpleProcess() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        Task task = this.queryTask();
        this.taskService.complete(task.getId());
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNull((Object)processInstance);
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        ProcessTaskTest.assertNull((Object)processTask);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testOutputSource.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testOutputSource() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"abc");
        this.runtimeService.setVariable(processInstanceId, "anotherVariable", (Object)999);
        this.runtimeService.setVariable(processInstanceId, "aThirdVariable", (Object)"def");
        String taskId = this.queryTask().getId();
        this.taskService.complete(taskId);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"aVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"anotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testOutputSourceDifferentTarget.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testOutputSourceDifferentTarget() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"abc");
        this.runtimeService.setVariable(processInstanceId, "anotherVariable", (Object)999);
        String taskId = this.queryTask().getId();
        this.taskService.complete(taskId);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("myVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"myVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("myAnotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"myAnotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testOutputSource.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testOutputSourceNullValue() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        String taskId = this.queryTask().getId();
        this.taskService.complete(taskId);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if (!"aVariable".equals(name) && !"anotherVariable".equals(name)) {
                ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
            }
            ProcessTaskTest.assertNull((Object)variable.getValue());
        }
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testOutputSourceExpression.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testOutputSourceExpression() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        String taskId = this.queryTask().getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"abc");
        this.runtimeService.setVariable(processInstanceId, "anotherVariable", (Object)999);
        this.taskService.complete(taskId);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"aVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"anotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testOutputAll.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testOutputAll() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        String taskId = this.queryTask().getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"abc");
        this.runtimeService.setVariable(processInstanceId, "anotherVariable", (Object)999);
        this.taskService.complete(taskId);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"aVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"anotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testOutputOverlapping.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testOutputOverlapping() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        String taskId = this.queryTask().getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"abc");
        this.runtimeService.setVariable(processInstanceId, "anotherVariable", (Object)999);
        this.taskService.complete(taskId);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"aVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"anotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testOutputAllWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testOutputVariablesShouldNotExistAnymore() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).setVariableLocal("aVariable", (Object)"xyz").setVariableLocal("anotherVariable", (Object)123).manualStart();
        String processInstanceId = this.queryProcessInstance().getId();
        String taskId = this.queryTask().getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"abc");
        this.runtimeService.setVariable(processInstanceId, "anotherVariable", (Object)999);
        this.taskService.complete(taskId);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        ProcessTaskTest.assertTrue((boolean)variables.isEmpty());
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testVariablesRoundtrip.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testVariablesRoundtrip() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).setVariable("aVariable", (Object)"xyz").setVariable("anotherVariable", (Object)123);
        String processInstanceId = this.queryProcessInstance().getId();
        String taskId = this.queryTask().getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"abc");
        this.runtimeService.setVariable(processInstanceId, "anotherVariable", (Object)999);
        this.taskService.complete(taskId);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        ProcessTaskTest.assertEquals((int)2, (int)variables.size());
        ProcessTaskTest.assertFalse((boolean)((VariableInstance)variables.get(0)).getName().equals(((VariableInstance)variables.get(1)).getName()));
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"aVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                ProcessTaskTest.assertEquals((String)"anotherVariable", (String)name);
                ProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            ProcessTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testInputOutputAll.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputOutputAllTypedVariables() {
        String variableName = "aVariable";
        String variableName2 = "anotherVariable";
        String variableName3 = "theThirdVariable";
        StringValue variableValue = Variables.stringValue((String)"abc");
        LongValue variableValue2 = Variables.longValue(null);
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", Variables.createVariables().putValue(variableName, (Object)variableValue).putValue(variableName2, (Object)variableValue2)).getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        TypedValue value = this.runtimeService.getVariableTyped(processInstanceId, variableName);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)variableValue));
        value = this.runtimeService.getVariableTyped(processInstanceId, variableName2);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)variableValue2));
        String taskId = this.queryTask().getId();
        IntegerValue variableValue3 = Variables.integerValue((Integer)1);
        this.runtimeService.setVariable(processInstanceId, variableName3, (Object)variableValue3);
        this.taskService.complete(taskId);
        value = this.caseService.getVariableTyped(caseInstanceId, variableName3);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)variableValue3));
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testVariablesRoundtrip.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testInputOutputLimitedTypedVariables() {
        String variableName = "aVariable";
        String variableName2 = "anotherVariable";
        StringValue caseVariableValue = Variables.stringValue((String)"abc");
        IntegerValue caseVariableValue2 = Variables.integerValue(null);
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase", Variables.createVariables().putValue(variableName, (Object)caseVariableValue).putValue(variableName2, (Object)caseVariableValue2)).getId();
        String processInstanceId = this.queryProcessInstance().getId();
        TypedValue value = this.runtimeService.getVariableTyped(processInstanceId, variableName);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)caseVariableValue));
        value = this.runtimeService.getVariableTyped(processInstanceId, variableName2);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)caseVariableValue2));
        StringValue processVariableValue = Variables.stringValue((String)"cba");
        BooleanValue processVariableValue2 = Variables.booleanValue(null);
        this.runtimeService.setVariable(processInstanceId, variableName, (Object)processVariableValue);
        this.runtimeService.setVariable(processInstanceId, variableName2, (Object)processVariableValue2);
        this.taskService.complete(this.queryTask().getId());
        value = this.caseService.getVariableTyped(caseInstanceId, variableName);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)processVariableValue));
        value = this.caseService.getVariableTyped(caseInstanceId, variableName2);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)processVariableValue2));
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCompleteProcessTask() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).complete();
            ProcessTaskTest.fail((String)"It should not be possible to complete a process task, while the process instance is running.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
        String processInstanceId = this.queryProcessInstance().getId();
        String taskId = this.queryTask().getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCompleteProcessTaskAfterTerminateSubProcessInstance() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNull((Object)processInstance);
        try {
            this.caseService.withCaseExecution(processTaskId).complete();
            ProcessTaskTest.fail((String)"It should not be possible to complete a process task");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.terminate(caseInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTerminateProcessTask() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.terminate(processTaskId);
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTerminateSubProcessInstance() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNull((Object)processInstance);
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        ProcessTaskTest.assertNotNull((Object)processTask);
        ProcessTaskTest.assertTrue((boolean)processTask.isActive());
        this.terminate(caseInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSuspendProcessTask() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.suspend(processTaskId);
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        ProcessTaskTest.assertFalse((boolean)processInstance.isSuspended());
        Task task = this.queryTask();
        ProcessTaskTest.assertNotNull((Object)task);
        ProcessTaskTest.assertFalse((boolean)task.isSuspended());
        this.resume(processTaskId);
        this.terminate(caseInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSuspendSubProcessInstance() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String processInstanceId = this.queryProcessInstance().getId();
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertTrue((boolean)processInstance.isSuspended());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        ProcessTaskTest.assertTrue((boolean)processTask.isActive());
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        String taskId = this.queryTask().getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(processInstanceId);
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testResumeProcessTask() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.suspend(processTaskId);
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        ProcessTaskTest.assertFalse((boolean)processTask.isActive());
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertFalse((boolean)processInstance.isSuspended());
        this.resume(processTaskId);
        processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertFalse((boolean)processInstance.isSuspended());
        processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        ProcessTaskTest.assertTrue((boolean)processTask.isActive());
        String taskId = this.queryTask().getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(processInstance.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testNonBlockingProcessTask.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testNonBlockingProcessTask() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        Task task = this.queryTask();
        ProcessTaskTest.assertNotNull((Object)task);
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        ProcessTaskTest.assertNull((Object)processTask);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        ProcessTaskTest.assertNotNull((Object)caseInstance);
        ProcessTaskTest.assertTrue((boolean)caseInstance.isCompleted());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
        String taskId = this.queryTask().getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testProcessInstanceCompletesInOneGo.cmmn", "org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testProcessInstanceCompletesInOneGo.bpmn20.xml"})
    public void testProcessInstanceCompletesInOneGo() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNull((Object)processInstance);
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        ProcessTaskTest.assertNull((Object)processTask);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        ProcessTaskTest.assertNotNull((Object)caseInstance);
        ProcessTaskTest.assertTrue((boolean)caseInstance.isCompleted());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testNonBlockingProcessTaskAndProcessInstanceCompletesInOneGo.cmmn", "org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testProcessInstanceCompletesInOneGo.bpmn20.xml"})
    public void testNonBlockingProcessTaskAndProcessInstanceCompletesInOneGo() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNull((Object)processInstance);
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        ProcessTaskTest.assertNull((Object)processTask);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        ProcessTaskTest.assertNotNull((Object)caseInstance);
        ProcessTaskTest.assertTrue((boolean)caseInstance.isCompleted());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testStartProcessInstanceAsync.cmmn", "org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testStartProcessInstanceAsync.bpmn20.xml"})
    public void testStartProcessInstanceAsync() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessTaskTest.assertNotNull((Object)job);
        ProcessInstance processInstance = this.queryProcessInstance();
        ProcessTaskTest.assertNotNull((Object)processInstance);
        this.managementService.executeJob(job.getId());
        this.close(caseInstanceId);
        this.assertCaseEnded(caseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn"})
    public void testActivityType() {
        this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        ProcessTaskTest.assertEquals((String)"processTask", (String)processTask.getActivityType());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testOutputAll.cmmn", "org/camunda/bpm/engine/test/cmmn/processtask/subProcessWithError.bpmn"})
    public void testOutputWhenErrorOccurs() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        Task task = this.queryTask();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"SubTask"));
        String variableName = "foo";
        String variableValue = "bar";
        this.runtimeService.setVariable(task.getProcessInstanceId(), variableName, (Object)variableValue);
        this.taskService.complete(task.getId());
        Object variable = this.caseService.getVariable(caseInstanceId, variableName);
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Object)variableValue));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/processtask/ProcessTaskTest.testOutputAll.cmmn", "org/camunda/bpm/engine/test/cmmn/processtask/subProcessWithThrownError.bpmn"})
    public void testOutputWhenThrownBpmnErrorOccurs() {
        String caseInstanceId = this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        Task task = this.queryTask();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"SubTask"));
        String variableName = "foo";
        String variableValue = "bar";
        this.runtimeService.setVariable(task.getProcessInstanceId(), variableName, (Object)variableValue);
        this.taskService.complete(task.getId());
        Object variable = this.caseService.getVariable(caseInstanceId, variableName);
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Object)variableValue));
    }

    protected ProcessInstance queryProcessInstance() {
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
    }

    protected Task queryTask() {
        return (Task)this.taskService.createTaskQuery().singleResult();
    }
}

