/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Map;
import junit.framework.TestCase;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.CachedDbEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class CompetingByteVariableAccessTest
extends ConcurrencyTestCase {
    private ConcurrencyTestCase.ThreadControl asyncThread;

    public void testConcurrentVariableRemoval() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"test").startEvent().userTask().endEvent().done()});
        byte[] byteVar = "asd".getBytes();
        String pid = this.runtimeService.startProcessInstanceByKey("test", (Map)Variables.createVariables().putValue("byteVar", (Object)byteVar)).getId();
        this.asyncThread = this.executeControllableCommand(new FetchAndUpdateVariableCmd(pid, "byteVar", "bsd".getBytes()));
        this.asyncThread.waitForSync();
        this.runtimeService.deleteProcessInstance(pid, null);
        this.asyncThread.reportInterrupts();
        this.asyncThread.waitUntilDone();
        Throwable exception = this.asyncThread.getException();
        CompetingByteVariableAccessTest.assertNotNull((Object)exception);
        CompetingByteVariableAccessTest.assertTrue((boolean)(exception instanceof OptimisticLockingException));
    }

    static class FetchAndUpdateVariableCmd
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String executionId;
        protected String varName;
        protected Object newValue;

        public FetchAndUpdateVariableCmd(String executionId, String varName, Object newValue) {
            this.executionId = executionId;
            this.varName = varName;
            this.newValue = newValue;
        }

        public Void execute(CommandContext commandContext) {
            ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
            VariableInstanceEntity varInstance = (VariableInstanceEntity)execution.getVariableInstanceLocal(this.varName);
            String byteArrayValueId = varInstance.getByteArrayValueId();
            TestCase.assertNotNull((String)"Byte array id is expected to be not null", (Object)byteArrayValueId);
            CachedDbEntity cachedByteArray = commandContext.getDbEntityManager().getDbEntityCache().getCachedEntity(ByteArrayEntity.class, byteArrayValueId);
            TestCase.assertNull((String)"Byte array is expected to be not fetched yet / lazily fetched.", (Object)cachedByteArray);
            this.monitor.sync();
            execution.setVariableLocal(varInstance.getName(), this.newValue);
            return null;
        }
    }
}

