/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.cmd.FetchExternalTasksCmd;
import org.camunda.bpm.engine.impl.externaltask.TopicFetchInstruction;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;

public class CompetingExternalTaskFetchingTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testCompetingExternalTaskFetching() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTaskFetcherThread thread1 = new ExternalTaskFetcherThread("thread1", 5, "externalTaskTopic");
        ExternalTaskFetcherThread thread2 = new ExternalTaskFetcherThread("thread2", 5, "externalTaskTopic");
        thread1.startAndWaitUntilControlIsReturned();
        thread2.startAndWaitUntilControlIsReturned();
        thread1.proceedAndWaitTillDone();
        CompetingExternalTaskFetchingTest.assertNull((Object)((Object)thread1.exception));
        CompetingExternalTaskFetchingTest.assertEquals((int)1, (int)thread1.fetchedTasks.size());
        thread2.proceedAndWaitTillDone();
        CompetingExternalTaskFetchingTest.assertEquals((int)0, (int)thread2.fetchedTasks.size());
        CompetingExternalTaskFetchingTest.assertNull((Object)((Object)thread2.exception));
    }

    public class ExternalTaskFetcherThread
    extends ControllableThread {
        protected String workerId;
        protected int results;
        protected String topic;
        protected List<LockedExternalTask> fetchedTasks;
        protected OptimisticLockingException exception;

        public ExternalTaskFetcherThread(String workerId, int results, String topic) {
            this.workerId = workerId;
            this.results = results;
            this.topic = topic;
        }

        @Override
        public void run() {
            HashMap<String, TopicFetchInstruction> instructions = new HashMap<String, TopicFetchInstruction>();
            TopicFetchInstruction instruction = new TopicFetchInstruction(this.topic, 10000L);
            instructions.put(this.topic, instruction);
            try {
                this.fetchedTasks = (List)CompetingExternalTaskFetchingTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new FetchExternalTasksCmd(this.workerId, this.results, instructions));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
        }
    }
}

