/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.HistoryCleanupCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.util.DatabaseHelper;

public class ConcurrentHistoryCleanupTest
extends ConcurrencyTestCase {
    @Override
    public void tearDown() throws Exception {
        ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = ConcurrentHistoryCleanupTest.this.processEngine.getManagementService().createJobQuery().list();
                if (jobs.size() > 0) {
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                return null;
            }
        });
        super.tearDown();
    }

    protected void runTest() throws Throwable {
        Integer transactionIsolationLevel = DatabaseHelper.getTransactionIsolationLevel(this.processEngineConfiguration);
        String databaseType = DatabaseHelper.getDatabaseType(this.processEngineConfiguration);
        if (!("h2".equals(databaseType) || "mariadb".equals(databaseType) || transactionIsolationLevel != null && !transactionIsolationLevel.equals(2))) {
            super.runTest();
        }
    }

    public void testRunTwoHistoryCleanups() throws InterruptedException {
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableHistoryCleanupCommand());
        thread1.waitForSync();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableHistoryCleanupCommand());
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone();
        List historyCleanupJobs = this.processEngine.getHistoryService().findHistoryCleanupJobs();
        ConcurrentHistoryCleanupTest.assertFalse((boolean)historyCleanupJobs.isEmpty());
        ConcurrentHistoryCleanupTest.assertEquals((int)1, (int)historyCleanupJobs.size());
        ConcurrentHistoryCleanupTest.assertNull((Object)thread1.getException());
        ConcurrentHistoryCleanupTest.assertNull((Object)thread2.getException());
    }

    protected static class ControllableHistoryCleanupCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected ControllableHistoryCleanupCommand() {
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new HistoryCleanupCmd(true).execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

