/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;

@RequiredHistoryLevel(value="full")
public abstract class AbstractCompositeHistoryEventHandlerTest
extends PluggableProcessEngineTestCase {
    protected HistoryEventHandler originalHistoryEventHandler;
    protected int countCustomHistoryEventHandler;

    protected void setUp() throws Exception {
        super.setUp();
        this.originalHistoryEventHandler = this.processEngineConfiguration.getHistoryEventHandler();
        this.countCustomHistoryEventHandler = 0;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.processEngineConfiguration.setHistoryEventHandler(this.originalHistoryEventHandler);
    }

    protected void startProcessAndCompleteUserTask() {
        this.runtimeService.startProcessInstanceByKey("HistoryLevelTest");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
    }

    protected class CustomDbHistoryEventHandler
    implements HistoryEventHandler {
        protected CustomDbHistoryEventHandler() {
        }

        public void handleEvent(HistoryEvent historyEvent) {
            if (historyEvent instanceof HistoricVariableUpdateEventEntity) {
                ++AbstractCompositeHistoryEventHandlerTest.this.countCustomHistoryEventHandler;
            }
        }

        public void handleEvents(List<HistoryEvent> historyEvents) {
            for (HistoryEvent historyEvent : historyEvents) {
                this.handleEvent(historyEvent);
            }
        }
    }
}

