/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatistics;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatisticsQuery;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="activity")
public class HistoricCaseActivityStatisticsQueryTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected HistoryService historyService;
    protected CaseService caseService;
    protected RepositoryService repositoryService;

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.caseService = this.engineRule.getCaseService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Test
    public void testCaseDefinitionNull() {
        try {
            this.historyService.createHistoricCaseActivityStatisticsQuery(null).list();
            Assert.fail((String)"It should not be possible to query for statistics by null.");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testNoCaseActivityInstances() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        HistoricCaseActivityStatisticsQuery query = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertThat((Object)query.list().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSingleTask() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        this.createCaseByKey(5, "oneTaskCase");
        HistoricCaseActivityStatisticsQuery query = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        List statistics = query.list();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertThat((Object)statistics.size(), (Matcher)Is.is((Object)1));
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(0), "PI_HumanTask_1", 5L, 0L, 0L, 0L, 0L, 0L);
    }

    @Test
    @Deployment
    public void testMultipleTasks() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        this.createCaseByKey(5, "case");
        this.disableByActivity("DISABLED");
        this.completeByActivity("COMPLETED");
        this.terminateByActivity("TERMINATED");
        HistoricCaseActivityStatisticsQuery query = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        List statistics = query.list();
        Assert.assertThat((Object)statistics.size(), (Matcher)Is.is((Object)6));
        Assert.assertEquals((long)query.count(), (long)6L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(0), "ACTIVE", 5L, 0L, 0L, 0L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(1), "AVAILABLE", 0L, 5L, 0L, 0L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(2), "COMPLETED", 0L, 0L, 5L, 0L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(3), "DISABLED", 0L, 0L, 0L, 5L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(4), "ENABLED", 0L, 0L, 0L, 0L, 5L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(5), "TERMINATED", 0L, 0L, 0L, 0L, 0L, 5L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricCaseActivityStatisticsQueryTest.testMultipleTasks.cmmn"})
    public void testStateCount() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        this.createCaseByKey(3, "case");
        this.completeByActivity("ACTIVE");
        this.manuallyStartByActivity("AVAILABLE");
        this.completeByActivity("AVAILABLE");
        this.createCaseByKey(5, "case");
        this.completeByActivity("ACTIVE");
        this.disableByActivity("AVAILABLE");
        this.reenableByActivity("AVAILABLE");
        this.manuallyStartByActivity("AVAILABLE");
        this.terminateByActivity("AVAILABLE");
        this.createCaseByKey(5, "case");
        this.terminateByActivity("ACTIVE");
        this.manuallyStartByActivity("ENABLED");
        this.completeByActivity("ENABLED");
        this.manuallyStartByActivity("DISABLED");
        this.terminateByActivity("DISABLED");
        this.createCaseByKey(2, "case");
        this.disableByActivity("DISABLED");
        HistoricCaseActivityStatisticsQuery query = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        List statistics = query.list();
        Assert.assertThat((Object)statistics.size(), (Matcher)Is.is((Object)6));
        Assert.assertEquals((long)query.count(), (long)6L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(0), "ACTIVE", 2L, 0L, 8L, 0L, 0L, 5L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(1), "AVAILABLE", 0L, 7L, 3L, 0L, 0L, 5L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(2), "COMPLETED", 15L, 0L, 0L, 0L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(3), "DISABLED", 0L, 0L, 0L, 2L, 0L, 13L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(4), "ENABLED", 0L, 0L, 13L, 0L, 2L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(5), "TERMINATED", 15L, 0L, 0L, 0L, 0L, 0L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/history/HistoricCaseActivityStatisticsQueryTest.testMultipleTasks.cmmn"})
    public void testMultipleCaseDefinitions() {
        String caseDefinitionId1 = this.getCaseDefinition("oneTaskCase").getId();
        String caseDefinitionId2 = this.getCaseDefinition("case").getId();
        this.createCaseByKey(5, "oneTaskCase");
        this.createCaseByKey(10, "case");
        HistoricCaseActivityStatisticsQuery query1 = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId1);
        HistoricCaseActivityStatisticsQuery query2 = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId2);
        Assert.assertThat((Object)query1.list().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)query2.list().size(), (Matcher)Is.is((Object)6));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricCaseActivityStatisticsQueryTest.testMultipleTasks.cmmn"})
    public void testPagination() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        this.createCaseByKey(5, "case");
        List statistics = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId).listPage(2, 1);
        Assert.assertThat((Object)statistics.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((HistoricCaseActivityStatistics)statistics.get(0)).getId(), (Matcher)Is.is((Object)"COMPLETED"));
    }

    protected void assertStatisitcs(HistoricCaseActivityStatistics statistics, String id, long active, long availabe, long completed, long disabled, long enabled, long terminated) {
        Assert.assertThat((Object)statistics.getId(), (Matcher)Is.is((Object)id));
        Assert.assertEquals((long)active, (long)statistics.getActive());
        Assert.assertEquals((long)availabe, (long)statistics.getAvailable());
        Assert.assertEquals((long)completed, (long)statistics.getCompleted());
        Assert.assertEquals((long)disabled, (long)statistics.getDisabled());
        Assert.assertEquals((long)enabled, (long)statistics.getEnabled());
        Assert.assertEquals((long)terminated, (long)statistics.getTerminated());
    }

    protected void createCaseByKey(int numberOfInstances, String key) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.caseService.createCaseInstanceByKey(key);
        }
    }

    protected CaseDefinition getCaseDefinition() {
        return (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
    }

    protected CaseDefinition getCaseDefinition(String key) {
        return (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).singleResult();
    }

    protected List<CaseExecution> getCaseExecutionsByActivity(String activityId) {
        return this.caseService.createCaseExecutionQuery().activityId(activityId).list();
    }

    protected void disableByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.disableCaseExecution(caseExecution.getId());
        }
    }

    protected void reenableByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.reenableCaseExecution(caseExecution.getId());
        }
    }

    protected void manuallyStartByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.manuallyStartCaseExecution(caseExecution.getId());
        }
    }

    protected void completeByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.completeCaseExecution(caseExecution.getId());
        }
    }

    protected void terminateByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.terminateCaseExecution(caseExecution.getId());
        }
    }
}

