/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;

@RequiredHistoryLevel(value="full")
public class HistoricIdentityLinkLogQueryTest
extends PluggableProcessEngineTestCase {
    private static final String A_USER_ID = "aUserId";
    private static final String A_GROUP_ID = "aGroupId";
    private static final int numberOfUsers = 3;
    private static final String A_ASSIGNER_ID = "aAssignerId";
    private static final String INVALID_USER_ID = "InvalidUserId";
    private static final String INVALID_TASK_ID = "InvalidTask";
    private static final String INVALID_GROUP_ID = "InvalidGroupId";
    private static final String INVALID_ASSIGNER_ID = "InvalidAssignerId";
    private static final String INVALID_HISTORY_EVENT_TYPE = "InvalidEventType";
    private static final String INVALID_IDENTITY_LINK_TYPE = "InvalidIdentityLinkType";
    private static final String INVALID_PROCESS_DEFINITION_ID = "InvalidProcessDefinitionId";
    private static final String INVALID_PROCESS_DEFINITION_KEY = "InvalidProcessDefinitionKey";
    private static final String GROUP_1 = "Group1";
    private static final String USER_1 = "User1";
    private static String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    private static String PROCESS_DEFINITION_KEY_MULTIPLE_CANDIDATE_USER = "oneTaskProcessForHistoricIdentityLinkWithMultipleCanidateUser";
    private static final String IDENTITY_LINK_ADD = "add";
    private static final String IDENTITY_LINK_DELETE = "delete";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLog historicIdentityLink = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getUserId(), (String)A_USER_ID);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getTaskId(), (String)taskId);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getType(), (String)"candidate");
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getAssignerId(), (String)A_ASSIGNER_ID);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getGroupId(), null);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getOperationType(), (String)IDENTITY_LINK_ADD);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getProcessDefinitionId(), (String)processInstance.getProcessDefinitionId());
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getProcessDefinitionKey(), (String)PROCESS_DEFINITION_KEY);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testGroupQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateGroup(taskId, A_GROUP_ID);
        HistoricIdentityLinkLog historicIdentityLink = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getUserId(), null);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getTaskId(), (String)taskId);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getType(), (String)"candidate");
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getAssignerId(), (String)A_ASSIGNER_ID);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getGroupId(), (String)A_GROUP_ID);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getOperationType(), (String)IDENTITY_LINK_ADD);
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getProcessDefinitionId(), (String)processInstance.getProcessDefinitionId());
        HistoricIdentityLinkLogQueryTest.assertEquals((String)historicIdentityLink.getProcessDefinitionKey(), (String)PROCESS_DEFINITION_KEY);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testValidIndividualQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.taskId(taskId).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.type("candidate").count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.userId(A_USER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.assignerId(A_ASSIGNER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionId(processInstance.getProcessDefinitionId()).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionKey(PROCESS_DEFINITION_KEY).count(), (long)2L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testValidGroupQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.taskId(taskId).count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.type("candidate").count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.userId(A_USER_ID).count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.assignerId(A_ASSIGNER_ID).count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionId(processInstance.getProcessDefinitionId()).count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionKey(PROCESS_DEFINITION_KEY).count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testInvalidIndividualQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.taskId(INVALID_TASK_ID).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.type(INVALID_IDENTITY_LINK_TYPE).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.userId(INVALID_USER_ID).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.groupId(INVALID_GROUP_ID).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.assignerId(INVALID_ASSIGNER_ID).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(INVALID_HISTORY_EVENT_TYPE).count(), (long)0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testInvalidGroupQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.taskId(INVALID_TASK_ID).count(), (long)0L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.type(INVALID_IDENTITY_LINK_TYPE).count(), (long)0L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.userId(INVALID_USER_ID).count(), (long)0L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.groupId(INVALID_GROUP_ID).count(), (long)0L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.assignerId(INVALID_ASSIGNER_ID).count(), (long)0L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(INVALID_HISTORY_EVENT_TYPE).count(), (long)0L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionId(INVALID_PROCESS_DEFINITION_ID).count(), (long)0L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionKey(INVALID_PROCESS_DEFINITION_KEY).count(), (long)0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddTaskOwnerForAddandDeleteIdentityLinkByTimeStamp() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.newYearMorning(0));
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.addUserIdentityLinks(taskId);
        ClockUtil.setCurrentTime((Date)this.newYearNoon(0));
        this.deleteUserIdentityLinks(taskId);
        ClockUtil.setCurrentTime((Date)this.newYearNoon(30));
        this.addUserIdentityLinks(taskId);
        ClockUtil.setCurrentTime((Date)this.newYearEvening());
        this.deleteUserIdentityLinks(taskId);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.dateBefore(this.newYearNoon(20)).count(), (long)6L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)3L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.dateBefore(this.newYearNoon(0)).count(), (long)6L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.dateAfter(this.newYearMorning(1)).count(), (long)1L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)0L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.dateAfter(this.newYearNoon(45)).count(), (long)1L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)0L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddAndRemoveIdentityLinksForProcessDefinition() throws Exception {
        ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        HistoricIdentityLinkLogQueryTest.assertNotNull((Object)latestProcessDef);
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)0, (int)links.size());
        this.repositoryService.addCandidateStarterGroup(latestProcessDef.getId(), GROUP_1);
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)historicIdentityLinks.size(), (int)1);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionId(latestProcessDef.getId()).count(), (long)1L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)1L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.groupId(GROUP_1).count(), (long)1L);
        this.repositoryService.addCandidateStarterUser(latestProcessDef.getId(), USER_1);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionId(latestProcessDef.getId()).count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionKey(latestProcessDef.getKey()).count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.userId(USER_1).count(), (long)1L);
        this.repositoryService.deleteCandidateStarterGroup(latestProcessDef.getId(), GROUP_1);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionId(latestProcessDef.getId()).count(), (long)3L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionKey(latestProcessDef.getKey()).count(), (long)3L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.groupId(GROUP_1).count(), (long)2L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        this.repositoryService.deleteCandidateStarterUser(latestProcessDef.getId(), USER_1);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionId(latestProcessDef.getId()).count(), (long)4L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.processDefinitionKey(latestProcessDef.getKey()).count(), (long)4L);
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.userId(USER_1).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)2L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithMultipleCandidateUser.bpmn20.xml"})
    public void testHistoricIdentityLinkQueryPaging() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY_MULTIPLE_CANDIDATE_USER);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)query.listPage(0, 4).size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)1, (int)query.listPage(2, 1).size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)2, (int)query.listPage(1, 2).size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)3, (int)query.listPage(1, 4).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithMultipleCandidateUser.bpmn20.xml"})
    public void testHistoricIdentityLinkQuerySorting() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogQueryTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY_MULTIPLE_CANDIDATE_USER);
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByAssignerId().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTime().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByGroupId().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByType().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByOperationType().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByProcessDefinitionId().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByProcessDefinitionKey().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTaskId().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTenantId().asc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((String)"aUser", (String)((HistoricIdentityLinkLog)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().asc()).list().get(0)).getUserId());
        HistoricIdentityLinkLogQueryTest.assertEquals((String)"dUser", (String)((HistoricIdentityLinkLog)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().asc()).list().get(3)).getUserId());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByAssignerId().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTime().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByGroupId().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByType().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByOperationType().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByProcessDefinitionId().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByProcessDefinitionKey().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTaskId().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((int)4, (int)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTenantId().desc()).list().size());
        HistoricIdentityLinkLogQueryTest.assertEquals((String)"dUser", (String)((HistoricIdentityLinkLog)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().desc()).list().get(0)).getUserId());
        HistoricIdentityLinkLogQueryTest.assertEquals((String)"aUser", (String)((HistoricIdentityLinkLog)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().desc()).list().get(3)).getUserId());
    }

    public void addUserIdentityLinks(String taskId) {
        for (int userIndex = 1; userIndex <= 3; ++userIndex) {
            this.taskService.addUserIdentityLink(taskId, A_USER_ID + userIndex, "assignee");
        }
    }

    public void deleteUserIdentityLinks(String taskId) {
        for (int userIndex = 1; userIndex <= 3; ++userIndex) {
            this.taskService.deleteUserIdentityLink(taskId, A_USER_ID + userIndex, "assignee");
        }
    }

    public Date newYearMorning(int minutes) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2016);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, minutes);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date morning = calendar.getTime();
        return morning;
    }

    public Date newYearNoon(int minutes) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2016);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 12);
        calendar.set(12, minutes);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date morning = calendar.getTime();
        return morning;
    }

    public Date newYearEvening() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2016);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 21);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date morning = calendar.getTime();
        return morning;
    }

    protected ProcessInstance startProcessInstance(String key) {
        return this.runtimeService.startProcessInstanceByKey(key);
    }
}

