/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;

@RequiredHistoryLevel(value="activity")
public class HistoricTaskInstanceUpdateTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testHistoricTaskInstanceUpdate() {
        this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setPriority(12345);
        task.setDescription("Updated description");
        task.setName("Updated name");
        task.setAssignee("gonzo");
        this.taskService.saveTask(task);
        this.taskService.complete(task.getId());
        HistoricTaskInstanceUpdateTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceUpdateTest.assertEquals((String)"Updated name", (String)historicTaskInstance.getName());
        HistoricTaskInstanceUpdateTest.assertEquals((String)"Updated description", (String)historicTaskInstance.getDescription());
        HistoricTaskInstanceUpdateTest.assertEquals((String)"gonzo", (String)historicTaskInstance.getAssignee());
        HistoricTaskInstanceUpdateTest.assertEquals((String)"task", (String)historicTaskInstance.getTaskDefinitionKey());
    }
}

