/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.AcquireJobsCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.RecordingAcquireJobsRunnable;

public class ControllableJobExecutor
extends JobExecutor {
    protected ConcurrencyTestCase.ThreadControl acquisitionThreadControl;
    protected ConcurrencyTestCase.ThreadControl executionThreadControl;
    protected boolean syncOnShutdown = true;
    protected boolean syncAsSuspendEnabled;
    protected boolean shouldThrowOle;
    protected boolean oleThrown;

    public ControllableJobExecutor() {
        this.acquireJobsRunnable = new RecordingAcquireJobsRunnable(this);
        this.jobAcquisitionThread = new Thread((Runnable)this.acquireJobsRunnable);
        this.acquisitionThreadControl = new ConcurrencyTestCase.ThreadControl(this.jobAcquisitionThread);
        this.executionThreadControl = new ConcurrencyTestCase.ThreadControl(this.jobAcquisitionThread);
        this.acquireJobsCmdFactory = new ControllableJobAcquisitionCommandFactory();
    }

    public ControllableJobExecutor(ProcessEngineImpl processEngine) {
        this();
        this.processEngines.add(processEngine);
    }

    public ControllableJobExecutor(boolean syncAsSuspendEnabled) {
        this();
        this.syncAsSuspendEnabled = syncAsSuspendEnabled;
    }

    public boolean isSyncAsSuspendEnabled() {
        return this.syncAsSuspendEnabled;
    }

    public ControllableJobExecutor proceedAndWaitOnShutdown(boolean syncOnShutdown) {
        this.syncOnShutdown = syncOnShutdown;
        return this;
    }

    protected void ensureInitialization() {
    }

    public ConcurrencyTestCase.ThreadControl getAcquisitionThreadControl() {
        return this.acquisitionThreadControl;
    }

    public ConcurrencyTestCase.ThreadControl getExecutionThreadControl() {
        return this.executionThreadControl;
    }

    protected void startExecutingJobs() {
        this.jobAcquisitionThread.start();
    }

    protected void stopExecutingJobs() {
        if (this.syncOnShutdown) {
            this.acquisitionThreadControl.waitUntilDone(true);
        }
    }

    public RecordingAcquireJobsRunnable getAcquireJobsRunnable() {
        return (RecordingAcquireJobsRunnable)super.getAcquireJobsRunnable();
    }

    public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
        this.getExecuteJobsRunnable(jobIds, processEngine).run();
    }

    public void indicateOptimisticLockingException() {
        this.shouldThrowOle = true;
    }

    public boolean isOleThrown() {
        return this.oleThrown;
    }

    public void resetOleThrown() {
        this.oleThrown = false;
    }

    public class ControllableAcquisitionCommand
    extends ConcurrencyTestCase.ControllableCommand<AcquiredJobs> {
        protected int numJobsToAcquire;

        public ControllableAcquisitionCommand(ConcurrencyTestCase.ThreadControl threadControl, int numJobsToAcquire) {
            super(threadControl);
            this.numJobsToAcquire = numJobsToAcquire;
        }

        public AcquiredJobs execute(CommandContext commandContext) {
            if (ControllableJobExecutor.this.shouldThrowOle) {
                this.rethrowOptimisticLockingException(commandContext);
            }
            this.monitor.sync();
            AcquiredJobs acquiredJobs = new AcquireJobsCmd((JobExecutor)ControllableJobExecutor.this, this.numJobsToAcquire).execute(commandContext);
            this.monitor.sync();
            return acquiredJobs;
        }

        protected void rethrowOptimisticLockingException(CommandContext commandContext) {
            commandContext.getDbEntityManager().registerOptimisticLockingListener(new OptimisticLockingListener(){

                public Class<? extends DbEntity> getEntityType() {
                    return JobEntity.class;
                }

                public void failedOperation(DbOperation operation) {
                    ControllableJobExecutor.this.oleThrown = true;
                }
            });
        }
    }

    public class ControllableJobAcquisitionCommandFactory
    implements AcquireJobsCommandFactory {
        public Command<AcquiredJobs> getCommand(int numJobsToAcquire) {
            return new ControllableAcquisitionCommand(ControllableJobExecutor.this.acquisitionThreadControl, numJobsToAcquire);
        }
    }
}

