/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class JobDefinitionDeploymentTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testTimerStartEvent() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-start-event", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theStart", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DATE: 2036-11-14T11:12:22", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
        Job timerStartJob = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionDeploymentTest.assertEquals((String)jobDefinition.getId(), (String)timerStartJob.getJobDefinitionId());
    }

    @Deployment
    public void testTimerBoundaryEvent() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theBoundaryEvent", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DATE: 2036-11-14T11:12:22", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testMultipleTimerBoundaryEvents() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess");
        JobDefinitionDeploymentTest.assertEquals((long)2L, (long)jobDefinitionQuery.count());
        JobDefinition jobDefinition = (JobDefinition)jobDefinitionQuery.activityIdIn(new String[]{"theBoundaryEvent1"}).singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theBoundaryEvent1", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DATE: 2036-11-14T11:12:22", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
        jobDefinition = (JobDefinition)jobDefinitionQuery.activityIdIn(new String[]{"theBoundaryEvent2"}).singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theBoundaryEvent2", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DURATION: PT5M", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testEventBasedGateway() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess");
        JobDefinitionDeploymentTest.assertEquals((long)2L, (long)jobDefinitionQuery.count());
        JobDefinition jobDefinition = (JobDefinition)jobDefinitionQuery.activityIdIn(new String[]{"timer1"}).singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-intermediate-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"timer1", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DURATION: PT5M", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
        jobDefinition = (JobDefinition)jobDefinitionQuery.activityIdIn(new String[]{"timer2"}).singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-intermediate-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"timer2", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DURATION: PT10M", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testTimerIntermediateEvent() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-intermediate-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"timer", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DURATION: PT5M", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testAsyncContinuation() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"async-continuation", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theService", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"async-before", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testAsyncContinuationOfMultiInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"async-continuation", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theService#multiInstanceBody", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"async-after", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testAsyncContinuationOfActivityWrappedInMultiInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"async-continuation", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theService", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"async-after", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testAsyncContinuation.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testMultipleProcessesWithinDeployment.bpmn20.xml"})
    public void testMultipleProcessDeployment() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        List jobDefinitions = query.list();
        JobDefinitionDeploymentTest.assertEquals((int)3, (int)jobDefinitions.size());
        JobDefinitionDeploymentTest.assertEquals((int)1, (int)query.processDefinitionKey("testProcess").list().size());
        JobDefinitionDeploymentTest.assertEquals((int)2, (int)query.processDefinitionKey("anotherTestProcess").list().size());
    }
}

