/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.ExecuteJobHelper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JobExecutorExceptionLoggingHandlerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToReplaceLoggingHandler() {
        ExecuteJobHelper.ExceptionLoggingHandler originalHandler = ExecuteJobHelper.LOGGING_HANDLER;
        CollectingHandler collectingHandler = new CollectingHandler();
        RuntimeException exception = new RuntimeException();
        try {
            ExecuteJobHelper.LOGGING_HANDLER = collectingHandler;
            CommandExecutor failingCommandExecutor = (CommandExecutor)Mockito.mock(CommandExecutor.class);
            Mockito.when((Object)failingCommandExecutor.execute((Command)Mockito.any(Command.class))).thenThrow(new Throwable[]{exception});
            ExecuteJobHelper.executeJob((String)"10", (CommandExecutor)failingCommandExecutor);
            Assert.fail((String)"exception expected");
        }
        catch (RuntimeException e) {
            Throwable collectedException = collectingHandler.collectedExceptions.get("10");
            Assert.assertEquals((Object)collectedException, (Object)e);
            Assert.assertEquals((Object)collectedException, (Object)exception);
        }
        finally {
            ExecuteJobHelper.LOGGING_HANDLER = originalHandler;
        }
    }

    static class CollectingHandler
    implements ExecuteJobHelper.ExceptionLoggingHandler {
        Map<String, Throwable> collectedExceptions = new HashMap<String, Throwable>();

        CollectingHandler() {
        }

        public void exceptionWhileExecutingJob(String jobId, Throwable exception) {
            this.collectedExceptions.put(jobId, exception);
        }
    }
}

