/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.deploy;

import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.standalone.deploy.TestBPMNParseListener;

public class BPMNParseListenerTest
extends ResourceProcessEngineTestCase {
    public BPMNParseListenerTest() {
        super("org/camunda/bpm/engine/test/standalone/deploy/bpmn.parse.listener.camunda.cfg.xml");
    }

    @Deployment
    public void testAlterProcessDefinitionKeyWhenDeploying() throws Exception {
        BPMNParseListenerTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").count());
        BPMNParseListenerTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess-modified").count());
    }

    @Deployment
    public void testAlterActivityBehaviors() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskWithIntermediateThrowEvent-modified");
        ProcessDefinitionEntity processDefinition = ((ProcessInstanceWithVariablesImpl)processInstance).getExecutionEntity().getProcessDefinition();
        ActivityImpl cancelThrowEvent = processDefinition.findActivity("CancelthrowEvent");
        BPMNParseListenerTest.assertTrue((boolean)(cancelThrowEvent.getActivityBehavior() instanceof TestBPMNParseListener.TestCompensationEventActivityBehavior));
        ActivityImpl startEvent = processDefinition.findActivity("theStart");
        BPMNParseListenerTest.assertTrue((boolean)(startEvent.getActivityBehavior() instanceof TestBPMNParseListener.TestNoneStartEventActivityBehavior));
        ActivityImpl endEvent = processDefinition.findActivity("theEnd");
        BPMNParseListenerTest.assertTrue((boolean)(endEvent.getActivityBehavior() instanceof TestBPMNParseListener.TestNoneEndEventActivityBehavior));
    }
}

