/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.pvm;

import java.util.ArrayList;
import org.camunda.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.test.standalone.pvm.activities.Automatic;
import org.camunda.bpm.engine.test.standalone.pvm.activities.End;
import org.camunda.bpm.engine.test.standalone.pvm.activities.WaitState;
import org.camunda.bpm.engine.test.standalone.pvm.activities.While;

public class PvmBasicLinearExecutionTest
extends PvmTestCase {
    public void testStartEnd() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmBasicLinearExecutionTest.assertEquals(new ArrayList(), (Object)processInstance.findActiveActivityIds());
        PvmBasicLinearExecutionTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testSingleAutomatic() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("one").initial().behavior((ActivityBehavior)new Automatic()).transition("two").endActivity().createActivity("two").behavior((ActivityBehavior)new Automatic()).transition("three").endActivity().createActivity("three").behavior((ActivityBehavior)new End()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmBasicLinearExecutionTest.assertEquals(new ArrayList(), (Object)processInstance.findActiveActivityIds());
        PvmBasicLinearExecutionTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testSingleWaitState() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("one").initial().behavior((ActivityBehavior)new Automatic()).transition("two").endActivity().createActivity("two").behavior((ActivityBehavior)new WaitState()).transition("three").endActivity().createActivity("three").behavior((ActivityBehavior)new End()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmExecution activityInstance = processInstance.findExecution("two");
        PvmBasicLinearExecutionTest.assertNotNull((Object)activityInstance);
        activityInstance.signal(null, null);
        PvmBasicLinearExecutionTest.assertEquals(new ArrayList(), (Object)processInstance.findActiveActivityIds());
        PvmBasicLinearExecutionTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testCombinationOfWaitStatesAndAutomatics() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("one").endActivity().createActivity("one").behavior((ActivityBehavior)new WaitState()).transition("two").endActivity().createActivity("two").behavior((ActivityBehavior)new WaitState()).transition("three").endActivity().createActivity("three").behavior((ActivityBehavior)new Automatic()).transition("four").endActivity().createActivity("four").behavior((ActivityBehavior)new Automatic()).transition("five").endActivity().createActivity("five").behavior((ActivityBehavior)new End()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmExecution activityInstance = processInstance.findExecution("one");
        PvmBasicLinearExecutionTest.assertNotNull((Object)activityInstance);
        activityInstance.signal(null, null);
        activityInstance = processInstance.findExecution("two");
        PvmBasicLinearExecutionTest.assertNotNull((Object)activityInstance);
        activityInstance.signal(null, null);
        PvmBasicLinearExecutionTest.assertEquals(new ArrayList(), (Object)processInstance.findActiveActivityIds());
        PvmBasicLinearExecutionTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testWhileLoop() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("loop").endActivity().createActivity("loop").behavior((ActivityBehavior)new While("count", 0, 10)).transition("one", "more").transition("end", "done").endActivity().createActivity("one").behavior((ActivityBehavior)new Automatic()).transition("two").endActivity().createActivity("two").behavior((ActivityBehavior)new Automatic()).transition("three").endActivity().createActivity("three").behavior((ActivityBehavior)new Automatic()).transition("loop").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmBasicLinearExecutionTest.assertEquals(new ArrayList(), (Object)processInstance.findActiveActivityIds());
        PvmBasicLinearExecutionTest.assertTrue((boolean)processInstance.isEnded());
    }
}

