/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.testing;

import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ProcessEngineRuleJunit4Test {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();

    @Test
    @Deployment
    public void ruleUsageExample() {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        runtimeService.startProcessInstanceByKey("ruleUsage");
        TaskService taskService = this.engineRule.getTaskService();
        Task task = (Task)taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"My Task", (Object)task.getName());
        taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)runtimeService.createProcessInstanceQuery().count());
    }

    @Test
    public void testWithoutDeploymentAnnotation() {
        Assert.assertEquals((Object)"aString", (Object)"aString");
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void requiredHistoryLevelAudit() {
        Assert.assertThat((Object)this.currentHistoryLevel(), (Matcher)CoreMatchers.either((Matcher)CoreMatchers.is((Object)"audit")).or(CoreMatchers.is((Object)"full")));
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void requiredHistoryLevelActivity() {
        Assert.assertThat((Object)this.currentHistoryLevel(), (Matcher)CoreMatchers.either((Matcher)CoreMatchers.is((Object)"activity")).or(CoreMatchers.is((Object)"audit")).or(CoreMatchers.is((Object)"full")));
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void requiredHistoryLevelFull() {
        Assert.assertThat((Object)this.currentHistoryLevel(), (Matcher)CoreMatchers.is((Object)"full"));
    }

    protected String currentHistoryLevel() {
        return this.engineRule.getProcessEngine().getProcessEngineConfiguration().getHistory();
    }
}

