/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.IncidentQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;

public class IncidentQueryImpl
extends AbstractQuery<IncidentQuery, Incident>
implements IncidentQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String incidentType;
    protected String incidentMessage;
    protected String executionId;
    protected String activityId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected String[] tenantIds;
    protected String[] jobDefinitionIds;

    public IncidentQueryImpl() {
    }

    public IncidentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public IncidentQuery incidentId(String incidentId) {
        this.id = incidentId;
        return this;
    }

    @Override
    public IncidentQuery incidentType(String incidentType) {
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public IncidentQuery incidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public IncidentQuery executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public IncidentQuery activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Override
    public IncidentQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public IncidentQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public IncidentQuery causeIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
        return this;
    }

    @Override
    public IncidentQuery rootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
        return this;
    }

    @Override
    public IncidentQuery configuration(String configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public IncidentQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public IncidentQuery jobDefinitionIdIn(String ... jobDefinitionIds) {
        EnsureUtil.ensureNotNull("jobDefinitionIds", jobDefinitionIds);
        this.jobDefinitionIds = jobDefinitionIds;
        return this;
    }

    @Override
    public IncidentQuery orderByIncidentId() {
        this.orderBy(IncidentQueryProperty.INCIDENT_ID);
        return this;
    }

    @Override
    public IncidentQuery orderByIncidentTimestamp() {
        this.orderBy(IncidentQueryProperty.INCIDENT_TIMESTAMP);
        return this;
    }

    @Override
    public IncidentQuery orderByIncidentType() {
        this.orderBy(IncidentQueryProperty.INCIDENT_TYPE);
        return this;
    }

    @Override
    public IncidentQuery orderByExecutionId() {
        this.orderBy(IncidentQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public IncidentQuery orderByActivityId() {
        this.orderBy(IncidentQueryProperty.ACTIVITY_ID);
        return this;
    }

    @Override
    public IncidentQuery orderByProcessInstanceId() {
        this.orderBy(IncidentQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public IncidentQuery orderByProcessDefinitionId() {
        this.orderBy(IncidentQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public IncidentQuery orderByCauseIncidentId() {
        this.orderBy(IncidentQueryProperty.CAUSE_INCIDENT_ID);
        return this;
    }

    @Override
    public IncidentQuery orderByRootCauseIncidentId() {
        this.orderBy(IncidentQueryProperty.ROOT_CAUSE_INCIDENT_ID);
        return this;
    }

    @Override
    public IncidentQuery orderByConfiguration() {
        this.orderBy(IncidentQueryProperty.CONFIGURATION);
        return this;
    }

    @Override
    public IncidentQuery orderByTenantId() {
        return (IncidentQuery)this.orderBy(IncidentQueryProperty.TENANT_ID);
    }

    @Override
    public IncidentQuery orderByIncidentMessage() {
        return (IncidentQuery)this.orderBy(IncidentQueryProperty.INCIDENT_MESSAGE);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getIncidentManager().findIncidentCountByQueryCriteria(this);
    }

    @Override
    public List<Incident> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getIncidentManager().findIncidentByQueryCriteria(this, page);
    }
}

