/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.MessageEventReceivedCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionVariableSnapshotObserver;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandlerResult;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResultImpl;
import org.camunda.bpm.engine.runtime.MessageCorrelationResultType;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public abstract class AbstractCorrelateMessageCmd {
    protected final String messageName;
    protected final MessageCorrelationBuilderImpl builder;
    protected ExecutionVariableSnapshotObserver variablesListener;
    protected boolean variablesEnabled;

    protected AbstractCorrelateMessageCmd(MessageCorrelationBuilderImpl builder) {
        this.builder = builder;
        this.messageName = builder.getMessageName();
    }

    protected AbstractCorrelateMessageCmd(MessageCorrelationBuilderImpl builder, boolean variablesEnabled) {
        this(builder);
        this.variablesEnabled = variablesEnabled;
    }

    protected void triggerExecution(CommandContext commandContext, CorrelationHandlerResult correlationResult) {
        String executionId = correlationResult.getExecutionEntity().getId();
        MessageEventReceivedCmd command = new MessageEventReceivedCmd(this.messageName, executionId, this.builder.getPayloadProcessInstanceVariables(), (Map<String, Object>)this.builder.getPayloadProcessInstanceVariablesLocal(), this.builder.isExclusiveCorrelation());
        command.execute(commandContext);
    }

    protected ProcessInstance instantiateProcess(CommandContext commandContext, CorrelationHandlerResult correlationResult) {
        ProcessDefinitionEntity processDefinitionEntity = correlationResult.getProcessDefinitionEntity();
        ActivityImpl messageStartEvent = processDefinitionEntity.findActivity(correlationResult.getStartEventActivityId());
        ExecutionEntity processInstance = processDefinitionEntity.createProcessInstance(this.builder.getBusinessKey(), messageStartEvent);
        if (this.variablesEnabled) {
            this.variablesListener = new ExecutionVariableSnapshotObserver(processInstance, false);
        }
        processInstance.setVariablesLocal((Map<String, ? extends Object>)this.builder.getPayloadProcessInstanceVariablesLocal());
        processInstance.start(this.builder.getPayloadProcessInstanceVariables());
        return processInstance;
    }

    protected void checkAuthorization(CorrelationHandlerResult correlation) {
        CommandContext commandContext = Context.getCommandContext();
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            if (MessageCorrelationResultType.Execution.equals((Object)correlation.getResultType())) {
                ExecutionEntity execution = correlation.getExecutionEntity();
                checker.checkUpdateProcessInstanceById(execution.getProcessInstanceId());
                continue;
            }
            ProcessDefinitionEntity definition = correlation.getProcessDefinitionEntity();
            checker.checkCreateProcessInstance(definition);
        }
    }

    protected MessageCorrelationResultImpl createMessageCorrelationResult(CommandContext commandContext, CorrelationHandlerResult handlerResult) {
        MessageCorrelationResultImpl resultWithVariables = new MessageCorrelationResultImpl(handlerResult);
        if (MessageCorrelationResultType.Execution.equals((Object)handlerResult.getResultType())) {
            ExecutionEntity execution = this.findProcessInstanceExecution(commandContext, handlerResult);
            if (this.variablesEnabled && execution != null) {
                this.variablesListener = new ExecutionVariableSnapshotObserver(execution, false);
            }
            this.triggerExecution(commandContext, handlerResult);
        } else {
            ProcessInstance instance = this.instantiateProcess(commandContext, handlerResult);
            resultWithVariables.setProcessInstance(instance);
        }
        if (this.variablesListener != null) {
            resultWithVariables.setVariables(this.variablesListener.getVariables());
        }
        return resultWithVariables;
    }

    protected ExecutionEntity findProcessInstanceExecution(CommandContext commandContext, CorrelationHandlerResult handlerResult) {
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(handlerResult.getExecution().getProcessInstanceId());
        return execution;
    }
}

