/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SaveAuthorizationCmd
implements Command<Authorization> {
    protected AuthorizationEntity authorization;

    public SaveAuthorizationCmd(Authorization authorization) {
        this.authorization = (AuthorizationEntity)authorization;
        this.validate();
    }

    protected void validate() {
        EnsureUtil.ensureOnlyOneNotNull("Authorization must either have a 'userId' or a 'groupId'.", this.authorization.getUserId(), this.authorization.getGroupId());
        EnsureUtil.ensureNotNull("Authorization 'resourceType' cannot be null.", "authorization.getResource()", (Object)this.authorization.getResource());
    }

    @Override
    public Authorization execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.validateResourceCompatibility(this.authorization);
        String operationType = null;
        if (this.authorization.getId() == null) {
            authorizationManager.insert(this.authorization);
            operationType = "Create";
        } else {
            authorizationManager.update(this.authorization);
            operationType = "Update";
        }
        commandContext.getOperationLogManager().logAuthorizationOperation(operationType, this.authorization);
        return this.authorization;
    }
}

