/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractIDBasedBatchCmd;
import org.camunda.bpm.engine.impl.history.SetRemovalTimeToHistoricProcessInstancesAsyncBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricProcessInstancesCmd
extends AbstractIDBasedBatchCmd<Batch> {
    protected SetRemovalTimeToHistoricProcessInstancesAsyncBuilderImpl builder;

    public SetRemovalTimeToHistoricProcessInstancesCmd(SetRemovalTimeToHistoricProcessInstancesAsyncBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        HistoricProcessInstanceQuery instanceQuery = this.builder.getQuery();
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "query", (Object)instanceQuery);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "removalTime", (Object)this.builder.getMode());
        List historicProcessInstances = instanceQuery.list();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicProcessInstances", historicProcessInstances);
        ArrayList<String> historicProcessInstanceIds = new ArrayList<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            historicProcessInstanceIds.add(historicProcessInstance.getId());
        }
        BatchEntity batch = this.createBatch(commandContext, historicProcessInstanceIds);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    @Override
    protected BatchConfiguration getAbstractIdsBatchConfiguration(List<String> ids) {
        return new SetRemovalTimeBatchConfiguration(ids).setHierarchical(this.builder.isHierarchical()).setHasRemovalTime(this.builder.getMode() == SetRemovalTimeToHistoricProcessInstancesAsyncBuilderImpl.Mode.ABSOLUTE_REMOVAL_TIME).setRemovalTime(this.builder.getRemovalTime());
    }

    @Override
    protected BatchJobHandler getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("process-set-removal-time");
    }
}

