/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history;

import java.util.Date;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.SetRemovalTimeToHistoricProcessInstancesAsyncBuilder;
import org.camunda.bpm.engine.impl.cmd.batch.SetRemovalTimeToHistoricProcessInstancesCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;

public class SetRemovalTimeToHistoricProcessInstancesAsyncBuilderImpl
implements SetRemovalTimeToHistoricProcessInstancesAsyncBuilder {
    protected HistoricProcessInstanceQuery query;
    protected Date removalTime;
    protected Mode mode = null;
    protected boolean isHierarchical;
    protected CommandExecutor commandExecutor;

    public SetRemovalTimeToHistoricProcessInstancesAsyncBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesAsyncBuilder byQuery(HistoricProcessInstanceQuery query) {
        this.query = query;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesAsyncBuilder absoluteRemovalTime(Date removalTime) {
        this.mode = Mode.ABSOLUTE_REMOVAL_TIME;
        this.removalTime = removalTime;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesAsyncBuilder calculatedRemovalTime() {
        this.mode = Mode.CALCULATED_REMOVAL_TIME;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesAsyncBuilder hierarchical() {
        this.isHierarchical = true;
        return this;
    }

    @Override
    public Batch executeAsync() {
        return this.commandExecutor.execute(new SetRemovalTimeToHistoricProcessInstancesCmd(this));
    }

    public HistoricProcessInstanceQuery getQuery() {
        return this.query;
    }

    public Date getRemovalTime() {
        return this.removalTime;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isHierarchical() {
        return this.isHierarchical;
    }

    public static enum Mode {
        CALCULATED_REMOVAL_TIME,
        ABSOLUTE_REMOVAL_TIME;

    }
}

