/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.optimize;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;

public class OptimizeManager
extends AbstractManager {
    public List<ByteArrayEntity> getHistoricVariableUpdateByteArrays(List<String> byteArrayIds) {
        return this.getDbEntityManager().selectList("selectByteArrays", byteArrayIds);
    }

    public List<HistoricActivityInstance> getCompletedHistoricActivityInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryOfProcessDefinitions();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("finishedAfter", finishedAfter);
        params.put("finishedAt", finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricActivityPage", params);
    }

    public List<HistoricActivityInstance> getRunningHistoricActivityInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryOfProcessDefinitions();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("startedAfter", startedAfter);
        params.put("startedAt", startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricActivityPage", params);
    }

    public List<HistoricTaskInstance> getCompletedHistoricTaskInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryOfProcessDefinitions();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("finishedAfter", finishedAfter);
        params.put("finishedAt", finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricTaskInstancePage", params);
    }

    public List<HistoricTaskInstance> getRunningHistoricTaskInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryOfProcessDefinitions();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("startedAfter", startedAfter);
        params.put("startedAt", startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricTaskInstancePage", params);
    }

    public List<UserOperationLogEntry> getHistoricUserOperationLogs(Date occurredAfter, Date occurredAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryOfProcessDefinitions();
        String[] operationTypes = new String[]{"Assign", "Claim", "Complete"};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("occurredAfter", occurredAfter);
        params.put("occurredAt", occurredAt);
        params.put("operationTypes", operationTypes);
        params.put("maxResults", maxResults);
        return this.getDbEntityManager().selectList("selectHistoricUserOperationLogPage", params);
    }

    private void checkIsAuthorizedToReadHistoryOfProcessDefinitions() {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION);
    }

    public List<HistoricProcessInstance> getCompletedHistoricProcessInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryOfProcessDefinitions();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("finishedAfter", finishedAfter);
        params.put("finishedAt", finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricProcessInstancePage", params);
    }

    public List<HistoricProcessInstance> getRunningHistoricProcessInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryOfProcessDefinitions();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("startedAfter", startedAfter);
        params.put("startedAt", startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricProcessInstancePage", params);
    }

    public List<HistoricVariableUpdate> getHistoricVariableUpdates(Date occurredAfter, Date occurredAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryOfProcessDefinitions();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("occurredAfter", occurredAfter);
        params.put("occurredAt", occurredAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectHistoricVariableUpdatePage", params);
    }

    public List<HistoricDecisionInstance> getHistoricDecisionInstances(Date evaluatedAfter, Date evaluatedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryOfDecisionDefinitions();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("evaluatedAfter", evaluatedAfter);
        params.put("evaluatedAt", evaluatedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        List decisionInstances = this.getDbEntityManager().selectList("selectHistoricDecisionInstancePage", params);
        HistoricDecisionInstanceQueryImpl query = (HistoricDecisionInstanceQueryImpl)new HistoricDecisionInstanceQueryImpl().disableBinaryFetching().disableCustomObjectDeserialization().includeInputs().includeOutputs();
        this.getHistoricDecisionInstanceManager().enrichHistoricDecisionsWithInputsAndOutputs(query, decisionInstances);
        return decisionInstances;
    }

    private void checkIsAuthorizedToReadHistoryOfDecisionDefinitions() {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.DECISION_DEFINITION);
    }
}

