/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;

public class ResourceTypeUtil {
    private static final Map<Integer, Class<? extends Enum<? extends Permission>>> PERMISSION_ENUMS = new HashMap<Integer, Class<? extends Enum<? extends Permission>>>();

    public static boolean resourceIsContainedInArray(Integer resourceTypeId, Resource[] resources) {
        for (Resource resource : resources) {
            if (resourceTypeId.intValue() != resource.resourceType()) continue;
            return true;
        }
        return false;
    }

    public static Map<Integer, Class<? extends Enum<? extends Permission>>> getPermissionEnums() {
        return PERMISSION_ENUMS;
    }

    public static Permission[] getPermissionsByResourceType(int givenResourceType) {
        Class<? extends Enum<? extends Permission>> clazz = PERMISSION_ENUMS.get(givenResourceType);
        if (clazz == null) {
            return Permissions.values();
        }
        return (Permission[])clazz.getEnumConstants();
    }

    public static Permission getPermissionByNameAndResourceType(String permissionName, int resourceType) {
        for (Permission permission : ResourceTypeUtil.getPermissionsByResourceType(resourceType)) {
            if (!permission.getName().equals(permissionName)) continue;
            return permission;
        }
        throw new BadUserRequestException(String.format("The permission '%s' is not valid for '%s' resource type.", permissionName, ResourceTypeUtil.getResourceByType(resourceType)));
    }

    public static Resource getResourceByType(int resourceType) {
        for (Resources resource : Resources.values()) {
            if (resource.resourceType() != resourceType) continue;
            return resource;
        }
        return null;
    }

    static {
        PERMISSION_ENUMS.put(Resources.BATCH.resourceType(), BatchPermissions.class);
        PERMISSION_ENUMS.put(Resources.PROCESS_DEFINITION.resourceType(), ProcessDefinitionPermissions.class);
        PERMISSION_ENUMS.put(Resources.PROCESS_INSTANCE.resourceType(), ProcessInstancePermissions.class);
        PERMISSION_ENUMS.put(Resources.TASK.resourceType(), TaskPermissions.class);
        for (Resources resource : Resources.values()) {
            int resourceType = resource.resourceType();
            if (PERMISSION_ENUMS.containsKey(resourceType)) continue;
            PERMISSION_ENUMS.put(resourceType, Permissions.class);
        }
    }
}

