/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManagerFactory;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.SchemaLogEntryEntity;
import org.camunda.bpm.engine.management.SchemaLogEntry;
import org.camunda.bpm.engine.management.SchemaLogQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SchemaLogQueryTest {
    @Rule
    public ProcessEngineRule engineRule = new ProcessEngineRule();
    ManagementService managementService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    SchemaLogEntryEntity dummySchemaLogEntry;
    long initialEntryCount;

    @Before
    public void init() {
        this.managementService = this.engineRule.getManagementService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.initialEntryCount = this.managementService.createSchemaLogQuery().count();
        this.dummySchemaLogEntry = this.createDummySchemaLogEntry();
    }

    @Test
    public void testQuerySchemaLogEntryList() {
        List schemaLogEntries = this.managementService.createSchemaLogQuery().list();
        Assert.assertThat((Object)this.managementService.createSchemaLogQuery().count(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        SchemaLogEntry schemaLogEntry = (SchemaLogEntry)schemaLogEntries.get(0);
        Assert.assertThat((Object)schemaLogEntry.getId(), (Matcher)CoreMatchers.is((Object)"0"));
        Assert.assertThat((Object)schemaLogEntry.getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)schemaLogEntry.getVersion(), (Matcher)CoreMatchers.notNullValue());
        this.managementService.getProperties();
        this.cleanupTable();
    }

    @Test
    public void testOrderByTimestamp() {
        this.populateTable();
        TestOrderingUtil.verifySorting(((SchemaLogQuery)this.managementService.createSchemaLogQuery().orderByTimestamp().asc()).list(), TestOrderingUtil.schemaLogEntryByTimestamp());
        TestOrderingUtil.verifySorting(((SchemaLogQuery)this.managementService.createSchemaLogQuery().orderByTimestamp().desc()).list(), TestOrderingUtil.inverted(TestOrderingUtil.schemaLogEntryByTimestamp()));
        this.cleanupTable();
    }

    @Test
    public void testFilterByVersion() {
        this.populateTable();
        SchemaLogEntry schemaLogEntry = (SchemaLogEntry)this.managementService.createSchemaLogQuery().version("dummyVersion").singleResult();
        Assert.assertThat((Object)schemaLogEntry.getId(), (Matcher)CoreMatchers.is((Object)this.dummySchemaLogEntry.getId()));
        Assert.assertThat((Object)schemaLogEntry.getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)schemaLogEntry.getVersion(), (Matcher)CoreMatchers.is((Object)this.dummySchemaLogEntry.getVersion()));
        this.cleanupTable();
    }

    @Test
    public void testSortedPagedQuery() {
        this.populateTable();
        List schemaLogEntry = ((SchemaLogQuery)this.managementService.createSchemaLogQuery().orderByTimestamp().asc()).listPage(0, 1);
        Assert.assertThat((Object)schemaLogEntry.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((SchemaLogEntry)schemaLogEntry.get(0)).getId(), (Matcher)CoreMatchers.is((Object)"0"));
        schemaLogEntry = ((SchemaLogQuery)this.managementService.createSchemaLogQuery().orderByTimestamp().asc()).listPage(1, 1);
        Assert.assertThat((Object)schemaLogEntry.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((SchemaLogEntry)schemaLogEntry.get(0)).getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"0")));
        schemaLogEntry = ((SchemaLogQuery)this.managementService.createSchemaLogQuery().orderByTimestamp().desc()).listPage(0, 1);
        Assert.assertThat((Object)schemaLogEntry.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((SchemaLogEntry)schemaLogEntry.get(0)).getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"0")));
        schemaLogEntry = ((SchemaLogQuery)this.managementService.createSchemaLogQuery().orderByTimestamp().desc()).listPage(1, 1);
        Assert.assertThat((Object)schemaLogEntry.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((SchemaLogEntry)schemaLogEntry.get(0)).getId(), (Matcher)CoreMatchers.is((Object)"0"));
        this.cleanupTable();
    }

    private void populateTable() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                DbEntityManagerFactory dbEntityManagerFactory = new DbEntityManagerFactory(Context.getProcessEngineConfiguration().getIdGenerator());
                DbEntityManager newEntityManager = dbEntityManagerFactory.openSession();
                newEntityManager.insert((DbEntity)SchemaLogQueryTest.this.dummySchemaLogEntry);
                newEntityManager.flush();
                return null;
            }
        });
        Assert.assertThat((Object)this.managementService.createSchemaLogQuery().count(), (Matcher)CoreMatchers.is((Object)(this.initialEntryCount + 1L)));
    }

    private void cleanupTable() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
                dbEntityManager.delete((DbEntity)SchemaLogQueryTest.this.dummySchemaLogEntry);
                dbEntityManager.flush();
                return null;
            }
        });
        Assert.assertThat((Object)this.managementService.createSchemaLogQuery().count(), (Matcher)CoreMatchers.is((Object)this.initialEntryCount));
    }

    private SchemaLogEntryEntity createDummySchemaLogEntry() {
        SchemaLogEntryEntity dummy = new SchemaLogEntryEntity();
        dummy.setId("uniqueId");
        dummy.setTimestamp(new Date());
        dummy.setVersion("dummyVersion");
        return dummy;
    }
}

