/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ExternalTaskModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricExternalTaskLogTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ExternalTaskService externalTaskService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected final String TENANT_ONE = "tenant1";
    protected final String TENANT_TWO = "tenant2";
    protected final String WORKER_ID = "aWorkerId";
    protected final String ERROR_DETAILS = "These are the error details!";
    protected final long LOCK_DURATION = 300000L;

    @Before
    public void setUp() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.testRule.deployForTenant("tenant1", ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        this.testRule.deployForTenant("tenant2", ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        this.startProcessInstanceAndFailExternalTask("tenant1");
        this.startProcessInstanceFailAndCompleteExternalTask("tenant2");
    }

    @Test
    public void testQueryWithoutTenantId() {
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)5L));
    }

    @Test
    public void testQueryByTenantId() {
        HistoricExternalTaskLogQuery queryTenant1 = this.historyService.createHistoricExternalTaskLogQuery().tenantIdIn(new String[]{"tenant1"});
        HistoricExternalTaskLogQuery queryTenant2 = this.historyService.createHistoricExternalTaskLogQuery().tenantIdIn(new String[]{"tenant2"});
        Assert.assertThat((Object)queryTenant1.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)queryTenant2.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testQueryByTenantIds() {
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery().tenantIdIn(new String[]{"tenant1", "tenant2"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)5L));
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricExternalTaskLogQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List HistoricExternalTaskLogs = ((HistoricExternalTaskLogQuery)this.historyService.createHistoricExternalTaskLogQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)HistoricExternalTaskLogs.size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant1"));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant1"));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant2"));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(3)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant2"));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(4)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant2"));
    }

    @Test
    public void testQuerySortingDesc() {
        List HistoricExternalTaskLogs = ((HistoricExternalTaskLogQuery)this.historyService.createHistoricExternalTaskLogQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)HistoricExternalTaskLogs.size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant2"));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant2"));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant2"));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(3)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant1"));
        Assert.assertThat((Object)((HistoricExternalTaskLog)HistoricExternalTaskLogs.get(4)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant1"));
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Collections.singletonList("tenant1"));
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{"tenant1"}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{"tenant2"}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{"tenant1", "tenant2"}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList("tenant1", "tenant2"));
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)5L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{"tenant1"}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{"tenant2"}).count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)5L));
    }

    @Test
    public void testGetErrorDetailsNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Collections.singletonList("tenant1"));
        String failedHistoricExternalTaskLogId = ((HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().tenantIdIn(new String[]{"tenant1"}).singleResult()).getId();
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("user", null, null);
        try {
            this.historyService.getHistoricExternalTaskLogErrorDetails(failedHistoricExternalTaskLogId);
            Assert.fail((String)"Exception expected: It should not be possible to retrieve the error details");
        }
        catch (ProcessEngineException e) {
            String errorMessage = e.getMessage();
            Assert.assertThat((Object)errorMessage.contains("Cannot get the historic external task log "), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)errorMessage.contains(failedHistoricExternalTaskLogId), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)errorMessage.contains("because it belongs to no authenticated tenant."), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testGetErrorDetailsAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Collections.singletonList("tenant1"));
        String failedHistoricExternalTaskLogId = ((HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().tenantIdIn(new String[]{"tenant1"}).singleResult()).getId();
        String stacktrace = this.historyService.getHistoricExternalTaskLogErrorDetails(failedHistoricExternalTaskLogId);
        Assert.assertThat((Object)stacktrace, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)stacktrace, (Matcher)CoreMatchers.is((Object)"These are the error details!"));
    }

    @Test
    public void testGetErrorDetailsAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList("tenant1", "tenant2"));
        String logIdTenant1 = ((HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().tenantIdIn(new String[]{"tenant1"}).singleResult()).getId();
        String logIdTenant2 = ((HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().tenantIdIn(new String[]{"tenant1"}).singleResult()).getId();
        String stacktrace1 = this.historyService.getHistoricExternalTaskLogErrorDetails(logIdTenant1);
        String stacktrace2 = this.historyService.getHistoricExternalTaskLogErrorDetails(logIdTenant2);
        Assert.assertThat((Object)stacktrace1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)stacktrace1, (Matcher)CoreMatchers.is((Object)"These are the error details!"));
        Assert.assertThat((Object)stacktrace2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)stacktrace2, (Matcher)CoreMatchers.is((Object)"These are the error details!"));
    }

    protected void completeExternalTask(String externalTaskId) {
        List list = this.externalTaskService.fetchAndLock(100, "aWorkerId", true).topic("foo", 300000L).execute();
        this.externalTaskService.complete(externalTaskId, "aWorkerId");
        for (LockedExternalTask lockedExternalTask : list) {
            if (lockedExternalTask.getId().equals(externalTaskId)) continue;
            this.externalTaskService.unlock(lockedExternalTask.getId());
        }
    }

    protected ExternalTask startProcessInstanceAndFailExternalTask(String tenant) {
        ProcessInstance pi = this.runtimeService.createProcessInstanceByKey("Process").processDefinitionTenantId(tenant).execute();
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
        this.reportExternalTaskFailure(externalTask.getId());
        return externalTask;
    }

    protected void startProcessInstanceFailAndCompleteExternalTask(String tenant) {
        ExternalTask task = this.startProcessInstanceAndFailExternalTask(tenant);
        this.completeExternalTask(task.getId());
    }

    protected void reportExternalTaskFailure(String externalTaskId) {
        this.reportExternalTaskFailure(externalTaskId, "foo", "aWorkerId", 1, false, "This is an error!");
    }

    protected void reportExternalTaskFailure(String externalTaskId, String topic, String workerId, Integer retries, boolean usePriority, String errorMessage) {
        List list = this.externalTaskService.fetchAndLock(100, workerId, usePriority).topic(topic, 300000L).execute();
        this.externalTaskService.handleFailure(externalTaskId, workerId, errorMessage, "These are the error details!", retries.intValue(), 0L);
        for (LockedExternalTask lockedExternalTask : list) {
            this.externalTaskService.unlock(lockedExternalTask.getId());
        }
    }
}

