/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.MessageCorrelationResultType;
import org.camunda.bpm.engine.runtime.MessageCorrelationResultWithVariables;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.variables.FailingJavaSerializable;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MessageCorrelationTest {
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJavaSerializationFormatEnabled(true);
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private RuntimeService runtimeService;
    private TaskService taskService;
    private RepositoryService repositoryService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Deployment
    @Test
    public void testCatchingMessageEventCorrelation() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "anotherValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        HashMap<String, String> messagePayload = new HashMap<String, String>();
        messagePayload.put("aNewKey", "aNewVariable");
        this.runtimeService.correlateMessage(messageName, correlationKeys, messagePayload);
        long uncorrelatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"anotherValue").messageEventSubscriptionName("newInvoiceMessage").count();
        Assert.assertEquals((long)1L, (long)uncorrelatedExecutions);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        Assert.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.createMessageCorrelation(messageName).processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aNewKey", (Object)"aNewVariable").correlate();
        uncorrelatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"anotherValue").messageEventSubscriptionName("newInvoiceMessage").count();
        Assert.assertEquals((long)1L, (long)uncorrelatedExecutions);
        correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        Assert.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testOneMatchinProcessInstanceUsingFluentCorrelateAll() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "anotherValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        this.runtimeService.createMessageCorrelation(messageName).processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aNewKey", (Object)"aNewVariable").correlateAll();
        long uncorrelatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"anotherValue").messageEventSubscriptionName("newInvoiceMessage").count();
        Assert.assertEquals((long)1L, (long)uncorrelatedExecutions);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        Assert.assertEquals((long)1L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testTwoMatchingProcessInstancesCorrelation() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        try {
            this.runtimeService.correlateMessage(messageName, correlationKeys);
            Assert.fail((String)"Expected an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.testRule.assertTextPresent("2 executions match the correlation keys", e.getMessage());
        }
        try {
            this.runtimeService.createMessageCorrelation(messageName).processInstanceVariableEquals("aKey", (Object)"aValue").correlate();
            Assert.fail((String)"Expected an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.testRule.assertTextPresent("2 executions match the correlation keys", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testTwoMatchingProcessInstancesUsingFluentCorrelateAll() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        this.runtimeService.createMessageCorrelation(messageName).processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aNewKey", (Object)"aNewVariable").correlateAll();
        long uncorrelatedExecutions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").count();
        Assert.assertEquals((long)0L, (long)uncorrelatedExecutions);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        Assert.assertEquals((long)2L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testExecutionCorrelationByBusinessKey() {
        String businessKey = "aBusinessKey";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.correlateMessage("newInvoiceMessage", businessKey);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").count();
        Assert.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        processInstance = this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey(businessKey).correlate();
        correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").count();
        Assert.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testExecutionCorrelationByBusinessKeyUsingFluentCorrelateAll() {
        String businessKey = "aBusinessKey";
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey(businessKey).correlateAll();
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").count();
        Assert.assertEquals((long)2L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageCorrelateAllResultListWithResultTypeExecution() {
        ProcessInstance procInstance1 = this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance procInstance2 = this.runtimeService.startProcessInstanceByKey("process");
        List resultList = this.runtimeService.createMessageCorrelation("newInvoiceMessage").correlateAllWithResult();
        Assert.assertEquals((long)2L, (long)resultList.size());
        for (MessageCorrelationResult result : resultList) {
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)MessageCorrelationResultType.Execution, (Object)result.getResultType());
            Assert.assertTrue((procInstance1.getId().equalsIgnoreCase(result.getExecution().getProcessInstanceId()) || procInstance2.getId().equalsIgnoreCase(result.getExecution().getProcessInstanceId()) ? 1 : 0) != 0);
            ExecutionEntity entity = (ExecutionEntity)result.getExecution();
            Assert.assertEquals((Object)"messageCatch", (Object)entity.getActivityId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageCorrelateAllResultListWithResultTypeProcessDefinition() {
        List resultList = this.runtimeService.createMessageCorrelation("newInvoiceMessage").correlateAllWithResult();
        Assert.assertEquals((long)1L, (long)resultList.size());
        for (MessageCorrelationResult result : resultList) {
            this.checkProcessDefinitionMessageCorrelationResult(result, "theStart", "messageStartEvent");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testExecutionCorrelationByBusinessKeyWithVariables() {
        String businessKey = "aBusinessKey";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", businessKey);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.correlateMessage("newInvoiceMessage", businessKey, variables);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"aValue").count();
        Assert.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        processInstance = this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey(businessKey).setVariable("aKey", (Object)"aValue").correlate();
        correlatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"aValue").count();
        Assert.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testExecutionCorrelationByBusinessKeyWithVariablesUsingFluentCorrelateAll() {
        String businessKey = "aBusinessKey";
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey(businessKey).setVariable("aKey", (Object)"aValue").correlateAll();
        long correlatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"aValue").count();
        Assert.assertEquals((long)2L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testExecutionCorrelationSetSerializedVariableValue() throws IOException, ClassNotFoundException {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        FailingJavaSerializable javaSerializable = new FailingJavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        try {
            new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        }
        catch (RuntimeException e) {
            this.testRule.assertTextPresent("Exception while deserializing object.", e.getMessage());
        }
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("var", (Object)Variables.serializedObjectValue((String)serializedObject).objectTypeName(FailingJavaSerializable.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()).correlate();
        ObjectValue variableTyped = (ObjectValue)this.runtimeService.getVariableTyped(processInstance.getId(), "var", false);
        Assert.assertNotNull((Object)variableTyped);
        Assert.assertFalse((boolean)variableTyped.isDeserialized());
        Assert.assertEquals((Object)serializedObject, (Object)variableTyped.getValueSerialized());
        Assert.assertEquals((Object)FailingJavaSerializable.class.getName(), (Object)variableTyped.getObjectTypeName());
        Assert.assertEquals((Object)Variables.SerializationDataFormats.JAVA.getName(), (Object)variableTyped.getSerializationDataFormat());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testExecutionCorrelationSetSerializedVariableValues() throws IOException, ClassNotFoundException {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        FailingJavaSerializable javaSerializable = new FailingJavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        try {
            new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        }
        catch (RuntimeException e) {
            this.testRule.assertTextPresent("Exception while deserializing object.", e.getMessage());
        }
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariables((Map)Variables.createVariables().putValueTyped("var", Variables.serializedObjectValue((String)serializedObject).objectTypeName(FailingJavaSerializable.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create())).correlate();
        ObjectValue variableTyped = (ObjectValue)this.runtimeService.getVariableTyped(processInstance.getId(), "var", false);
        Assert.assertNotNull((Object)variableTyped);
        Assert.assertFalse((boolean)variableTyped.isDeserialized());
        Assert.assertEquals((Object)serializedObject, (Object)variableTyped.getValueSerialized());
        Assert.assertEquals((Object)FailingJavaSerializable.class.getName(), (Object)variableTyped.getObjectTypeName());
        Assert.assertEquals((Object)Variables.SerializationDataFormats.JAVA.getName(), (Object)variableTyped.getSerializationDataFormat());
    }

    @Deployment
    @Test
    public void testMessageStartEventCorrelation() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        long instances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue").count();
        Assert.assertEquals((long)1L, (long)instances);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationUsingFluentCorrelateStartMessage() {
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("aKey", (Object)"aValue").correlateStartMessage();
        long instances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue").count();
        Assert.assertEquals((long)1L, (long)instances);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationUsingFluentCorrelateSingle() {
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("aKey", (Object)"aValue").correlate();
        long instances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue").count();
        Assert.assertEquals((long)1L, (long)instances);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationUsingFluentCorrelateAll() {
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("aKey", (Object)"aValue").correlateAll();
        long instances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue").count();
        Assert.assertEquals((long)1L, (long)instances);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationWithBusinessKey() {
        String businessKey = "aBusinessKey";
        this.runtimeService.correlateMessage("newInvoiceMessage", "aBusinessKey");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)processInstance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationWithBusinessKeyUsingFluentCorrelateStartMessage() {
        String businessKey = "aBusinessKey";
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey("aBusinessKey").correlateStartMessage();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)processInstance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationWithBusinessKeyUsingFluentCorrelateSingle() {
        String businessKey = "aBusinessKey";
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey("aBusinessKey").correlate();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)processInstance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationWithBusinessKeyUsingFluentCorrelateAll() {
        String businessKey = "aBusinessKey";
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey("aBusinessKey").correlateAll();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)processInstance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationSetSerializedVariableValue() throws IOException, ClassNotFoundException {
        FailingJavaSerializable javaSerializable = new FailingJavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        try {
            new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        }
        catch (RuntimeException e) {
            this.testRule.assertTextPresent("Exception while deserializing object.", e.getMessage());
        }
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("var", (Object)Variables.serializedObjectValue((String)serializedObject).objectTypeName(FailingJavaSerializable.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()).correlate();
        ProcessInstance startedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)startedInstance);
        ObjectValue variableTyped = (ObjectValue)this.runtimeService.getVariableTyped(startedInstance.getId(), "var", false);
        Assert.assertNotNull((Object)variableTyped);
        Assert.assertFalse((boolean)variableTyped.isDeserialized());
        Assert.assertEquals((Object)serializedObject, (Object)variableTyped.getValueSerialized());
        Assert.assertEquals((Object)FailingJavaSerializable.class.getName(), (Object)variableTyped.getObjectTypeName());
        Assert.assertEquals((Object)Variables.SerializationDataFormats.JAVA.getName(), (Object)variableTyped.getSerializationDataFormat());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationSetSerializedVariableValues() throws IOException, ClassNotFoundException {
        FailingJavaSerializable javaSerializable = new FailingJavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        try {
            new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        }
        catch (RuntimeException e) {
            this.testRule.assertTextPresent("Exception while deserializing object.", e.getMessage());
        }
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariables((Map)Variables.createVariables().putValueTyped("var", Variables.serializedObjectValue((String)serializedObject).objectTypeName(FailingJavaSerializable.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create())).correlate();
        ProcessInstance startedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)startedInstance);
        ObjectValue variableTyped = (ObjectValue)this.runtimeService.getVariableTyped(startedInstance.getId(), "var", false);
        Assert.assertNotNull((Object)variableTyped);
        Assert.assertFalse((boolean)variableTyped.isDeserialized());
        Assert.assertEquals((Object)serializedObject, (Object)variableTyped.getValueSerialized());
        Assert.assertEquals((Object)FailingJavaSerializable.class.getName(), (Object)variableTyped.getObjectTypeName());
        Assert.assertEquals((Object)Variables.SerializationDataFormats.JAVA.getName(), (Object)variableTyped.getSerializationDataFormat());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationWithVariablesUsingFluentCorrelateStartMessage() {
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariables((Map)Variables.createVariables().putValue("var1", (Object)"a").putValue("var2", (Object)"b")).correlateStartMessage();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("var1", (Object)"a").variableValueEquals("var2", (Object)"b");
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationWithVariablesUsingFluentCorrelateSingleMessage() {
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariables((Map)Variables.createVariables().putValue("var1", (Object)"a").putValue("var2", (Object)"b")).correlate();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("var1", (Object)"a").variableValueEquals("var2", (Object)"b");
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testMessageStartEventCorrelationWithVariablesUsingFluentCorrelateAll() {
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariables((Map)Variables.createVariables().putValue("var1", (Object)"a").putValue("var2", (Object)"b")).correlateAll();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("var1", (Object)"a").variableValueEquals("var2", (Object)"b");
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Deployment
    @Test
    public void testMultipleMessageStartEventsCorrelation() {
        this.runtimeService.correlateMessage("someMessage");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult());
        this.taskService.complete(task.getId());
        this.runtimeService.correlateMessage("someOtherMessage");
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult());
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMultipleMessageStartEventsCorrelation.bpmn20.xml"})
    @Test
    public void testMultipleMessageStartEventsCorrelationUsingFluentCorrelateStartMessage() {
        this.runtimeService.createMessageCorrelation("someMessage").correlateStartMessage();
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult());
        this.taskService.complete(task.getId());
        this.runtimeService.createMessageCorrelation("someOtherMessage").correlateStartMessage();
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult());
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMultipleMessageStartEventsCorrelation.bpmn20.xml"})
    @Test
    public void testMultipleMessageStartEventsCorrelationUsingFluentCorrelateSingle() {
        this.runtimeService.createMessageCorrelation("someMessage").correlate();
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult());
        this.taskService.complete(task.getId());
        this.runtimeService.createMessageCorrelation("someOtherMessage").correlate();
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult());
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMultipleMessageStartEventsCorrelation.bpmn20.xml"})
    @Test
    public void testMultipleMessageStartEventsCorrelationUsingFluentCorrelateAll() {
        this.runtimeService.createMessageCorrelation("someMessage").correlateAll();
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult());
        this.taskService.complete(task.getId());
        this.runtimeService.createMessageCorrelation("someOtherMessage").correlateAll();
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult());
        this.taskService.complete(task.getId());
    }

    @Deployment
    @Test
    public void testMatchingStartEventAndExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertNotNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        this.runtimeService.correlateMessage("newInvoiceMessage");
        Assert.assertNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertNotNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").correlate();
        Assert.assertNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMatchingStartEventAndExecution.bpmn20.xml"})
    @Test
    public void testMessageCorrelationResultWithResultTypeProcessDefinition() {
        String msgName = "newInvoiceMessage";
        MessageCorrelationResult result = this.runtimeService.createMessageCorrelation(msgName).correlateWithResult();
        this.checkProcessDefinitionMessageCorrelationResult(result, "theStart", "process");
    }

    protected void checkProcessDefinitionMessageCorrelationResult(MessageCorrelationResult result, String startActivityId, String processDefinitionId) {
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getProcessInstance().getId());
        Assert.assertEquals((Object)MessageCorrelationResultType.ProcessDefinition, (Object)result.getResultType());
        Assert.assertTrue((boolean)result.getProcessInstance().getProcessDefinitionId().contains(processDefinitionId));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMatchingStartEventAndExecution.bpmn20.xml"})
    @Test
    public void testMessageCorrelationResultWithResultTypeExecution() {
        String msgName = "newInvoiceMessage";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertNotNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName(msgName).singleResult());
        MessageCorrelationResult result = this.runtimeService.createMessageCorrelation(msgName).correlateWithResult();
        this.checkExecutionMessageCorrelationResult(result, processInstance, "messageCatch");
    }

    protected void checkExecutionMessageCorrelationResult(MessageCorrelationResult result, ProcessInstance processInstance, String activityId) {
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)MessageCorrelationResultType.Execution, (Object)result.getResultType());
        Assert.assertEquals((Object)processInstance.getId(), (Object)result.getExecution().getProcessInstanceId());
        ExecutionEntity entity = (ExecutionEntity)result.getExecution();
        Assert.assertEquals((Object)activityId, (Object)entity.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMatchingStartEventAndExecution.bpmn20.xml"})
    @Test
    public void testMatchingStartEventAndExecutionUsingFluentCorrelateAll() {
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").count());
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").correlateAll();
        Assert.assertNotNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMatchingStartEventAndExecution.bpmn20.xml"})
    @Test
    public void testMatchingStartEventAndExecutionCorrelateAllWithResult() {
        ProcessInstance procInstance1 = this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance procInstance2 = this.runtimeService.startProcessInstanceByKey("process");
        List resultList = this.runtimeService.createMessageCorrelation("newInvoiceMessage").correlateAllWithResult();
        Assert.assertEquals((long)3L, (long)resultList.size());
        int executionResultCount = 0;
        int procDefResultCount = 0;
        for (MessageCorrelationResult result : resultList) {
            if (result.getResultType().equals((Object)MessageCorrelationResultType.Execution)) {
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((Object)MessageCorrelationResultType.Execution, (Object)result.getResultType());
                Assert.assertTrue((procInstance1.getId().equalsIgnoreCase(result.getExecution().getProcessInstanceId()) || procInstance2.getId().equalsIgnoreCase(result.getExecution().getProcessInstanceId()) ? 1 : 0) != 0);
                ExecutionEntity entity = (ExecutionEntity)result.getExecution();
                Assert.assertEquals((Object)"messageCatch", (Object)entity.getActivityId());
                ++executionResultCount;
                continue;
            }
            this.checkProcessDefinitionMessageCorrelationResult(result, "theStart", "process");
            ++procDefResultCount;
        }
        Assert.assertEquals((long)2L, (long)executionResultCount);
        Assert.assertEquals((long)1L, (long)procDefResultCount);
    }

    @Test
    public void testMessageStartEventCorrelationWithNonMatchingDefinition() {
        try {
            this.runtimeService.correlateMessage("aMessageName");
            Assert.fail((String)"Expect an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.testRule.assertTextPresent("Cannot correlate message", e.getMessage());
        }
        try {
            this.runtimeService.createMessageCorrelation("aMessageName").correlate();
            Assert.fail((String)"Expect an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.testRule.assertTextPresent("Cannot correlate message", e.getMessage());
        }
        this.runtimeService.createMessageCorrelation("aMessageName").correlateAll();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByBusinessKeyAndVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", "anotherBusinessKey", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("aProcessVariable", "aVariableValue");
        this.runtimeService.correlateMessage(messageName, "aBusinessKey", correlationKeys, processVariables);
        Execution correlatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aProcessVariable", (Object)"aVariableValue").singleResult();
        Assert.assertNotNull((Object)correlatedExecution);
        ProcessInstance correlatedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(correlatedExecution.getProcessInstanceId()).singleResult();
        Assert.assertEquals((Object)"aBusinessKey", (Object)correlatedProcessInstance.getBusinessKey());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        processInstance = this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aProcessVariable", (Object)"aVariableValue").correlate();
        correlatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aProcessVariable", (Object)"aVariableValue").singleResult();
        Assert.assertNotNull((Object)correlatedExecution);
        correlatedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(correlatedExecution.getProcessInstanceId()).singleResult();
        Assert.assertEquals((Object)"aBusinessKey", (Object)correlatedProcessInstance.getBusinessKey());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByBusinessKeyAndVariablesUsingFluentCorrelateAll() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        String messageName = "newInvoiceMessage";
        this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aProcessVariable", (Object)"aVariableValue").correlateAll();
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aProcessVariable", (Object)"aVariableValue").list();
        Assert.assertEquals((long)2L, (long)correlatedExecutions.size());
        Execution correlatedExecution = (Execution)correlatedExecutions.get(0);
        ProcessInstance correlatedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(correlatedExecution.getProcessInstanceId()).singleResult();
        Assert.assertEquals((Object)"aBusinessKey", (Object)correlatedProcessInstance.getBusinessKey());
        correlatedExecution = (Execution)correlatedExecutions.get(1);
        correlatedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(correlatedExecution.getProcessInstanceId()).singleResult();
        Assert.assertEquals((Object)"aBusinessKey", (Object)correlatedProcessInstance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByProcessInstanceId() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.createMessageCorrelation("aMessageName").correlate();
            Assert.fail((String)"Expect an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.testRule.assertTextPresent("Cannot correlate message", e.getMessage());
        }
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceId(processInstance1.getId()).correlate();
        Execution correlatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertNotNull((Object)correlatedExecution);
        Execution uncorrelatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertNull((Object)uncorrelatedExecution);
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByProcessInstanceIdUsingFluentCorrelateAll() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.createMessageCorrelation("aMessageName").correlateAll();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("task").count());
        processInstance1 = this.runtimeService.startProcessInstanceByKey("process");
        processInstance2 = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceId(processInstance1.getId()).correlateAll();
        Execution correlatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertNotNull((Object)correlatedExecution);
        Execution uncorrelatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertNull((Object)uncorrelatedExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByBusinessKeyAndNullVariableUsingFluentCorrelateAll() {
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey");
        String messageName = "newInvoiceMessage";
        try {
            this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").setVariable(null, (Object)"aVariableValue").correlateAll();
            Assert.fail((String)"Variable name is null");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ProcessEngineException));
            this.testRule.assertTextPresent("null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByBusinessKeyAndNullVariableEqualsUsingFluentCorrelateAll() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        String messageName = "newInvoiceMessage";
        try {
            this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").processInstanceVariableEquals(null, (Object)"bar").correlateAll();
            Assert.fail((String)"Variable name is null");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ProcessEngineException));
            this.testRule.assertTextPresent("null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByBusinessKeyAndNullVariablesUsingFluentCorrelateAll() {
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey");
        String messageName = "newInvoiceMessage";
        this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").setVariables(null).setVariable("foo", (Object)"bar").correlateAll();
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("foo", (Object)"bar").list();
        Assert.assertFalse((boolean)correlatedExecutions.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByVariablesOnly() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("variable", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables.put("variable", "value2");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.correlateMessage(null, variables);
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        Assert.assertEquals((long)1L, (long)correlatedExecutions.size());
        Assert.assertEquals((Object)instance.getId(), (Object)((Execution)correlatedExecutions.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByBusinessKey() {
        this.runtimeService.startProcessInstanceByKey("process", "businessKey1");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process", "businessKey2");
        this.runtimeService.correlateMessage(null, "businessKey2");
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        Assert.assertEquals((long)1L, (long)correlatedExecutions.size());
        Assert.assertEquals((Object)instance.getId(), (Object)((Execution)correlatedExecutions.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationByProcessInstanceIdOnly() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.createMessageCorrelation(null).processInstanceId(instance.getId()).correlate();
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        Assert.assertEquals((long)1L, (long)correlatedExecutions.size());
        Assert.assertEquals((Object)instance.getId(), (Object)((Execution)correlatedExecutions.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationWithoutMessageNameFluent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("variable", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables.put("variable", "value2");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.createMessageCorrelation(null).processInstanceVariableEquals("variable", (Object)"value2").correlate();
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        Assert.assertEquals((long)1L, (long)correlatedExecutions.size());
        Assert.assertEquals((Object)instance.getId(), (Object)((Execution)correlatedExecutions.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCorrelateAllWithoutMessage.bpmn20.xml"})
    @Test
    public void testCorrelateAllWithoutMessage() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("variable", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("secondProcess", variables);
        variables.put("variable", "value2");
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("process", variables);
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("secondProcess", variables);
        this.runtimeService.createMessageCorrelation(null).processInstanceVariableEquals("variable", (Object)"value2").correlateAll();
        List correlatedExecutions = ((ExecutionQuery)this.runtimeService.createExecutionQuery().activityId("task").orderByProcessDefinitionKey().asc()).list();
        Assert.assertEquals((long)2L, (long)correlatedExecutions.size());
        Assert.assertEquals((Object)instance1.getId(), (Object)((Execution)correlatedExecutions.get(0)).getId());
        Assert.assertEquals((Object)instance2.getId(), (Object)((Execution)correlatedExecutions.get(1)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationWithoutMessageDoesNotMatchStartEvent() {
        try {
            this.runtimeService.createMessageCorrelation(null).processInstanceVariableEquals("variable", (Object)"value2").correlate();
            Assert.fail((String)"exception expected");
        }
        catch (MismatchingMessageCorrelationException mismatchingMessageCorrelationException) {
            // empty catch block
        }
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        Assert.assertTrue((boolean)correlatedExecutions.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelationWithoutCorrelationPropertiesFails() {
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.createMessageCorrelation(null).correlate();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            this.runtimeService.correlateMessage(null);
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/twoBoundaryEventSubscriptions.bpmn20.xml"})
    @Test
    public void testCorrelationToExecutionWithMultipleSubscriptionsFails() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.createMessageCorrelation(null).processInstanceId(instance.getId()).correlate();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testSuspendedProcessInstance() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        String processInstance = this.runtimeService.startProcessInstanceByKey("process", variables).getId();
        this.runtimeService.suspendProcessInstanceById(processInstance);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        try {
            this.runtimeService.correlateMessage(messageName, correlationKeys);
            Assert.fail((String)"It should not be possible to correlate a message to a suspended process instance.");
        }
        catch (MismatchingMessageCorrelationException mismatchingMessageCorrelationException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testOneMatchingAndOneSuspendedProcessInstance() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        String firstProcessInstance = this.runtimeService.startProcessInstanceByKey("process", variables).getId();
        variables = new HashMap();
        variables.put("aKey", "aValue");
        String secondProcessInstance = this.runtimeService.startProcessInstanceByKey("process", variables).getId();
        this.runtimeService.suspendProcessInstanceById(secondProcessInstance);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        HashMap<String, String> messagePayload = new HashMap<String, String>();
        messagePayload.put("aNewKey", "aNewVariable");
        this.runtimeService.correlateMessage(messageName, correlationKeys, messagePayload);
        long uncorrelatedExecutions = this.runtimeService.createExecutionQuery().processInstanceId(secondProcessInstance).processVariableValueEquals("aKey", (Object)"aValue").messageEventSubscriptionName("newInvoiceMessage").count();
        Assert.assertEquals((long)1L, (long)uncorrelatedExecutions);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().processInstanceId(firstProcessInstance).activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        Assert.assertEquals((long)1L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testSuspendedProcessDefinition() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        try {
            this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
            Assert.fail((String)"It should not be possible to correlate a message to a suspended process definition.");
        }
        catch (MismatchingMessageCorrelationException mismatchingMessageCorrelationException) {
            // empty catch block
        }
    }

    @Test
    public void testCorrelateMessageStartEventWithProcessDefinitionId() {
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message("a")).userTask().endEvent().done());
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message("b")).userTask().endEvent().done());
        ProcessDefinition firstProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).singleResult();
        ProcessDefinition secondProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        this.runtimeService.createMessageCorrelation("a").processDefinitionId(firstProcessDefinition.getId()).processInstanceBusinessKey("first").correlateStartMessage();
        this.runtimeService.createMessageCorrelation("b").processDefinitionId(secondProcessDefinition.getId()).processInstanceBusinessKey("second").correlateStartMessage();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("first").processDefinitionId(firstProcessDefinition.getId()).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("second").processDefinitionId(secondProcessDefinition.getId()).count());
    }

    @Test
    public void testFailCorrelateMessageStartEventWithWrongProcessDefinitionId() {
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message("a")).userTask().endEvent().done());
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message("b")).userTask().endEvent().done());
        ProcessDefinition latestProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().latestVersion().singleResult();
        try {
            this.runtimeService.createMessageCorrelation("a").processDefinitionId(latestProcessDefinition.getId()).correlateStartMessage();
            Assert.fail((String)"expected exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.testRule.assertTextPresent("Cannot correlate message 'a'", e.getMessage());
        }
    }

    @Test
    public void testFailCorrelateMessageStartEventWithNonExistingProcessDefinitionId() {
        try {
            this.runtimeService.createMessageCorrelation("a").processDefinitionId("not existing").correlateStartMessage();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("no deployed process definition found", e.getMessage());
        }
    }

    @Test
    public void testFailCorrelateMessageWithProcessDefinitionId() {
        try {
            this.runtimeService.createMessageCorrelation("a").processDefinitionId("id").correlate();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("Cannot specify a process definition id", e.getMessage());
        }
    }

    @Test
    public void testFailCorrelateMessagesWithProcessDefinitionId() {
        try {
            this.runtimeService.createMessageCorrelation("a").processDefinitionId("id").correlateAll();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("Cannot specify a process definition id", e.getMessage());
        }
    }

    @Test
    public void testFailCorrelateMessageStartEventWithCorrelationVariable() {
        try {
            this.runtimeService.createMessageCorrelation("a").processInstanceVariableEquals("var", (Object)"value").correlateStartMessage();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("Cannot specify correlation variables ", e.getMessage());
        }
    }

    @Test
    public void testFailCorrelateMessageStartEventWithCorrelationVariables() {
        try {
            this.runtimeService.createMessageCorrelation("a").processInstanceVariablesEqual((Map)Variables.createVariables().putValue("var1", (Object)"b").putValue("var2", (Object)"c")).correlateStartMessage();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("Cannot specify correlation variables ", e.getMessage());
        }
    }

    @Test
    public void testCorrelationWithResultBySettingLocalVariables() {
        String outputVarName = "localVar";
        BpmnModelInstance model = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().intermediateCatchEvent("message_1").message("1")).camundaOutputParameter(outputVarName, "${testLocalVar}")).userTask("UserTask_1").endEvent().done();
        this.testRule.deploy(model);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("processInstanceVar", "processInstanceVarValue");
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", variables);
        HashMap<String, String> messageLocalPayload = new HashMap<String, String>();
        String outpuValue = "outputValue";
        String localVarName = "testLocalVar";
        messageLocalPayload.put(localVarName, outpuValue);
        MessageCorrelationResultWithVariables messageCorrelationResult = this.runtimeService.createMessageCorrelation("1").setVariablesLocal(messageLocalPayload).correlateWithResultAndVariables(true);
        this.checkExecutionMessageCorrelationResult((MessageCorrelationResult)messageCorrelationResult, processInstance, "message_1");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName(outputVarName).singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)outpuValue, (Object)variable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)variable.getExecutionId());
        VariableInstance variableNonExisting = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName(localVarName).singleResult();
        Assert.assertNull((Object)variableNonExisting);
        VariableMap variablesInReturn = messageCorrelationResult.getVariables();
        Assert.assertEquals((Object)variable.getTypedValue(), (Object)variablesInReturn.getValueTyped(outputVarName));
        Assert.assertEquals((Object)"processInstanceVarValue", (Object)variablesInReturn.getValue("processInstanceVar", String.class));
    }

    @Test
    public void testCorrelationBySettingLocalVariables() {
        String outputVarName = "localVar";
        BpmnModelInstance model = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().intermediateCatchEvent("message_1").message("1")).camundaOutputParameter(outputVarName, "${testLocalVar}")).userTask("UserTask_1").endEvent().done();
        this.testRule.deploy(model);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("processInstanceVar", "processInstanceVarValue");
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", variables);
        HashMap<String, String> messageLocalPayload = new HashMap<String, String>();
        String outpuValue = "outputValue";
        String localVarName = "testLocalVar";
        messageLocalPayload.put(localVarName, outpuValue);
        this.runtimeService.createMessageCorrelation("1").setVariablesLocal(messageLocalPayload).correlate();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName(outputVarName).singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)outpuValue, (Object)variable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)variable.getExecutionId());
        VariableInstance variableNonExisting = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName(localVarName).singleResult();
        Assert.assertNull((Object)variableNonExisting);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.waitForMessageProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.sendMessageProcess.bpmn20.xml"})
    @Test
    public void testCorrelateWithResultTwoTimesInSameTransaction() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("correlationKey", "someCorrelationKey");
        ProcessInstance messageWaitProcess = this.runtimeService.startProcessInstanceByKey("waitForMessageProcess", variables);
        Execution waitingProcess = (Execution)this.runtimeService.createExecutionQuery().executionId(messageWaitProcess.getProcessInstanceId()).singleResult();
        Assert.assertNotNull((Object)waitingProcess);
        this.thrown.expect(MismatchingMessageCorrelationException.class);
        this.thrown.expectMessage("Cannot correlate message 'waitForCorrelationKeyMessage'");
        VariableMap switchScenarioFlag = Variables.createVariables().putValue("allFlag", (Object)false);
        this.runtimeService.startProcessInstanceByKey("sendMessageProcess", (Map)switchScenarioFlag);
        waitingProcess = (Execution)this.runtimeService.createExecutionQuery().executionId(messageWaitProcess.getProcessInstanceId()).singleResult();
        Assert.assertNull((Object)waitingProcess);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.waitForMessageProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.sendMessageProcess.bpmn20.xml"})
    @Test
    public void testCorrelateAllWithResultTwoTimesInSameTransaction() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("correlationKey", "someCorrelationKey");
        ProcessInstance messageWaitProcess = this.runtimeService.startProcessInstanceByKey("waitForMessageProcess", variables);
        Execution waitingProcess = (Execution)this.runtimeService.createExecutionQuery().executionId(messageWaitProcess.getProcessInstanceId()).singleResult();
        Assert.assertNotNull((Object)waitingProcess);
        VariableMap switchScenarioFlag = Variables.createVariables().putValue("allFlag", (Object)true);
        this.runtimeService.startProcessInstanceByKey("sendMessageProcess", (Map)switchScenarioFlag);
        waitingProcess = (Execution)this.runtimeService.createExecutionQuery().executionId(messageWaitProcess.getProcessInstanceId()).singleResult();
        Assert.assertNull((Object)waitingProcess);
    }

    @Test
    @Ignore(value="CAM-10198")
    public void testMessageStartEventCorrelationWithLocalVariables() {
        BpmnModelInstance model = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().message("1")).userTask("userTask1").endEvent().done();
        this.testRule.deploy(model);
        HashMap<String, String> messagePayload = new HashMap<String, String>();
        String outpuValue = "outputValue";
        String localVarName = "testLocalVar";
        messagePayload.put(localVarName, outpuValue);
        MessageCorrelationResult result = this.runtimeService.createMessageCorrelation("1").setVariablesLocal(messagePayload).correlateWithResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)MessageCorrelationResultType.ProcessDefinition, (Object)result.getResultType());
    }

    @Test
    public void testMessageStartEventCorrelationWithVariablesInResult() {
        BpmnModelInstance model = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().message("1")).userTask("UserTask_1").endEvent().done();
        this.testRule.deploy(model);
        MessageCorrelationResultWithVariables result = this.runtimeService.createMessageCorrelation("1").setVariable("foo", (Object)"bar").correlateWithResultAndVariables(true);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)MessageCorrelationResultType.ProcessDefinition, (Object)result.getResultType());
        Assert.assertEquals((Object)"bar", (Object)result.getVariables().getValue("foo", String.class));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    @Test
    public void testCorrelateAllWithResultVariables() {
        ProcessInstance procInstance1 = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("var1", (Object)"foo"));
        ProcessInstance procInstance2 = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("var2", (Object)"bar"));
        List resultList = this.runtimeService.createMessageCorrelation("newInvoiceMessage").correlateAllWithResultAndVariables(true);
        Assert.assertEquals((long)2L, (long)resultList.size());
        for (MessageCorrelationResultWithVariables result : resultList) {
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)MessageCorrelationResultType.Execution, (Object)result.getResultType());
            ExecutionEntity execution = (ExecutionEntity)result.getExecution();
            VariableMap variables = result.getVariables();
            Assert.assertEquals((long)1L, (long)variables.size());
            if (procInstance1.getId().equalsIgnoreCase(execution.getProcessInstanceId())) {
                Assert.assertEquals((Object)"foo", (Object)variables.getValue("var1", String.class));
                continue;
            }
            if (procInstance2.getId().equalsIgnoreCase(execution.getProcessInstanceId())) {
                Assert.assertEquals((Object)"bar", (Object)variables.getValue("var2", String.class));
                continue;
            }
            Assert.fail((String)"Only those process instances should exist");
        }
    }

    @Test
    public void testCorrelationWithModifiedVariablesInResult() {
        BpmnModelInstance model = ((ServiceTaskBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().intermediateCatchEvent("Message_1").message("1")).serviceTask().camundaClass(ChangeVariableDelegate.class.getName())).userTask("UserTask_1").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("Process_1", (Map)Variables.createVariables().putValue("a", (Object)40).putValue("b", (Object)2));
        MessageCorrelationResultWithVariables result = this.runtimeService.createMessageCorrelation("1").correlateWithResultAndVariables(true);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)MessageCorrelationResultType.Execution, (Object)result.getResultType());
        Assert.assertEquals((long)3L, (long)result.getVariables().size());
        Assert.assertEquals((Object)"foo", (Object)result.getVariables().get((Object)"a"));
        Assert.assertEquals((Object)2, (Object)result.getVariables().get((Object)"b"));
        Assert.assertEquals((Object)42, (Object)result.getVariables().get((Object)"sum"));
    }

    @Test
    public void testCorrelateWithVariablesInReturnShouldDeserializeObjectValue() {
        BpmnModelInstance model = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("Message_1").message("1")).userTask("UserTask_1").endEvent().done();
        this.testRule.deploy(model);
        ObjectValue value = (ObjectValue)Variables.objectValue((Object)"value").create();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)value);
        this.runtimeService.startProcessInstanceByKey("process", (Map)variables);
        MessageCorrelationResultWithVariables result = this.runtimeService.createMessageCorrelation("1").correlateWithResultAndVariables(true);
        VariableMap resultVariables = result.getVariables();
        ObjectValue returnedValue = (ObjectValue)resultVariables.getValueTyped("var");
        Assertions.assertThat((boolean)returnedValue.isDeserialized()).isTrue();
        Assertions.assertThat((Object)returnedValue.getValue()).isEqualTo((Object)"value");
    }

    @Test
    public void testCorrelateWithVariablesInReturnShouldNotDeserializeObjectValue() {
        BpmnModelInstance model = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("Message_1").message("1")).userTask("UserTask_1").endEvent().done();
        this.testRule.deploy(model);
        ObjectValue value = (ObjectValue)Variables.objectValue((Object)"value").create();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)value);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process", (Map)variables);
        String serializedValue = ((ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "var")).getValueSerialized();
        MessageCorrelationResultWithVariables result = this.runtimeService.createMessageCorrelation("1").correlateWithResultAndVariables(false);
        VariableMap resultVariables = result.getVariables();
        ObjectValue returnedValue = (ObjectValue)resultVariables.getValueTyped("var");
        Assertions.assertThat((boolean)returnedValue.isDeserialized()).isFalse();
        Assertions.assertThat((String)returnedValue.getValueSerialized()).isEqualTo((Object)serializedValue);
    }

    @Test
    public void testCorrelateAllWithVariablesInReturnShouldDeserializeObjectValue() {
        BpmnModelInstance model = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("Message_1").message("1")).userTask("UserTask_1").endEvent().done();
        this.testRule.deploy(model);
        ObjectValue value = (ObjectValue)Variables.objectValue((Object)"value").create();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)value);
        this.runtimeService.startProcessInstanceByKey("process", (Map)variables);
        List result = this.runtimeService.createMessageCorrelation("1").correlateAllWithResultAndVariables(true);
        Assertions.assertThat((List)result).hasSize(1);
        VariableMap resultVariables = ((MessageCorrelationResultWithVariables)result.get(0)).getVariables();
        ObjectValue returnedValue = (ObjectValue)resultVariables.getValueTyped("var");
        Assertions.assertThat((boolean)returnedValue.isDeserialized()).isTrue();
        Assertions.assertThat((Object)returnedValue.getValue()).isEqualTo((Object)"value");
    }

    @Test
    public void testCorrelateAllWithVariablesInReturnShouldNotDeserializeObjectValue() {
        BpmnModelInstance model = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("Message_1").message("1")).userTask("UserTask_1").endEvent().done();
        this.testRule.deploy(model);
        ObjectValue value = (ObjectValue)Variables.objectValue((Object)"value").create();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)value);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process", (Map)variables);
        String serializedValue = ((ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "var")).getValueSerialized();
        List result = this.runtimeService.createMessageCorrelation("1").correlateAllWithResultAndVariables(false);
        Assertions.assertThat((List)result).hasSize(1);
        VariableMap resultVariables = ((MessageCorrelationResultWithVariables)result.get(0)).getVariables();
        ObjectValue returnedValue = (ObjectValue)resultVariables.getValueTyped("var");
        Assertions.assertThat((boolean)returnedValue.isDeserialized()).isFalse();
        Assertions.assertThat((String)returnedValue.getValueSerialized()).isEqualTo((Object)serializedValue);
    }

    @Test
    public void testStartMessageOnlyFlag() {
        this.deployTwoVersionsWithStartMessageEvent();
        ProcessDefinition firstProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).singleResult();
        ProcessDefinition secondProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        this.runtimeService.createMessageCorrelation("a").startMessageOnly().processDefinitionId(firstProcessDefinition.getId()).processInstanceBusinessKey("first").correlate();
        this.runtimeService.createMessageCorrelation("a").startMessageOnly().processDefinitionId(secondProcessDefinition.getId()).processInstanceBusinessKey("second").correlate();
        this.assertTwoInstancesAreStarted(firstProcessDefinition, secondProcessDefinition);
    }

    @Test
    public void testStartMessageOnlyFlagAll() {
        this.deployTwoVersionsWithStartMessageEvent();
        ProcessDefinition firstProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).singleResult();
        ProcessDefinition secondProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        this.runtimeService.createMessageCorrelation("a").startMessageOnly().processDefinitionId(firstProcessDefinition.getId()).processInstanceBusinessKey("first").correlateAll();
        this.runtimeService.createMessageCorrelation("a").startMessageOnly().processDefinitionId(secondProcessDefinition.getId()).processInstanceBusinessKey("second").correlateAll();
        this.assertTwoInstancesAreStarted(firstProcessDefinition, secondProcessDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testStartMessageOnlyFlagWithResult() {
        MessageCorrelationResult result = this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("aKey", (Object)"aValue").startMessageOnly().correlateWithResult();
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue");
        Assertions.assertThat((long)processInstanceQuery.count()).isEqualTo(1L);
        Assertions.assertThat((String)result.getProcessInstance().getId()).isEqualTo((Object)((ProcessInstance)processInstanceQuery.singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testStartMessageOnlyFlagWithVariablesInResult() {
        MessageCorrelationResultWithVariables result = this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("aKey", (Object)"aValue").startMessageOnly().correlateWithResultAndVariables(false);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue");
        Assertions.assertThat((long)processInstanceQuery.count()).isEqualTo(1L);
        Assertions.assertThat((int)result.getVariables().size()).isEqualTo(1);
        Assertions.assertThat((Object)result.getVariables().getValueTyped("aKey").getValue()).isEqualTo((Object)"aValue");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testStartMessageOnlyFlagAllWithResult() {
        List result = this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("aKey", (Object)"aValue").startMessageOnly().correlateAllWithResult();
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue");
        Assertions.assertThat((long)processInstanceQuery.count()).isEqualTo(1L);
        Assertions.assertThat((String)((MessageCorrelationResult)result.get(0)).getProcessInstance().getId()).isEqualTo((Object)((ProcessInstance)processInstanceQuery.singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    @Test
    public void testStartMessageOnlyFlagAllWithVariablesInResult() {
        List results = this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("aKey", (Object)"aValue").startMessageOnly().correlateAllWithResultAndVariables(false);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue");
        Assertions.assertThat((long)processInstanceQuery.count()).isEqualTo(1L);
        MessageCorrelationResultWithVariables result = (MessageCorrelationResultWithVariables)results.get(0);
        Assertions.assertThat((int)result.getVariables().size()).isEqualTo(1);
        Assertions.assertThat((Object)result.getVariables().getValueTyped("aKey").getValue()).isEqualTo((Object)"aValue");
    }

    @Test
    public void testFailStartMessageOnlyFlagWithCorrelationVariable() {
        try {
            this.runtimeService.createMessageCorrelation("a").startMessageOnly().processInstanceVariableEquals("var", (Object)"value").correlate();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("Cannot specify correlation variables ", e.getMessage());
        }
    }

    @Test
    public void testFailStartMessageOnlyFlagWithCorrelationVariables() {
        try {
            this.runtimeService.createMessageCorrelation("a").startMessageOnly().processInstanceVariablesEqual((Map)Variables.createVariables().putValue("var1", (Object)"b").putValue("var2", (Object)"c")).correlateAll();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("Cannot specify correlation variables ", e.getMessage());
        }
    }

    protected void deployTwoVersionsWithStartMessageEvent() {
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message("a")).userTask("ut1").endEvent().done());
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message("a")).userTask("ut2").endEvent().done());
    }

    protected void assertTwoInstancesAreStarted(ProcessDefinition firstProcessDefinition, ProcessDefinition secondProcessDefinition) {
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("first").processDefinitionId(firstProcessDefinition.getId()).count()).isEqualTo(1L);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("second").processDefinitionId(secondProcessDefinition.getId()).count()).isEqualTo(1L);
    }

    public static class ChangeVariableDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            Integer a = (Integer)execution.getVariable("a");
            Integer b = (Integer)execution.getVariable("b");
            execution.setVariable("sum", (Object)(a + b));
            execution.setVariable("a", (Object)"foo");
        }
    }
}

