/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TaskQueryOrTest {
    @Rule
    public ProcessEngineRule processEngineRule = new ProcessEngineRule(true);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected CaseService caseService;
    protected RepositoryService repositoryService;
    protected FilterService filterService;

    @Before
    public void init() {
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.taskService = this.processEngineRule.getTaskService();
        this.caseService = this.processEngineRule.getCaseService();
        this.repositoryService = this.processEngineRule.getRepositoryService();
        this.filterService = this.processEngineRule.getFilterService();
    }

    @After
    public void tearDown() {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Test
    public void shouldThrowExceptionByMissingStartOr() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set endOr() before or()");
        this.taskService.createTaskQuery().or().endOr().endOr();
    }

    @Test
    public void shouldThrowExceptionByNesting() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set or() within 'or' query");
        this.taskService.createTaskQuery().or().or().endOr().endOr().or().endOr();
    }

    @Test
    public void shouldThrowExceptionByWithCandidateGroupsApplied() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set withCandidateGroups() within 'or' query");
        this.taskService.createTaskQuery().or().withCandidateGroups().endOr();
    }

    @Test
    public void shouldThrowExceptionByWithoutCandidateGroupsApplied() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set withoutCandidateGroups() within 'or' query");
        this.taskService.createTaskQuery().or().withoutCandidateGroups().endOr();
    }

    @Test
    public void shouldThrowExceptionByWithCandidateUsersApplied() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set withCandidateUsers() within 'or' query");
        this.taskService.createTaskQuery().or().withCandidateUsers().endOr();
    }

    @Test
    public void shouldThrowExceptionByWithoutCandidateUsersApplied() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set withoutCandidateUsers() within 'or' query");
        this.taskService.createTaskQuery().or().withoutCandidateUsers().endOr();
    }

    @Test
    public void shouldThrowExceptionByOrderingApplied() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByCaseExecutionId() within 'or' query");
        this.taskService.createTaskQuery().or().orderByCaseExecutionId().endOr();
    }

    @Test
    public void shouldThrowExceptionByInitializeFormKeysInOrQuery() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set initializeFormKeys() within 'or' query");
        this.taskService.createTaskQuery().or().initializeFormKeys().endOr();
    }

    @Test
    public void shouldReturnNoTasksWithTaskCandidateUserAndOrTaskCandidateGroup() {
        Task task1 = this.taskService.newTask();
        this.taskService.saveTask(task1);
        this.taskService.addCandidateUser(task1.getId(), "aCandidateUser");
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        this.taskService.addCandidateGroup(task2.getId(), "aCandidateGroup");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("aCandidateUser").or().taskCandidateGroup("aCandidateGroup").endOr().list();
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWithEmptyOrQuery() {
        this.taskService.saveTask(this.taskService.newTask());
        this.taskService.saveTask(this.taskService.newTask());
        List tasks = this.taskService.createTaskQuery().or().endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWithTaskCandidateUserOrTaskCandidateGroup() {
        Task task1 = this.taskService.newTask();
        this.taskService.saveTask(task1);
        this.taskService.addCandidateUser(task1.getId(), "John Doe");
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        this.taskService.addCandidateGroup(task2.getId(), "Controlling");
        List tasks = this.taskService.createTaskQuery().or().taskCandidateUser("John Doe").taskCandidateGroup("Controlling").endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWithTaskCandidateUserOrTaskCandidateGroupWithIncludeAssignedTasks() {
        Task task1 = this.taskService.newTask();
        this.taskService.saveTask(task1);
        this.taskService.addCandidateUser(task1.getId(), "John Doe");
        this.taskService.setAssignee(task1.getId(), "John Doe");
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        this.taskService.addCandidateGroup(task2.getId(), "Controlling");
        List tasks = this.taskService.createTaskQuery().or().taskCandidateUser("John Doe").taskCandidateGroup("Controlling").includeAssignedTasks().endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWithTaskCandidateUserOrTaskCandidateGroupIn() {
        Task task1 = this.taskService.newTask();
        this.taskService.saveTask(task1);
        this.taskService.addCandidateUser(task1.getId(), "John Doe");
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        this.taskService.addCandidateGroup(task2.getId(), "Controlling");
        Task task3 = this.taskService.newTask();
        this.taskService.saveTask(task3);
        this.taskService.addCandidateGroup(task3.getId(), "Sales");
        List tasks = this.taskService.createTaskQuery().or().taskCandidateUser("John Doe").taskCandidateGroupIn(Arrays.asList("Controlling", "Sales")).endOr().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWithTaskCandidateGroupOrTaskCandidateGroupIn() {
        Task task1 = this.taskService.newTask();
        this.taskService.saveTask(task1);
        this.taskService.addCandidateGroup(task1.getId(), "Accounting");
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        this.taskService.addCandidateGroup(task2.getId(), "Controlling");
        Task task3 = this.taskService.newTask();
        this.taskService.saveTask(task3);
        this.taskService.addCandidateGroup(task3.getId(), "Sales");
        List tasks = this.taskService.createTaskQuery().or().taskCandidateGroup("Accounting").taskCandidateGroupIn(Arrays.asList("Controlling", "Sales")).endOr().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWithTaskNameOrTaskDescription() {
        Task task1 = this.taskService.newTask();
        task1.setName("aTaskName");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setDescription("aTaskDescription");
        this.taskService.saveTask(task2);
        List tasks = this.taskService.createTaskQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWithMultipleOrCriteria() {
        Task task1 = this.taskService.newTask();
        task1.setName("aTaskName");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setDescription("aTaskDescription");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setPriority(5);
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setOwner("aTaskOwner");
        this.taskService.saveTask(task5);
        List tasks = this.taskService.createTaskQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").taskId(task3.getId()).taskPriority(Integer.valueOf(5)).taskOwner("aTaskOwner").endOr().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksFilteredByMultipleOrAndCriteria() {
        Task task1 = this.taskService.newTask();
        task1.setPriority(4);
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("aTaskName");
        task2.setOwner("aTaskOwner");
        task2.setAssignee("aTaskAssignee");
        task2.setPriority(4);
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("aTaskName");
        task3.setOwner("aTaskOwner");
        task3.setAssignee("aTaskAssignee");
        task3.setPriority(4);
        task3.setDescription("aTaskDescription");
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setOwner("aTaskOwner");
        task4.setAssignee("aTaskAssignee");
        task4.setPriority(4);
        task4.setDescription("aTaskDescription");
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setDescription("aTaskDescription");
        task5.setOwner("aTaskOwner");
        this.taskService.saveTask(task5);
        List tasks = this.taskService.createTaskQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").taskId(task3.getId()).endOr().taskOwner("aTaskOwner").taskPriority(Integer.valueOf(4)).taskAssignee("aTaskAssignee").list();
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksFilteredByMultipleOrQueries() {
        Task task1 = this.taskService.newTask();
        task1.setName("aTaskName");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("aTaskName");
        task2.setDescription("aTaskDescription");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("aTaskName");
        task3.setDescription("aTaskDescription");
        task3.setOwner("aTaskOwner");
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setName("aTaskName");
        task4.setDescription("aTaskDescription");
        task4.setOwner("aTaskOwner");
        task4.setAssignee("aTaskAssignee");
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setName("aTaskName");
        task5.setDescription("aTaskDescription");
        task5.setOwner("aTaskOwner");
        task5.setAssignee("aTaskAssignee");
        task5.setPriority(4);
        this.taskService.saveTask(task5);
        Task task6 = this.taskService.newTask();
        task6.setName("aTaskName");
        task6.setDescription("aTaskDescription");
        task6.setOwner("aTaskOwner");
        task6.setAssignee("aTaskAssignee");
        task6.setPriority(4);
        this.taskService.saveTask(task6);
        List tasks = this.taskService.createTaskQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").endOr().or().taskName("aTaskName").taskDescription("aTaskDescription").taskAssignee("aTaskAssignee").endOr().or().taskName("aTaskName").taskDescription("aTaskDescription").taskOwner("aTaskOwner").taskAssignee("aTaskAssignee").endOr().or().taskAssignee("aTaskAssignee").taskPriority(Integer.valueOf(4)).endOr().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWhereSameCriterionWasAppliedThreeTimesInOneQuery() {
        Task task1 = this.taskService.newTask();
        this.taskService.saveTask(task1);
        this.taskService.addCandidateGroup(task1.getId(), "Accounting");
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        this.taskService.addCandidateGroup(task2.getId(), "Controlling");
        Task task3 = this.taskService.newTask();
        this.taskService.saveTask(task3);
        this.taskService.addCandidateGroup(task3.getId(), "Sales");
        List tasks = this.taskService.createTaskQuery().or().taskCandidateGroup("Accounting").taskCandidateGroup("Controlling").taskCandidateGroup("Sales").endOr().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWithTaskVariableValueEqualsOrTaskVariableValueGreaterThan() {
        Task task1 = this.taskService.newTask();
        this.taskService.saveTask(task1);
        this.taskService.setVariable(task1.getId(), "aLongValue", (Object)789L);
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        this.taskService.setVariable(task2.getId(), "anEvenLongerValue", (Object)1000L);
        TaskQuery query = this.taskService.createTaskQuery().or().taskVariableValueEquals("aLongValue", (Object)789L).taskVariableValueGreaterThan("anEvenLongerValue", (Object)999L).endOr();
        Assert.assertEquals((long)2L, (long)query.count());
    }

    @Test
    public void shouldInitializeFormKeys() {
        BpmnModelInstance aProcessDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().camundaFormKey("aFormKey")).endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("aProcessDefinition");
        BpmnModelInstance anotherProcessDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"anotherProcessDefinition").startEvent().userTask().camundaFormKey("anotherFormKey")).endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", anotherProcessDefinition).deploy();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("anotherProcessDefinition");
        List tasks = this.taskService.createTaskQuery().or().processDefinitionId(processInstance1.getProcessDefinitionId()).processInstanceId(processInstance2.getId()).endOr().initializeFormKeys().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"aFormKey", (Object)((Task)tasks.get(0)).getFormKey());
        Assert.assertEquals((Object)"anotherFormKey", (Object)((Task)tasks.get(1)).getFormKey());
    }

    @Test
    public void shouldReturnTasksWithProcessDefinitionNameOrProcessDefinitionKey() {
        BpmnModelInstance aProcessDefinition = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"aProcessDefinition").name("process1")).startEvent().userTask().endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy();
        this.runtimeService.startProcessInstanceByKey("aProcessDefinition");
        BpmnModelInstance anotherProcessDefinition = Bpmn.createExecutableProcess((String)"anotherProcessDefinition").startEvent().userTask().endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", anotherProcessDefinition).deploy();
        this.runtimeService.startProcessInstanceByKey("anotherProcessDefinition");
        List tasks = this.taskService.createTaskQuery().or().processDefinitionName("process1").processDefinitionKey("anotherProcessDefinition").endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksWithProcessInstanceBusinessKeyOrProcessInstanceBusinessKeyLike() {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy();
        this.runtimeService.startProcessInstanceByKey("aProcessDefinition", "aBusinessKey");
        BpmnModelInstance anotherProcessDefinition = Bpmn.createExecutableProcess((String)"anotherProcessDefinition").startEvent().userTask().endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", anotherProcessDefinition).deploy();
        this.runtimeService.startProcessInstanceByKey("anotherProcessDefinition", "anotherBusinessKey");
        List tasks = this.taskService.createTaskQuery().or().processInstanceBusinessKey("aBusinessKey").processInstanceBusinessKeyLike("anotherBusinessKey").endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase2.cmmn"})
    public void shouldReturnTasksWithCaseDefinitionKeyCaseDefinitionName() {
        String caseDefinitionId1 = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId1).create();
        String caseDefinitionId2 = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase2").singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId2).create();
        List tasks = this.taskService.createTaskQuery().or().caseDefinitionKey("oneTaskCase").caseDefinitionName("One").endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase2.cmmn"})
    public void shouldReturnTasksWithCaseInstanceBusinessKeyOrCaseInstanceBusinessKeyLike() {
        String caseDefinitionId1 = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").singleResult()).getId();
        CaseInstance caseInstance1 = this.caseService.withCaseDefinition(caseDefinitionId1).businessKey("aBusinessKey").create();
        String caseDefinitionId2 = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase2").singleResult()).getId();
        CaseInstance caseInstance2 = this.caseService.withCaseDefinition(caseDefinitionId2).businessKey("anotherBusinessKey").create();
        List tasks = this.taskService.createTaskQuery().or().caseInstanceBusinessKey(caseInstance1.getBusinessKey()).caseInstanceBusinessKeyLike(caseInstance2.getBusinessKey()).endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    @Ignore(value="CAM-9114")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void shouldReturnTasksWithCaseInstanceBusinessKeyOrProcessInstanceBusinessKey() {
        String businessKey = "aBusinessKey";
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy();
        this.runtimeService.startProcessInstanceByKey("aProcessDefinition", businessKey);
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).businessKey(businessKey).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.processInstanceBusinessKey(businessKey).or().caseInstanceBusinessKey(businessKey).processInstanceBusinessKey(businessKey).endOr();
        Assert.assertEquals((long)2L, (long)query.list().size());
    }

    @Test
    public void shouldReturnTasksWithActivityInstanceIdInOrTaskId() {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("aProcessDefinition");
        String activityInstanceId = this.runtimeService.getActivityInstance(processInstance1.getId()).getChildActivityInstances()[0].getId();
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        List tasks = this.taskService.createTaskQuery().or().activityInstanceIdIn(new String[]{activityInstanceId}).taskId(task2.getId()).endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnTasksByExtendingQuery_OrInExtendingQuery() {
        TaskQuery extendedQuery = this.taskService.createTaskQuery().taskCandidateGroup("sales");
        TaskQuery extendingQuery = this.taskService.createTaskQuery().or().taskName("aTaskName").endOr().or().taskNameLike("anotherTaskName").endOr();
        TaskQueryImpl result = (TaskQueryImpl)((TaskQueryImpl)extendedQuery).extend(extendingQuery);
        Assert.assertEquals((Object)"sales", (Object)result.getCandidateGroup());
        Assert.assertEquals((Object)"aTaskName", (Object)((TaskQueryImpl)result.getQueries().get(1)).getName());
        Assert.assertEquals((Object)"anotherTaskName", (Object)((TaskQueryImpl)result.getQueries().get(2)).getNameLike());
    }

    @Test
    public void shouldReturnTasksByExtendingQuery_OrInExtendedQuery() {
        TaskQuery extendedQuery = this.taskService.createTaskQuery().or().taskName("aTaskName").endOr().or().taskNameLike("anotherTaskName").endOr();
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskCandidateGroup("aCandidateGroup");
        TaskQueryImpl result = (TaskQueryImpl)((TaskQueryImpl)extendedQuery).extend(extendingQuery);
        Assert.assertEquals((Object)"aTaskName", (Object)((TaskQueryImpl)result.getQueries().get(1)).getName());
        Assert.assertEquals((Object)"anotherTaskName", (Object)((TaskQueryImpl)result.getQueries().get(2)).getNameLike());
        Assert.assertEquals((Object)"aCandidateGroup", (Object)result.getCandidateGroup());
    }

    @Test
    public void shouldReturnTasksByExtendingQuery_OrInBothExtendedAndExtendingQuery() {
        TaskQuery extendedQuery = this.taskService.createTaskQuery().or().taskName("aTaskName").endOr().or().taskNameLike("anotherTaskName").endOr();
        TaskQuery extendingQuery = this.taskService.createTaskQuery().or().taskCandidateGroup("aCandidateGroup").endOr().or().taskCandidateUser("aCandidateUser").endOr();
        TaskQueryImpl result = (TaskQueryImpl)((TaskQueryImpl)extendedQuery).extend(extendingQuery);
        Assert.assertEquals((Object)"aTaskName", (Object)((TaskQueryImpl)result.getQueries().get(1)).getName());
        Assert.assertEquals((Object)"anotherTaskName", (Object)((TaskQueryImpl)result.getQueries().get(2)).getNameLike());
        Assert.assertEquals((Object)"aCandidateGroup", (Object)((TaskQueryImpl)result.getQueries().get(3)).getCandidateGroup());
        Assert.assertEquals((Object)"aCandidateUser", (Object)((TaskQueryImpl)result.getQueries().get(4)).getCandidateUser());
    }

    @Test
    public void shouldTestDueDateCombinations() throws ParseException {
        HashMap<String, Date> dates = this.createFollowUpAndDueDateTasks();
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().or().dueDate(dates.get("date")).dueBefore(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().or().dueDate(dates.get("date")).dueAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().or().dueBefore(dates.get("oneHourAgo")).dueAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().or().dueBefore(dates.get("oneHourLater")).dueAfter(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().or().dueDate(dates.get("date")).dueBefore(dates.get("oneHourAgo")).dueAfter(dates.get("oneHourLater")).endOr().count());
    }

    @Test
    public void shouldTestFollowUpDateCombinations() throws ParseException {
        HashMap<String, Date> dates = this.createFollowUpAndDueDateTasks();
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().or().followUpDate(dates.get("date")).followUpBefore(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().or().followUpDate(dates.get("date")).followUpAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().or().followUpBefore(dates.get("oneHourAgo")).followUpAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().or().followUpBefore(dates.get("oneHourLater")).followUpAfter(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().or().followUpDate(dates.get("date")).followUpBefore(dates.get("oneHourAgo")).followUpAfter(dates.get("oneHourLater")).endOr().count());
        this.taskService.saveTask(this.taskService.newTask());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().or().followUpDate(dates.get("date")).followUpBeforeOrNotExistent(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().or().followUpBeforeOrNotExistent(dates.get("oneHourAgo")).followUpAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().or().followUpBeforeOrNotExistent(dates.get("oneHourLater")).followUpAfter(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().or().followUpDate(dates.get("date")).followUpBeforeOrNotExistent(dates.get("oneHourAgo")).followUpAfter(dates.get("oneHourLater")).endOr().count());
    }

    @Test
    public void shouldReturnTasksByVariableAndActiveProcesses() throws Exception {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask("testQuerySuspensionStateTask").endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("foo", 0);
        ProcessInstance suspendedProcessInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        this.runtimeService.suspendProcessInstanceById(suspendedProcessInstance.getProcessInstanceId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("testQuerySuspensionStateTask").active().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("testQuerySuspensionStateTask").suspended().count());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().or().active().processVariableValueEquals("foo", (Object)0).endOr().list().size());
    }

    public HashMap<String, Date> createFollowUpAndDueDateTasks() throws ParseException {
        final Date date = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("27/07/2017 01:12:13");
        final Date oneHourAgo = new Date(date.getTime() - 3600000L);
        final Date oneHourLater = new Date(date.getTime() + 3600000L);
        Task taskDueBefore = this.taskService.newTask();
        taskDueBefore.setFollowUpDate(new Date(oneHourAgo.getTime() - 1000L));
        taskDueBefore.setDueDate(new Date(oneHourAgo.getTime() - 1000L));
        this.taskService.saveTask(taskDueBefore);
        Task taskDueDate = this.taskService.newTask();
        taskDueDate.setFollowUpDate(date);
        taskDueDate.setDueDate(date);
        this.taskService.saveTask(taskDueDate);
        Task taskDueAfter = this.taskService.newTask();
        taskDueAfter.setFollowUpDate(new Date(oneHourLater.getTime() + 1000L));
        taskDueAfter.setDueDate(new Date(oneHourLater.getTime() + 1000L));
        this.taskService.saveTask(taskDueAfter);
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        return new HashMap<String, Date>(){
            {
                this.put("date", date);
                this.put("oneHourAgo", oneHourAgo);
                this.put("oneHourLater", oneHourLater);
            }
        };
    }
}

