/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.io.InputStream;
import java.util.ArrayList;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.jobexecutor.JobDefinitionCreationWithParseListenerTest;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobDefinitionCreationAndDeletionWithParseListenerTest {
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            ArrayList<1> listeners = new ArrayList<1>();
            listeners.add(new AbstractBpmnParseListener(){

                public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
                    activity.setAsyncBefore(false);
                    activity.setAsyncAfter(true);
                }
            });
            configuration.setCustomPreBPMNParseListeners(listeners);
            return configuration;
        }
    };
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule);

    @Test
    public void testDeleteNonExistingAndCreateNewJobDefinitionWithParseListener() {
        String modelFileName = "jobCreationWithinParseListener.bpmn20.xml";
        InputStream in = JobDefinitionCreationWithParseListenerTest.class.getResourceAsStream(modelFileName);
        DeploymentBuilder builder = this.engineRule.getRepositoryService().createDeployment().addInputStream(modelFileName, in);
        Deployment deployment = builder.deploy();
        this.engineRule.manageDeployment(deployment);
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        JobDefinition jobDef = (JobDefinition)query.singleResult();
        Assert.assertNotNull((Object)jobDef);
        Assert.assertEquals((Object)jobDef.getProcessDefinitionKey(), (Object)"oneTaskProcess");
        Assert.assertEquals((Object)jobDef.getActivityId(), (Object)"servicetask1");
        Assert.assertEquals((Object)jobDef.getJobConfiguration(), (Object)"async-after");
    }

    @Test
    public void testDeleteJobDefinitionWithParseListenerAndAsyncInXml() {
        String modelFileName = "jobAsyncBeforeCreationWithinParseListener.bpmn20.xml";
        InputStream in = JobDefinitionCreationWithParseListenerTest.class.getResourceAsStream(modelFileName);
        DeploymentBuilder builder = this.engineRule.getRepositoryService().createDeployment().addInputStream(modelFileName, in);
        Deployment deployment = builder.deploy();
        this.engineRule.manageDeployment(deployment);
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        JobDefinition jobDef = (JobDefinition)query.singleResult();
        Assert.assertNotNull((Object)jobDef);
        Assert.assertEquals((Object)jobDef.getProcessDefinitionKey(), (Object)"oneTaskProcess");
        Assert.assertEquals((Object)jobDef.getActivityId(), (Object)"servicetask1");
        Assert.assertEquals((Object)jobDef.getJobConfiguration(), (Object)"async-after");
    }

    @Test
    public void testDeleteJobDefinitionWithParseListenerAndAsyncBothInXml() {
        String modelFileName = "jobAsyncBothCreationWithinParseListener.bpmn20.xml";
        InputStream in = JobDefinitionCreationWithParseListenerTest.class.getResourceAsStream(modelFileName);
        DeploymentBuilder builder = this.engineRule.getRepositoryService().createDeployment().addInputStream(modelFileName, in);
        Deployment deployment = builder.deploy();
        this.engineRule.manageDeployment(deployment);
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        JobDefinition jobDef = (JobDefinition)query.singleResult();
        Assert.assertNotNull((Object)jobDef);
        Assert.assertEquals((Object)jobDef.getProcessDefinitionKey(), (Object)"oneTaskProcess");
        Assert.assertEquals((Object)jobDef.getActivityId(), (Object)"servicetask1");
        Assert.assertEquals((Object)jobDef.getJobConfiguration(), (Object)"async-after");
    }
}

