/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorAcquireJobsByTypeTest
extends AbstractJobExecutorAcquireJobsTest {
    @Before
    public void prepareProcessEngineConfiguration() {
        this.configuration.setJobExecutorPreferTimerJobs(true);
    }

    @Test
    public void testProcessEngineConfiguration() {
        Assert.assertTrue((boolean)this.configuration.isJobExecutorPreferTimerJobs());
        Assert.assertFalse((boolean)this.configuration.isJobExecutorAcquireByDueDate());
        Assert.assertFalse((boolean)this.configuration.isJobExecutorAcquireByPriority());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testMessageJobHasNoDueDateSet() {
        this.configuration.setEnsureJobDueDateNotNull(false);
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNull((Object)job.getDuedate());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testMessageJobHasDueDateSet() {
        this.configuration.setEnsureJobDueDateNotNull(true);
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((Object)ClockUtil.getCurrentTime(), (Object)job.getDuedate());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/processWithTimerCatch.bpmn20.xml"})
    public void testTimerJobsArePreferred() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        ClockTestUtil.incrementClock(70L);
        List<JobEntity> acquirableJobs = this.findAcquirableJobs();
        Assert.assertEquals((long)4L, (long)acquirableJobs.size());
        Assert.assertTrue((boolean)(acquirableJobs.get(0) instanceof TimerEntity));
        Assert.assertTrue((boolean)(acquirableJobs.get(1) instanceof TimerEntity));
        Assert.assertTrue((boolean)(acquirableJobs.get(2) instanceof MessageEntity));
        Assert.assertTrue((boolean)(acquirableJobs.get(3) instanceof MessageEntity));
    }
}

