/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JobExecutorAcquireJobsDefaultTest
extends AbstractJobExecutorAcquireJobsTest {
    @Parameterized.Parameter(value=0)
    public boolean ensureJobDueDateSet;
    @Parameterized.Parameter(value=1)
    public Date currentTime;

    @Parameterized.Parameters(name="Job DueDate is set: {0}")
    public static Collection<Object[]> scenarios() throws ParseException {
        return Arrays.asList({false, null}, {true, ClockTestUtil.setClockToDateWithoutMilliseconds()});
    }

    @Before
    public void setUp() {
        this.rule.getProcessEngineConfiguration().setEnsureJobDueDateNotNull(this.ensureJobDueDateSet);
    }

    @Test
    public void testProcessEngineConfiguration() {
        Assert.assertFalse((boolean)this.configuration.isJobExecutorPreferTimerJobs());
        Assert.assertFalse((boolean)this.configuration.isJobExecutorAcquireByDueDate());
        Assert.assertEquals((Object)this.ensureJobDueDateSet, (Object)this.configuration.isEnsureJobDueDateNotNull());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testJobDueDateValue() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        List<JobEntity> jobList = this.findAcquirableJobs();
        Assert.assertEquals((long)1L, (long)jobList.size());
        Assert.assertEquals((Object)this.currentTime, (Object)jobList.get(0).getDuedate());
    }
}

