/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobExecutorBatchTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    public CountingJobExecutor jobExecutor;
    protected JobExecutor defaultJobExecutor;
    protected int defaultBatchJobsPerSeed;

    @Before
    public void replaceJobExecutor() throws Exception {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.defaultJobExecutor = processEngineConfiguration.getJobExecutor();
        this.jobExecutor = new CountingJobExecutor();
        processEngineConfiguration.setJobExecutor((JobExecutor)this.jobExecutor);
    }

    @Before
    public void saveBatchJobsPerSeed() {
        this.defaultBatchJobsPerSeed = this.engineRule.getProcessEngineConfiguration().getBatchJobsPerSeed();
    }

    @After
    public void resetJobExecutor() {
        this.engineRule.getProcessEngineConfiguration().setJobExecutor(this.defaultJobExecutor);
    }

    @After
    public void resetBatchJobsPerSeed() {
        this.engineRule.getProcessEngineConfiguration().setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void testJobExecutorHintedOnBatchCreation() {
        this.jobExecutor.startRecord();
        this.helper.migrateProcessInstancesAsync(2);
        Assert.assertEquals((long)1L, (long)this.jobExecutor.getJobsAdded());
    }

    @Test
    public void testJobExecutorHintedSeedJobExecution() {
        this.engineRule.getProcessEngineConfiguration().setBatchJobsPerSeed(10);
        Batch batch = this.helper.migrateProcessInstancesAsync(13);
        this.jobExecutor.startRecord();
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)11L, (long)this.jobExecutor.getJobsAdded());
    }

    @Test
    public void testJobExecutorHintedSeedJobCompletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(3);
        this.jobExecutor.startRecord();
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)4L, (long)this.jobExecutor.getJobsAdded());
    }

    public class CountingJobExecutor
    extends JobExecutor {
        public boolean record = false;
        public long jobsAdded = 0L;

        public boolean isActive() {
            return true;
        }

        protected void startExecutingJobs() {
        }

        protected void stopExecutingJobs() {
        }

        public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
        }

        public void startRecord() {
            this.resetJobsAdded();
            this.record = true;
        }

        public void jobWasAdded() {
            if (this.record) {
                ++this.jobsAdded;
            }
        }

        public long getJobsAdded() {
            return this.jobsAdded;
        }

        public void resetJobsAdded() {
            this.jobsAdded = 0L;
        }
    }
}

