/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SchemaLogTestCase {
    protected static final String BASE_PATH = "org/camunda/bpm/engine/db";
    protected static final String CREATE_SCRIPT_FOLDER = "org/camunda/bpm/engine/db/create";
    protected static final String UPGRADE_SCRIPT_FOLDER = "org/camunda/bpm/engine/db/upgrade";
    protected static final List<String> SCRIPT_FOLDERS = Arrays.asList("org/camunda/bpm/engine/db/create", "org/camunda/bpm/engine/db/upgrade");
    protected static final String[] DATABASES = DbSqlSessionFactory.SUPPORTED_DATABASES;
    @Rule
    public ProcessEngineRule rule = new ProcessEngineRule();
    public ProcessEngine processEngine;
    protected String folderPath;
    protected Map<String, List<String>> folderContents;

    @Before
    public void init() {
        this.processEngine = this.rule.getProcessEngine();
        this.folderContents = new HashMap<String, List<String>>();
        for (String folder : SCRIPT_FOLDERS) {
            this.folderContents.put(folder, this.readFolderContent(folder));
        }
    }

    private List<String> readFolderContent(String folder) {
        ArrayList<String> files = new ArrayList<String>();
        String path = "classpath:" + folder + "/*";
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources(path);
            Assert.assertThat((String)("No resources found at " + path), (Object)resources.length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            for (Resource res : resources) {
                files.add(res.getFilename());
            }
        }
        catch (IOException e) {
            Assert.fail((String)("unable to load resources from " + path));
        }
        return files;
    }

    public boolean isMinorLevel(String version) {
        return version.split("\\.").length == 2;
    }

    public boolean isPatchLevel(String version) {
        return version.split("\\.").length == 3;
    }
}

