/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.db.entitymanager;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.management.DatabasePurgeReport;
import org.camunda.bpm.engine.impl.management.PurgeReport;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CachePurgeReport;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.identity.TestPermissions;
import org.camunda.bpm.engine.test.api.identity.TestResource;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class PurgeDatabaseTest {
    protected static final String PROCESS_DEF_KEY = "test";
    protected static final String PROCESS_MODEL_NAME = "test.bpmn20.xml";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private String databaseTablePrefix;

    @Before
    public void setUp() throws Exception {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setDbMetricsReporterActivate(true);
        this.databaseTablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
    }

    @After
    public void cleanUp() {
        this.processEngineConfiguration.setDbMetricsReporterActivate(false);
    }

    @Test
    public void testPurge() {
        BpmnModelInstance test = Bpmn.createExecutableProcess((String)PROCESS_DEF_KEY).startEvent().endEvent().done();
        this.engineRule.getRepositoryService().createDeployment().addModelInstance(PROCESS_MODEL_NAME, test).deploy();
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEF_KEY);
        ManagementServiceImpl managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        managementService.purge();
        TestHelper.assertAndEnsureCleanDbAndCache((ProcessEngine)this.engineRule.getProcessEngine(), (boolean)true);
    }

    @Test
    public void testPurgeWithExistingProcessInstance() {
        BpmnModelInstance test = Bpmn.createExecutableProcess((String)PROCESS_DEF_KEY).startEvent().userTask().userTask().endEvent().done();
        this.engineRule.getRepositoryService().createDeployment().addModelInstance(PROCESS_MODEL_NAME, test).deploy();
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"key", (Object)"value");
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEF_KEY, (Map)variables);
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        ManagementServiceImpl managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        managementService.purge();
        TestHelper.assertAndEnsureCleanDbAndCache((ProcessEngine)this.engineRule.getProcessEngine(), (boolean)true);
    }

    @Test
    public void testPurgeWithAsyncProcessInstance() {
        BpmnModelInstance test = ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEF_KEY).startEvent().camundaAsyncBefore()).userTask().userTask().endEvent().done();
        this.engineRule.getRepositoryService().createDeployment().addModelInstance(PROCESS_MODEL_NAME, test).deploy();
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"key", (Object)"value");
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEF_KEY, (Map)variables);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        this.engineRule.getManagementService().executeJob(job.getId());
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        ManagementServiceImpl managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        managementService.purge();
        TestHelper.assertAndEnsureCleanDbAndCache((ProcessEngine)this.engineRule.getProcessEngine(), (boolean)true);
    }

    @Test
    public void testPurgeComplexProcess() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEF_KEY).startEvent().camundaAsyncBefore()).parallelGateway("parallel").serviceTask("external").camundaType("external")).camundaTopic("external")).boundaryEvent().message("message")).moveToNode("parallel").serviceTask().camundaAsyncBefore()).camundaExpression("${1/0}")).moveToLastGateway().userTask().done();
        this.createAuthenticationData();
        this.engineRule.getRepositoryService().createDeployment().addModelInstance(PROCESS_MODEL_NAME, modelInstance).deploy();
        this.executeComplexBpmnProcess(true);
        this.executeComplexBpmnProcess(false);
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        ManagementServiceImpl managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        PurgeReport purge = managementService.purge();
        TestHelper.assertAndEnsureCleanDbAndCache((ProcessEngine)this.engineRule.getProcessEngine(), (boolean)true);
        Assert.assertFalse((boolean)purge.isEmpty());
        CachePurgeReport cachePurgeReport = purge.getCachePurgeReport();
        Assert.assertEquals((long)1L, (long)cachePurgeReport.getReportValue("PROC_DEF_CACHE").size());
        DatabasePurgeReport databasePurgeReport = purge.getDatabasePurgeReport();
        Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_ID_TENANT_MEMBER"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_EVENT_SUBSCR"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RE_DEPLOYMENT"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_EXT_TASK"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_ID_MEMBERSHIP"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_TASK"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_JOB"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_GE_BYTEARRAY"));
        Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_JOBDEF"));
        Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_ID_USER"));
        Assert.assertEquals((long)5L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_EXECUTION"));
        Assert.assertEquals((long)10L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_METER_LOG"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_VARIABLE"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RE_PROCDEF"));
        Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_ID_TENANT"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_ID_GROUP"));
        Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_AUTHORIZATION"));
        if (this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_INCIDENT"));
            Assert.assertEquals((long)9L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_ACTINST"));
            Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_PROCINST"));
            Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_DETAIL"));
            Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_TASKINST"));
            Assert.assertEquals((long)7L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_JOB_LOG"));
            Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_VARINST"));
            Assert.assertEquals((long)8L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_OP_LOG"));
        }
    }

    private void createAuthenticationData() {
        IdentityService identityService = this.engineRule.getIdentityService();
        Group group = identityService.newGroup("group");
        identityService.saveGroup(group);
        User user = identityService.newUser("user");
        User user2 = identityService.newUser("user2");
        identityService.saveUser(user);
        identityService.saveUser(user2);
        Tenant tenant = identityService.newTenant("tenant");
        identityService.saveTenant(tenant);
        Tenant tenant2 = identityService.newTenant("tenant2");
        identityService.saveTenant(tenant2);
        identityService.createMembership("user", "group");
        identityService.createTenantUserMembership("tenant", "user");
        identityService.createTenantUserMembership("tenant2", "user2");
        TestResource resource1 = TestResource.RESOURCE1;
        AuthorizationService authorizationService = this.engineRule.getAuthorizationService();
        Authorization globalAuth = authorizationService.createNewAuthorization(0);
        globalAuth.setResource((Resource)resource1);
        globalAuth.setResourceId("*");
        globalAuth.addPermission((Permission)TestPermissions.ALL);
        authorizationService.saveAuthorization(globalAuth);
        TestResource resource2 = TestResource.RESOURCE2;
        Authorization userGrant = authorizationService.createNewAuthorization(1);
        userGrant.setUserId("user");
        userGrant.setResource((Resource)resource2);
        userGrant.setResourceId("*");
        userGrant.addPermission((Permission)TestPermissions.READ);
        authorizationService.saveAuthorization(userGrant);
        identityService.setAuthenticatedUserId("user");
    }

    private void executeComplexBpmnProcess(boolean complete) {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"key", (Object)"value");
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEF_KEY, (Map)variables);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        this.engineRule.getManagementService().executeJob(job.getId());
        List externalTasks = this.engineRule.getExternalTaskService().fetchAndLock(1, "worker").topic("external", 1500L).execute();
        job = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        if (complete) {
            this.engineRule.getManagementService().setJobRetries(job.getId(), 0);
            this.engineRule.getManagementService().executeJob(job.getId());
            this.engineRule.getExternalTaskService().complete(((LockedExternalTask)externalTasks.get(0)).getId(), "worker");
            this.engineRule.getTaskService().complete(task.getId());
        }
    }

    @Test
    public void testPurgeCmmnProcess() {
        this.engineRule.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/standalone/db/entitymanager/PurgeDatabaseTest.testPurgeCmmnProcess.cmmn").deploy();
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"key", (Object)"value");
        this.engineRule.getCaseService().createCaseInstanceByKey(PROCESS_DEF_KEY, (Map)variables);
        ManagementServiceImpl managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        PurgeReport purge = managementService.purge();
        TestHelper.assertAndEnsureCleanDbAndCache((ProcessEngine)this.engineRule.getProcessEngine(), (boolean)true);
        Assert.assertFalse((boolean)purge.isEmpty());
        CachePurgeReport cachePurgeReport = purge.getCachePurgeReport();
        Assert.assertEquals((long)1L, (long)cachePurgeReport.getReportValue("CASE_DEF_CACHE").size());
        DatabasePurgeReport databasePurgeReport = purge.getDatabasePurgeReport();
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RE_DEPLOYMENT"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_TASK"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_GE_BYTEARRAY"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RE_CASE_DEF"));
        Assert.assertEquals((long)3L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_CASE_EXECUTION"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_VARIABLE"));
        Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RU_CASE_SENTRY_PART"));
        if (this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_DETAIL"));
            Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_TASKINST"));
            Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_VARINST"));
            Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_CASEINST"));
            Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_CASEACTINST"));
        }
    }

    @Test
    public void testPurgeDmnProcess() {
        this.engineRule.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/standalone/db/entitymanager/PurgeDatabaseTest.testPurgeDmnProcess.dmn").deploy();
        VariableMap variables = Variables.createVariables().putValue("key", (Object)"value").putValue("season", (Object)"Test");
        this.engineRule.getDecisionService().evaluateDecisionByKey("decisionId").variables((Map)variables).evaluate();
        ManagementServiceImpl managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        PurgeReport purge = managementService.purge();
        TestHelper.assertAndEnsureCleanDbAndCache((ProcessEngine)this.engineRule.getProcessEngine(), (boolean)true);
        Assert.assertFalse((boolean)purge.isEmpty());
        CachePurgeReport cachePurgeReport = purge.getCachePurgeReport();
        Assert.assertEquals((long)2L, (long)cachePurgeReport.getReportValue("DMN_DEF_CACHE").size());
        Assert.assertEquals((long)1L, (long)cachePurgeReport.getReportValue("DMN_REQ_DEF_CACHE").size());
        DatabasePurgeReport databasePurgeReport = purge.getDatabasePurgeReport();
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RE_DEPLOYMENT"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_GE_BYTEARRAY"));
        Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RE_DECISION_REQ_DEF"));
        Assert.assertEquals((long)2L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_RE_DECISION_DEF"));
        if (this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_DECINST"));
            Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_DEC_IN"));
            Assert.assertEquals((long)1L, (long)databasePurgeReport.getReportValue(this.databaseTablePrefix + "ACT_HI_DEC_OUT"));
        }
    }
}

