/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.dmn;

import java.io.InputStream;
import java.util.Collection;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DecisionRequirementsDefinitionAuthorizationTest {
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DRD_FILE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.png";
    protected static final String DEFINITION_KEY = "dish";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter(value=0)
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.DECISION_REQUIREMENTS_DEFINITION, DEFINITION_KEY, "userId", new Permission[]{Permissions.READ})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_REQUIREMENTS_DEFINITION, DEFINITION_KEY, "userId", new Permission[]{Permissions.READ})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_REQUIREMENTS_DEFINITION, "*", "userId", new Permission[]{Permissions.READ})).succeeds());
    }

    @Before
    public void setUp() throws Exception {
        this.authRule.createUserAndGroup("userId", "groupId");
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void getDecisionRequirementsDefinition() {
        String decisionRequirementsDefinitionId = ((DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DEFINITION_KEY).singleResult()).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("decisionRequirementsDefinitionKey", DEFINITION_KEY).start();
        DecisionRequirementsDefinition decisionRequirementsDefinition = this.repositoryService.getDecisionRequirementsDefinition(decisionRequirementsDefinitionId);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertNotNull((Object)decisionRequirementsDefinition);
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void getDecisionRequirementsModel() {
        String decisionRequirementsDefinitionId = ((DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DEFINITION_KEY).singleResult()).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("decisionRequirementsDefinitionKey", DEFINITION_KEY).start();
        InputStream decisionRequirementsModel = this.repositoryService.getDecisionRequirementsModel(decisionRequirementsDefinitionId);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertNotNull((Object)decisionRequirementsModel);
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.png"})
    public void getDecisionRequirementsDiagram() {
        String decisionRequirementsDefinitionId = ((DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DEFINITION_KEY).singleResult()).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("decisionRequirementsDefinitionKey", DEFINITION_KEY).start();
        InputStream decisionRequirementsDiagram = this.repositoryService.getDecisionRequirementsDiagram(decisionRequirementsDefinitionId);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertNotNull((Object)decisionRequirementsDiagram);
        }
    }
}

