/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyExternalTaskCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "twoExternalTaskProcess";
    protected static final String PROCESS_DEFINITION_KEY_ONE = "oneExternalTaskProcess";
    private static final String ERROR_DETAILS = "anErrorDetail";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected static final String WORKER_ID = "aWorkerId";
    protected static final long LOCK_TIME = 10000L;
    protected static final String TOPIC_NAME = "externalTaskTopic";
    protected static final String ERROR_MESSAGE = "errorMessage";
    protected ExternalTaskService externalTaskService;
    protected TaskService taskService;
    protected String processInstanceId;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void init() {
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml");
        this.processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
    }

    @Test
    public void testFetchAndLockWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
    }

    @Test
    public void testFetchAndLockWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
    }

    @Test
    public void testFetchAndLockWithDifferentTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList("tenantTwo"));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
    }

    @Test
    public void testFetchAndLockWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
    }

    @Test
    public void testFetchAndLockWithoutTenantId() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).withoutTenantId().execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
    }

    @Test
    public void testFetchAndLockWithTenantId() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml");
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY_ONE).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).tenantIdIn(new String[]{TENANT_ONE}).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
    }

    @Test
    public void testFetchAndLockWithTenantIdIn() {
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
    }

    @Test
    public void testFetchAndLockWithTenantIdInTwoTenants() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskWithPriorityProcess.bpmn20.xml");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("twoExternalTaskWithPriorityProcess").getId();
        this.testRule.deployForTenant(TENANT_TWO, "org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml");
        String instanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY_ONE).getId();
        List externalTasks = this.externalTaskService.fetchAndLock(2, WORKER_ID).topic(TOPIC_NAME, 10000L).tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).execute();
        Assert.assertEquals((long)2L, (long)externalTasks.size());
        for (LockedExternalTask externalTask : externalTasks) {
            if (externalTask.getProcessInstanceId().equals(this.processInstanceId)) {
                Assert.assertEquals((Object)TENANT_ONE, (Object)externalTask.getTenantId());
                continue;
            }
            if (externalTask.getProcessInstanceId().equals(instanceId)) {
                Assert.assertEquals((Object)TENANT_TWO, (Object)externalTask.getTenantId());
                continue;
            }
            Assert.fail((String)"No other external tasks should be available!");
        }
    }

    @Test
    public void testCompleteWithAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().active().count());
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.externalTaskService.complete(externalTaskId, WORKER_ID);
        Assert.assertThat((Object)this.externalTaskService.createExternalTaskQuery().active().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testCompleteWithNoAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().active().count());
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
        this.externalTaskService.complete(externalTaskId, WORKER_ID);
    }

    @Test
    public void testCompleteWithDisableTenantCheck() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().active().count());
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.externalTaskService.complete(externalTaskId, WORKER_ID);
        Assert.assertThat((Object)this.externalTaskService.createExternalTaskQuery().active().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testHandleFailureWithAuthenticatedTenant() {
        LockedExternalTask task = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 1, 0L);
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)((LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getErrorMessage());
    }

    @Test
    public void testHandleFailureWithNoAuthenticatedTenant() {
        LockedExternalTask task = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0);
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 1, 0L);
    }

    @Test
    public void testHandleFailureWithDisabledTenantCheck() {
        String taskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.externalTaskService.handleFailure(taskId, WORKER_ID, ERROR_MESSAGE, 1, 0L);
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)((LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getErrorMessage());
    }

    @Test
    public void testHandleBPMNErrorWithAuthenticatedTenant() {
        String taskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.externalTaskService.handleBpmnError(taskId, WORKER_ID, "ERROR-OCCURED");
        Assert.assertEquals((Object)((Task)this.taskService.createTaskQuery().singleResult()).getTaskDefinitionKey(), (Object)"afterBpmnError");
    }

    @Test
    public void testHandleBPMNErrorWithNoAuthenticatedTenant() {
        String taskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
        this.externalTaskService.handleBpmnError(taskId, WORKER_ID, "ERROR-OCCURED");
    }

    @Test
    public void testHandleBPMNErrorWithDisabledTenantCheck() {
        String taskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.externalTaskService.handleBpmnError(taskId, WORKER_ID, "ERROR-OCCURED");
        Assert.assertEquals((Object)((Task)this.taskService.createTaskQuery().singleResult()).getTaskDefinitionKey(), (Object)"afterBpmnError");
    }

    @Test
    public void testSetRetriesWithAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.externalTaskService.setRetries(externalTaskId, 5);
        Assert.assertEquals((long)5L, (long)((ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult()).getRetries().intValue());
    }

    @Test
    public void testSetRetriesWithNoAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
        this.externalTaskService.setRetries(externalTaskId, 5);
    }

    @Test
    public void testSetRetriesWithDisabledTenantCheck() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.externalTaskService.setRetries(externalTaskId, 5);
        Assert.assertEquals((long)5L, (long)((ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult()).getRetries().intValue());
    }

    @Test
    public void testSetPriorityWithAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.externalTaskService.setPriority(externalTaskId, 1L);
        Assert.assertEquals((long)1L, (long)((int)((ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult()).getPriority()));
    }

    @Test
    public void testSetPriorityWithNoAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
        this.externalTaskService.setPriority(externalTaskId, 1L);
    }

    @Test
    public void testSetPriorityWithDisabledTenantCheck() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.externalTaskService.setPriority(externalTaskId, 1L);
        Assert.assertEquals((long)1L, (long)((int)((ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult()).getPriority()));
    }

    @Test
    public void testUnlockWithAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        Assert.assertThat((Object)this.externalTaskService.createExternalTaskQuery().locked().count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.externalTaskService.unlock(externalTaskId);
        Assert.assertThat((Object)this.externalTaskService.createExternalTaskQuery().locked().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testUnlockWithNoAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
        this.externalTaskService.unlock(externalTaskId);
    }

    @Test
    public void testUnlockWithDisabledTenantCheck() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.externalTaskService.unlock(externalTaskId);
        Assert.assertThat((Object)this.externalTaskService.createExternalTaskQuery().locked().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testGetErrorDetailsWithAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.externalTaskService.handleFailure(externalTaskId, WORKER_ID, ERROR_MESSAGE, ERROR_DETAILS, 1, 1000L);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertThat((Object)this.externalTaskService.getExternalTaskErrorDetails(externalTaskId), (Matcher)CoreMatchers.is((Object)ERROR_DETAILS));
    }

    @Test
    public void testGetErrorDetailsWithNoAuthenticatedTenant() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.externalTaskService.handleFailure(externalTaskId, WORKER_ID, ERROR_MESSAGE, ERROR_DETAILS, 1, 1000L);
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot read the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
        this.externalTaskService.getExternalTaskErrorDetails(externalTaskId);
    }

    @Test
    public void testGetErrorDetailsWithDisabledTenantCheck() {
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().get(0)).getId();
        this.externalTaskService.handleFailure(externalTaskId, WORKER_ID, ERROR_MESSAGE, ERROR_DETAILS, 1, 1000L);
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertThat((Object)this.externalTaskService.getExternalTaskErrorDetails(externalTaskId), (Matcher)CoreMatchers.is((Object)ERROR_DETAILS));
    }
}

