/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.MilestoneActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.MilestoneItemHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.SentryHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.instance.DefaultControl;
import org.camunda.bpm.model.cmmn.instance.EntryCriterion;
import org.camunda.bpm.model.cmmn.instance.ExitCriterion;
import org.camunda.bpm.model.cmmn.instance.IfPart;
import org.camunda.bpm.model.cmmn.instance.ItemControl;
import org.camunda.bpm.model.cmmn.instance.Milestone;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemControl;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.RepetitionRule;
import org.camunda.bpm.model.cmmn.instance.RequiredRule;
import org.camunda.bpm.model.cmmn.instance.Sentry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MilestonePlanItemHandlerTest
extends CmmnElementHandlerTest {
    protected Milestone milestone;
    protected PlanItem planItem;
    protected MilestoneItemHandler handler = new MilestoneItemHandler();

    @Before
    public void setUp() {
        this.milestone = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aMilestone", Milestone.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aMilestone", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.milestone);
    }

    @Test
    public void testMilestoneActivityName() {
        String name = "A Milestone";
        this.milestone.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testPlanItemActivityName() {
        String milestoneName = "A Milestone";
        this.milestone.setName(milestoneName);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNotEquals((Object)milestoneName, (Object)activity.getName());
        Assert.assertEquals((Object)planItemName, (Object)activity.getName());
    }

    @Test
    public void testMilestoneActivityType() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        String activityType = (String)activity.getProperty("activityType");
        Assert.assertEquals((Object)"milestone", (Object)activityType);
    }

    @Test
    public void testMilestoneDescription() {
        String description = "This is a milestone";
        this.milestone.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)activity.getProperty("description"));
    }

    @Test
    public void testPlanItemDescription() {
        String description = "This is a planItem";
        this.planItem.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)activity.getProperty("description"));
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof MilestoneActivityBehavior));
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testEntryCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        conditionExpression.setText("${test}");
        EntryCriterion criterion = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion.setSentry(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }

    @Test
    public void testMultipleEntryCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        conditionExpression1.setText("${test}");
        EntryCriterion criterion1 = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion1.setSentry(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        conditionExpression2.setText("${test}");
        EntryCriterion criterion2 = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion2.setSentry(sentry2);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration firstSentryDeclaration = new SentryHandler().handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = new SentryHandler().handleElement(sentry2, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getEntryCriteria().size());
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testEntryCriteriaAndExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        conditionExpression.setText("${test}");
        EntryCriterion criterion1 = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion1.setSentry(sentry);
        ExitCriterion criterion2 = this.createElement((CmmnModelElementInstance)this.planItem, ExitCriterion.class);
        criterion2.setSentry(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }

    @Test
    public void testRequiredRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)itemControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.milestone, "ItemControl_1", DefaultControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)defaultControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRepetitionRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)itemControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("repetitionRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRepetitionRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.milestone, "DefaultControl_1", DefaultControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)defaultControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("repetitionRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }
}

