/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryBuilder;
import org.camunda.bpm.engine.externaltask.UpdateExternalTaskRetriesSelectBuilder;
import org.camunda.bpm.engine.impl.ExternalTaskQueryImpl;
import org.camunda.bpm.engine.impl.ServiceImpl;
import org.camunda.bpm.engine.impl.cmd.CompleteExternalTaskCmd;
import org.camunda.bpm.engine.impl.cmd.ExtendLockOnExternalTaskCmd;
import org.camunda.bpm.engine.impl.cmd.GetExternalTaskErrorDetailsCmd;
import org.camunda.bpm.engine.impl.cmd.HandleExternalTaskBpmnErrorCmd;
import org.camunda.bpm.engine.impl.cmd.HandleExternalTaskFailureCmd;
import org.camunda.bpm.engine.impl.cmd.SetExternalTaskPriorityCmd;
import org.camunda.bpm.engine.impl.cmd.SetExternalTaskRetriesCmd;
import org.camunda.bpm.engine.impl.cmd.UnlockExternalTaskCmd;
import org.camunda.bpm.engine.impl.cmd.UpdateExternalTaskRetriesBuilderImpl;
import org.camunda.bpm.engine.impl.externaltask.ExternalTaskQueryTopicBuilderImpl;

public class ExternalTaskServiceImpl
extends ServiceImpl
implements ExternalTaskService {
    @Override
    public ExternalTaskQueryBuilder fetchAndLock(int maxTasks, String workerId) {
        return this.fetchAndLock(maxTasks, workerId, false);
    }

    @Override
    public ExternalTaskQueryBuilder fetchAndLock(int maxTasks, String workerId, boolean usePriority) {
        return new ExternalTaskQueryTopicBuilderImpl(this.commandExecutor, workerId, maxTasks, usePriority);
    }

    @Override
    public void complete(String externalTaskId, String workerId) {
        this.complete(externalTaskId, workerId, null, null);
    }

    @Override
    public void complete(String externalTaskId, String workerId, Map<String, Object> variables) {
        this.complete(externalTaskId, workerId, variables, null);
    }

    @Override
    public void complete(String externalTaskId, String workerId, Map<String, Object> variables, Map<String, Object> localVariables) {
        this.commandExecutor.execute(new CompleteExternalTaskCmd(externalTaskId, workerId, variables, localVariables));
    }

    @Override
    public void handleFailure(String externalTaskId, String workerId, String errorMessage, int retries, long retryDuration) {
        this.handleFailure(externalTaskId, workerId, errorMessage, null, retries, retryDuration);
    }

    @Override
    public void handleFailure(String externalTaskId, String workerId, String errorMessage, String errorDetails, int retries, long retryDuration) {
        this.commandExecutor.execute(new HandleExternalTaskFailureCmd(externalTaskId, workerId, errorMessage, errorDetails, retries, retryDuration));
    }

    @Override
    public void handleBpmnError(String externalTaskId, String workerId, String errorCode) {
        this.handleBpmnError(externalTaskId, workerId, errorCode, null, null);
    }

    @Override
    public void handleBpmnError(String externalTaskId, String workerId, String errorCode, String errorMessage) {
        this.handleBpmnError(externalTaskId, workerId, errorCode, errorMessage, null);
    }

    @Override
    public void handleBpmnError(String externalTaskId, String workerId, String errorCode, String errorMessage, Map<String, Object> variables) {
        this.commandExecutor.execute(new HandleExternalTaskBpmnErrorCmd(externalTaskId, workerId, errorCode, errorMessage, variables));
    }

    @Override
    public void unlock(String externalTaskId) {
        this.commandExecutor.execute(new UnlockExternalTaskCmd(externalTaskId));
    }

    public void setRetries(String externalTaskId, int retries, boolean writeUserOperationLog) {
        this.commandExecutor.execute(new SetExternalTaskRetriesCmd(externalTaskId, retries, writeUserOperationLog));
    }

    @Override
    public void setPriority(String externalTaskId, long priority) {
        this.commandExecutor.execute(new SetExternalTaskPriorityCmd(externalTaskId, priority));
    }

    @Override
    public ExternalTaskQuery createExternalTaskQuery() {
        return new ExternalTaskQueryImpl(this.commandExecutor);
    }

    @Override
    public String getExternalTaskErrorDetails(String externalTaskId) {
        return this.commandExecutor.execute(new GetExternalTaskErrorDetailsCmd(externalTaskId));
    }

    @Override
    public void setRetries(String externalTaskId, int retries) {
        this.setRetries(externalTaskId, retries, true);
    }

    @Override
    public void setRetries(List<String> externalTaskIds, int retries) {
        this.updateRetries().externalTaskIds(externalTaskIds).set(retries);
    }

    @Override
    public Batch setRetriesAsync(List<String> externalTaskIds, ExternalTaskQuery externalTaskQuery, int retries) {
        return this.updateRetries().externalTaskIds(externalTaskIds).externalTaskQuery(externalTaskQuery).setAsync(retries);
    }

    @Override
    public UpdateExternalTaskRetriesSelectBuilder updateRetries() {
        return new UpdateExternalTaskRetriesBuilderImpl(this.commandExecutor);
    }

    @Override
    public void extendLock(String externalTaskId, String workerId, long lockDuration) {
        this.commandExecutor.execute(new ExtendLockOnExternalTaskCmd(externalTaskId, workerId, lockDuration));
    }
}

