/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.context;

import java.util.concurrent.Callable;
import org.camunda.bpm.application.InvocationContext;
import org.camunda.bpm.application.ProcessApplicationContext;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationUnavailableException;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithoutEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ProcessApplicationContextTest
extends PluggableProcessEngineTestCase {
    protected TestApplicationWithoutEngine pa;

    public void setUp() {
        this.pa = new TestApplicationWithoutEngine();
        this.pa.deploy();
    }

    public void tearDown() {
        this.pa.undeploy();
    }

    public void testSetPAContextByName() throws ProcessApplicationUnavailableException {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        try {
            ProcessApplicationContext.setCurrentProcessApplication((String)this.pa.getName());
            Assert.assertEquals((Object)this.getCurrentContextApplication().getProcessApplication(), (Object)((Object)this.pa));
        }
        finally {
            ProcessApplicationContext.clear();
        }
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    public void testExecutionInPAContextByName() throws Exception {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        ProcessApplicationReference contextPA = (ProcessApplicationReference)ProcessApplicationContext.withProcessApplicationContext((Callable)new Callable<ProcessApplicationReference>(){

            @Override
            public ProcessApplicationReference call() throws Exception {
                return ProcessApplicationContextTest.this.getCurrentContextApplication();
            }
        }, (String)this.pa.getName());
        Assert.assertEquals((Object)contextPA.getProcessApplication(), (Object)((Object)this.pa));
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    public void testSetPAContextByReference() throws ProcessApplicationUnavailableException {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        try {
            ProcessApplicationContext.setCurrentProcessApplication((ProcessApplicationReference)this.pa.getReference());
            Assert.assertEquals((Object)this.getCurrentContextApplication().getProcessApplication(), (Object)((Object)this.pa));
        }
        finally {
            ProcessApplicationContext.clear();
        }
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    public void testExecutionInPAContextByReference() throws Exception {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        ProcessApplicationReference contextPA = (ProcessApplicationReference)ProcessApplicationContext.withProcessApplicationContext((Callable)new Callable<ProcessApplicationReference>(){

            @Override
            public ProcessApplicationReference call() throws Exception {
                return ProcessApplicationContextTest.this.getCurrentContextApplication();
            }
        }, (ProcessApplicationReference)this.pa.getReference());
        Assert.assertEquals((Object)contextPA.getProcessApplication(), (Object)((Object)this.pa));
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    public void testSetPAContextByRawPA() throws ProcessApplicationUnavailableException {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        try {
            ProcessApplicationContext.setCurrentProcessApplication((ProcessApplicationInterface)this.pa);
            Assert.assertEquals((Object)((Object)this.pa), (Object)this.getCurrentContextApplication().getProcessApplication());
        }
        finally {
            ProcessApplicationContext.clear();
        }
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    public void testExecutionInPAContextbyRawPA() throws Exception {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        ProcessApplicationReference contextPA = (ProcessApplicationReference)ProcessApplicationContext.withProcessApplicationContext((Callable)new Callable<ProcessApplicationReference>(){

            @Override
            public ProcessApplicationReference call() throws Exception {
                return ProcessApplicationContextTest.this.getCurrentContextApplication();
            }
        }, (ProcessApplicationInterface)this.pa);
        Assert.assertEquals((Object)contextPA.getProcessApplication(), (Object)((Object)this.pa));
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    public void testCannotSetUnregisteredProcessApplicationName() {
        String nonExistingName = this.pa.getName() + this.pa.getName();
        try {
            ProcessApplicationContext.setCurrentProcessApplication((String)nonExistingName);
            try {
                this.getCurrentContextApplication();
                ProcessApplicationContextTest.fail((String)"should not succeed");
            }
            catch (ProcessEngineException e) {
                this.assertTextPresent("A process application with name '" + nonExistingName + "' is not registered", e.getMessage());
            }
        }
        finally {
            ProcessApplicationContext.clear();
        }
    }

    public void testCannotExecuteInUnregisteredPaContext() throws Exception {
        String nonExistingName = this.pa.getName() + this.pa.getName();
        try {
            ProcessApplicationContext.withProcessApplicationContext((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ProcessApplicationContextTest.this.getCurrentContextApplication();
                    return null;
                }
            }, (String)nonExistingName);
            ProcessApplicationContextTest.fail((String)"should not succeed");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("A process application with name '" + nonExistingName + "' is not registered", e.getMessage());
        }
    }

    public void testExecuteWithInvocationContext() throws Exception {
        TestApplicationWithoutEngine processApplication = (TestApplicationWithoutEngine)((Object)Mockito.spy((Object)((Object)this.pa)));
        ProcessApplicationReference processApplicationReference = (ProcessApplicationReference)Mockito.mock(ProcessApplicationReference.class);
        Mockito.when((Object)processApplicationReference.getProcessApplication()).thenReturn((Object)processApplication);
        InvocationContext invocationContext = new InvocationContext((BaseDelegateExecution)Mockito.mock(BaseDelegateExecution.class));
        Context.executeWithinProcessApplication((Callable)((Callable)Mockito.mock(Callable.class)), (ProcessApplicationReference)processApplicationReference, (InvocationContext)invocationContext);
        ((TestApplicationWithoutEngine)((Object)Mockito.verify((Object)((Object)processApplication)))).execute((Callable)Matchers.any(Callable.class), (InvocationContext)Matchers.eq((Object)invocationContext));
        ((TestApplicationWithoutEngine)((Object)Mockito.verify((Object)((Object)processApplication)))).execute((Callable)Matchers.any(Callable.class));
    }

    protected ProcessApplicationReference getCurrentContextApplication() {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        return (ProcessApplicationReference)engineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<ProcessApplicationReference>(){

            public ProcessApplicationReference execute(CommandContext commandContext) {
                return Context.getCurrentProcessApplication();
            }
        });
    }
}

