/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment.jobexecutor;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.camunda.bpm.container.impl.deployment.jobexecutor.StartManagedThreadPoolStep;
import org.camunda.bpm.container.impl.jmx.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedThreadPool;
import org.camunda.bpm.container.impl.metadata.BpmPlatformXmlImpl;
import org.camunda.bpm.container.impl.metadata.JobExecutorXmlImpl;
import org.camunda.bpm.container.impl.metadata.spi.BpmPlatformXml;
import org.camunda.bpm.container.impl.metadata.spi.JobExecutorXml;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.PlatformService;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StartManagedThreadPoolStepTest {
    private MBeanServiceContainer container = new MBeanServiceContainer();
    private DeploymentOperation deploymentOperation;
    private JobExecutorXmlImpl jobExecutorXml;
    private BpmPlatformXml bpmPlatformXml;
    private StartManagedThreadPoolStep step;

    @Before
    public void setUp() {
        this.step = new StartManagedThreadPoolStep();
        this.deploymentOperation = new DeploymentOperation("name", (PlatformServiceContainer)this.container, Collections.emptyList());
        this.jobExecutorXml = new JobExecutorXmlImpl();
        this.bpmPlatformXml = new BpmPlatformXmlImpl((JobExecutorXml)this.jobExecutorXml, Collections.emptyList());
        this.deploymentOperation.addAttachment("bpmPlatformXml", (Object)this.bpmPlatformXml);
    }

    @After
    public void tearDown() {
        this.container.stopService((PlatformServiceContainer.ServiceType)ServiceTypes.BPM_PLATFORM, "executor-service");
    }

    @Test
    public void performOperationStepWithDefaultProperties() {
        HashMap properties = new HashMap();
        this.jobExecutorXml.setProperties(properties);
        this.step.performOperationStep(this.deploymentOperation);
        PlatformService service = (PlatformService)this.container.getService(this.getObjectNameForExecutor());
        ThreadPoolExecutor executor = ((JmxManagedThreadPool)service.getValue()).getThreadPoolExecutor();
        Assert.assertThat((Object)executor.getQueue().remainingCapacity(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)executor.getCorePoolSize(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)executor.getMaximumPoolSize(), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)executor.getKeepAliveTime(TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void performOperationStepWithPropertiesInXml() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String queueSize = "5";
        String corePoolSize = "12";
        String maxPoolSize = "20";
        String keepAliveTime = "100";
        properties.put("corePoolSize", corePoolSize);
        properties.put("keepAliveTime", keepAliveTime);
        properties.put("maxPoolSize", maxPoolSize);
        properties.put("queueSize", queueSize);
        this.jobExecutorXml.setProperties(properties);
        this.step.performOperationStep(this.deploymentOperation);
        PlatformService service = (PlatformService)this.container.getService(this.getObjectNameForExecutor());
        ThreadPoolExecutor executor = ((JmxManagedThreadPool)service.getValue()).getThreadPoolExecutor();
        Assert.assertThat((Object)executor.getQueue().remainingCapacity(), (Matcher)CoreMatchers.is((Object)Integer.parseInt(queueSize)));
        Assert.assertThat((Object)executor.getCorePoolSize(), (Matcher)CoreMatchers.is((Object)Integer.parseInt(corePoolSize)));
        Assert.assertThat((Object)executor.getMaximumPoolSize(), (Matcher)CoreMatchers.is((Object)Integer.parseInt(maxPoolSize)));
        Assert.assertThat((Object)executor.getKeepAliveTime(TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)Long.parseLong(keepAliveTime)));
    }

    private ObjectName getObjectNameForExecutor() {
        String localName = MBeanServiceContainer.composeLocalName((PlatformServiceContainer.ServiceType)ServiceTypes.BPM_PLATFORM, (String)"executor-service");
        return MBeanServiceContainer.getObjectName((String)localName);
    }
}

