/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.scripttask;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ScriptCompilationException;
import org.camunda.bpm.engine.ScriptEvaluationException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable;
import org.camunda.bpm.engine.test.bpmn.scripttask.ScriptResourceBean;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ScriptTaskTest
extends PluggableProcessEngineTestCase {
    private static final String JAVASCRIPT = "javascript";
    private static final String PYTHON = "python";
    private static final String RUBY = "ruby";
    private static final String GROOVY = "groovy";
    private static final String JUEL = "juel";
    private List<String> deploymentIds = new ArrayList<String>();

    protected void tearDown() throws Exception {
        for (String deploymentId : this.deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        }
    }

    public void testJavascriptProcessVarVisibility() {
        this.deployProcess(JAVASCRIPT, "execution.setVariable('foo', 'a');if (typeof foo !== 'undefined') {   throw 'Variable foo should be defined as script variable.';}var foo = 'b';if(execution.getVariable('foo') != 'a') {  throw 'Execution should contain variable foo';}if(foo != 'b') {  throw 'Script variable must override the visibiltity of the execution variable.';}");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((Object)"a", (Object)variableValue);
    }

    public void testPythonProcessVarAssignment() {
        this.deployProcess(PYTHON, "execution.setVariable('foo', 'a')\nif not foo:\n    raise Exception('Variable foo should be defined as script variable.')\nfoo = 'b'\nif execution.getVariable('foo') != 'a':\n    raise Exception('Execution should contain variable foo')\nif foo != 'b':\n    raise Exception('Script variable must override the visibiltity of the execution variable.')\n");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((Object)"a", (Object)variableValue);
    }

    public void testRubyProcessVarVisibility() {
        this.deployProcess(RUBY, "$execution.setVariable('foo', 'a')\nraise 'Variable foo should be defined as script variable.' if !$foo.nil?\n$foo = 'b'\nif $execution.getVariable('foo') != 'a'\n  raise 'Execution should contain variable foo'\nend\nif $foo != 'b'\n  raise 'Script variable must override the visibiltity of the execution variable.'\nend");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((Object)"a", (Object)variableValue);
    }

    public void testGroovyProcessVarVisibility() {
        this.deployProcess(GROOVY, "execution.setVariable('foo', 'a')\nif ( !foo ) {\n  throw new Exception('Variable foo should be defined as script variable.')\n}\nfoo = 'b'\nif (execution.getVariable('foo') != 'a') {\n  throw new Exception('Execution should contain variable foo')\n}\nif (foo != 'b') {\n  throw new Exception('Script variable must override the visibiltity of the execution variable.')\n}");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((Object)"a", (Object)variableValue);
    }

    public void testJavascriptFunctionInvocation() {
        this.deployProcess(JAVASCRIPT, "function sum(a,b){  return a+b;};var result = sum(1,2);execution.setVariable('foo', result);");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variable = this.runtimeService.getVariable(pi.getId(), "foo");
        if (variable instanceof Double) {
            ScriptTaskTest.assertEquals((Object)3.0, (Object)variable);
        } else if (variable instanceof Integer) {
            ScriptTaskTest.assertEquals((Object)3, (Object)variable);
        }
    }

    public void testPythonFunctionInvocation() {
        this.deployProcess(PYTHON, "def sum(a, b):\n    return a + b\nresult = sum(1,2)\nexecution.setVariable('foo', result)");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variable = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((Object)3, (Object)variable);
    }

    public void testRubyFunctionInvocation() {
        this.deployProcess(RUBY, "def sum(a, b)\n    return a + b\nend\nresult = sum(1,2)\n$execution.setVariable('foo', result)\n");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variable = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((Object)3L, (Object)variable);
    }

    public void testGroovyFunctionInvocation() {
        this.deployProcess(GROOVY, "def sum(a, b) {\n    return a + b\n}\nresult = sum(1,2)\nexecution.setVariable('foo', result)\n");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variable = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((Object)3, (Object)variable);
    }

    public void testJsVariable() {
        String scriptText = "var foo = 1;";
        this.deployProcess(JAVASCRIPT, scriptText);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertNull((Object)variableValue);
    }

    public void testPythonVariable() {
        String scriptText = "foo = 1";
        this.deployProcess(PYTHON, scriptText);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertNull((Object)variableValue);
    }

    public void testRubyVariable() {
        String scriptText = "foo = 1";
        this.deployProcess(RUBY, scriptText);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertNull((Object)variableValue);
    }

    public void testGroovyVariable() {
        String scriptText = "def foo = 1";
        this.deployProcess(GROOVY, scriptText);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertNull((Object)variableValue);
    }

    public void testJuelExpression() {
        this.deployProcess(JUEL, "${execution.setVariable('foo', 'bar')}");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        String variableValue = (String)this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((String)"bar", (String)variableValue);
    }

    public void testJuelCapitalizedExpression() {
        this.deployProcess(JUEL.toUpperCase(), "${execution.setVariable('foo', 'bar')}");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        String variableValue = (String)this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((String)"bar", (String)variableValue);
    }

    public void testSourceAsExpressionAsVariable() {
        this.deployProcess(PYTHON, "${scriptSource}");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptSource", "execution.setVariable('foo', 'bar')");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        String variableValue = (String)this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((String)"bar", (String)variableValue);
    }

    public void testSourceAsExpressionAsNonExistingVariable() {
        this.deployProcess(PYTHON, "${scriptSource}");
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess");
            ScriptTaskTest.fail((String)"Process variable 'scriptSource' not defined");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("Cannot resolve identifier 'scriptSource'", e.getMessage());
        }
    }

    public void testSourceAsExpressionAsBean() {
        this.deployProcess(PYTHON, "#{scriptResourceBean.getSource()}");
        HashMap<String, ScriptResourceBean> variables = new HashMap<String, ScriptResourceBean>();
        variables.put("scriptResourceBean", new ScriptResourceBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        String variableValue = (String)this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((String)"bar", (String)variableValue);
    }

    public void testSourceAsExpressionWithWhitespace() {
        this.deployProcess(PYTHON, "\t\n  \t \n  ${scriptSource}");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptSource", "execution.setVariable('foo', 'bar')");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        String variableValue = (String)this.runtimeService.getVariable(pi.getId(), "foo");
        ScriptTaskTest.assertEquals((String)"bar", (String)variableValue);
    }

    public void testJavascriptVariableSerialization() {
        this.deployProcess(JAVASCRIPT, "execution.setVariable('date', new java.util.Date(0));");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Date date = (Date)this.runtimeService.getVariable(pi.getId(), "date");
        ScriptTaskTest.assertEquals((long)0L, (long)date.getTime());
        this.deployProcess(JAVASCRIPT, "execution.setVariable('myVar', new org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable('test'));");
        pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        MySerializable myVar = (MySerializable)this.runtimeService.getVariable(pi.getId(), "myVar");
        ScriptTaskTest.assertEquals((String)"test", (String)myVar.getName());
    }

    public void testPythonVariableSerialization() {
        this.deployProcess(PYTHON, "import java.util.Date\nexecution.setVariable('date', java.util.Date(0))");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Date date = (Date)this.runtimeService.getVariable(pi.getId(), "date");
        ScriptTaskTest.assertEquals((long)0L, (long)date.getTime());
        this.deployProcess(PYTHON, "import org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable\nexecution.setVariable('myVar', org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable('test'));");
        pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        MySerializable myVar = (MySerializable)this.runtimeService.getVariable(pi.getId(), "myVar");
        ScriptTaskTest.assertEquals((String)"test", (String)myVar.getName());
    }

    public void testRubyVariableSerialization() {
        this.deployProcess(RUBY, "require 'java'\n$execution.setVariable('date', java.util.Date.new(0))");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Date date = (Date)this.runtimeService.getVariable(pi.getId(), "date");
        ScriptTaskTest.assertEquals((long)0L, (long)date.getTime());
        this.deployProcess(RUBY, "$execution.setVariable('myVar', org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable.new('test'));");
        pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        MySerializable myVar = (MySerializable)this.runtimeService.getVariable(pi.getId(), "myVar");
        ScriptTaskTest.assertEquals((String)"test", (String)myVar.getName());
    }

    public void testGroovyVariableSerialization() {
        this.deployProcess(GROOVY, "execution.setVariable('date', new java.util.Date(0))");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Date date = (Date)this.runtimeService.getVariable(pi.getId(), "date");
        ScriptTaskTest.assertEquals((long)0L, (long)date.getTime());
        this.deployProcess(GROOVY, "execution.setVariable('myVar', new org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable('test'));");
        pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        MySerializable myVar = (MySerializable)this.runtimeService.getVariable(pi.getId(), "myVar");
        ScriptTaskTest.assertEquals((String)"test", (String)myVar.getName());
    }

    public void testGroovyNotExistingImport() {
        this.deployProcess(GROOVY, "import unknown");
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess");
            ScriptTaskTest.fail((String)"Should fail during script compilation");
        }
        catch (ScriptCompilationException e) {
            this.assertTextPresentIgnoreCase("import unknown", e.getMessage());
        }
    }

    public void testGroovyNotExistingImportWithoutCompilation() {
        this.processEngineConfiguration.setEnableScriptCompilation(false);
        this.deployProcess(GROOVY, "import unknown");
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess");
            ScriptTaskTest.fail((String)"Should fail during script evaluation");
        }
        catch (ScriptEvaluationException e) {
            this.assertTextPresentIgnoreCase("import unknown", e.getMessage());
        }
        finally {
            this.processEngineConfiguration.setEnableScriptCompilation(true);
        }
    }

    public void testShouldNotDeployProcessWithMissingScriptElementAndResource() {
        try {
            this.deployProcess(((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().scriptTask().scriptFormat(RUBY)).userTask().endEvent().done());
            ScriptTaskTest.fail((String)"this process should not be deployable");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testShouldUseJuelAsDefaultScriptLanguage() {
        this.deployProcess(((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().scriptTask().scriptText("${true}")).userTask().endEvent().done());
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ScriptTaskTest.assertNotNull((Object)task);
    }

    protected void deployProcess(BpmnModelInstance process) {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy();
        this.deploymentIds.add(deployment.getId());
    }

    protected void deployProcess(String scriptFormat, String scriptText) {
        BpmnModelInstance process = this.createProcess(scriptFormat, scriptText);
        this.deployProcess(process);
    }

    protected BpmnModelInstance createProcess(String scriptFormat, String scriptText) {
        return ((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().scriptTask().scriptFormat(scriptFormat)).scriptText(scriptText)).userTask().endEvent().done();
    }

    public void testAutoStoreScriptVarsOff() {
        ScriptTaskTest.assertFalse((boolean)this.processEngineConfiguration.isAutoStoreScriptVariables());
    }

    @Deployment
    public void testPreviousTaskShouldNotHandleException() {
        try {
            this.runtimeService.startProcessInstanceByKey("process");
            ScriptTaskTest.fail();
        }
        catch (NullValueException nve) {
            ScriptTaskTest.fail((String)"Shouldn't have received NullValueException");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Invalid format"));
        }
    }

    @Deployment
    public void testSetScriptResultToProcessVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("echo", "hello");
        variables.put("existingProcessVariableName", "one");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("setScriptResultToProcessVariable", variables);
        ScriptTaskTest.assertEquals((Object)"hello", (Object)this.runtimeService.getVariable(pi.getId(), "existingProcessVariableName"));
        ScriptTaskTest.assertEquals((Object)pi.getId(), (Object)this.runtimeService.getVariable(pi.getId(), "newProcessVariableName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment
    public void testGroovyScriptExecution() {
        try {
            this.processEngineConfiguration.setAutoStoreScriptVariables(true);
            int[] inputArray = new int[]{1, 2, 3, 4, 5};
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("scriptExecution", CollectionUtil.singletonMap((String)"inputArray", (Object)inputArray));
            Integer result = (Integer)this.runtimeService.getVariable(pi.getId(), "sum");
            ScriptTaskTest.assertEquals((int)15, (int)result);
        }
        finally {
            this.processEngineConfiguration.setAutoStoreScriptVariables(false);
        }
    }

    @Deployment
    public void testGroovySetVariableThroughExecutionInScript() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("setScriptVariableThroughExecution");
        ScriptTaskTest.assertNull((Object)this.runtimeService.getVariable(pi.getId(), "scriptVar"));
        ScriptTaskTest.assertEquals((Object)"test123", (Object)this.runtimeService.getVariable(pi.getId(), "myVar"));
    }

    @Deployment
    public void testScriptEvaluationException() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process_1").singleResult();
        try {
            this.runtimeService.startProcessInstanceByKey("Process_1");
        }
        catch (ScriptEvaluationException e) {
            this.assertTextPresent("Unable to evaluate script while executing activity 'Failing' in the process definition with id '" + processDefinition.getId() + "'", e.getMessage());
        }
    }
}

