/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobExecutorFollowUpTest {
    protected static final BpmnModelInstance TWO_TASKS_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("serviceTask1").camundaAsyncBefore()).camundaClass(SyncDelegate.class.getName())).serviceTask("serviceTask2").camundaAsyncBefore()).camundaClass(SyncDelegate.class.getName())).endEvent().done();
    protected static final BpmnModelInstance CALL_ACTIVITY_PROCESS = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callActivityProcess").startEvent().callActivity("callActivity").camundaAsyncBefore()).calledElement("oneTaskProcess")).endEvent().done();
    protected static final BpmnModelInstance ONE_TASK_PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask("serviceTask").camundaAsyncBefore()).endEvent().done();
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            return configuration.setJobExecutor((JobExecutor)JobExecutorFollowUpTest.buildControllableJobExecutor());
        }
    };
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected ControllableJobExecutor jobExecutor;
    protected ConcurrencyTestCase.ThreadControl acquisitionThread;
    protected static ConcurrencyTestCase.ThreadControl executionThread;

    protected static ControllableJobExecutor buildControllableJobExecutor() {
        ControllableJobExecutor jobExecutor = new ControllableJobExecutor();
        jobExecutor.setMaxJobsPerAcquisition(2);
        jobExecutor.proceedAndWaitOnShutdown(false);
        return jobExecutor;
    }

    @Before
    public void setUp() throws Exception {
        this.jobExecutor = (ControllableJobExecutor)((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getJobExecutor();
        this.jobExecutor.setMaxJobsPerAcquisition(2);
        this.acquisitionThread = this.jobExecutor.getAcquisitionThreadControl();
        executionThread = this.jobExecutor.getExecutionThreadControl();
    }

    @After
    public void shutdownJobExecutor() {
        this.jobExecutor.shutdown();
    }

    @Test
    public void testExecuteExclusiveFollowUpJobInSameProcessInstance() {
        this.testHelper.deploy(TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinue();
        executionThread.waitForSync();
        executionThread.makeContinueAndWaitForSync();
        ActivityInstance activityInstance = this.engineRule.getRuntimeService().getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)activityInstance.getTransitionInstances("serviceTask2").length);
        JobEntity followUpJob = (JobEntity)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)followUpJob);
        Assert.assertNotNull((Object)followUpJob.getLockOwner());
        Assert.assertNotNull((Object)followUpJob.getLockExpirationTime());
        executionThread.makeContinue();
        this.acquisitionThread.waitForSync();
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testExecuteExclusiveFollowUpJobInDifferentProcessInstance() {
        this.testHelper.deploy(CALL_ACTIVITY_PROCESS, ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("callActivityProcess");
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        ProcessInstance calledInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)calledInstance);
        ActivityInstance activityInstance = this.engineRule.getRuntimeService().getActivityInstance(calledInstance.getId());
        Assert.assertEquals((long)1L, (long)activityInstance.getTransitionInstances("serviceTask").length);
        JobEntity followUpJob = (JobEntity)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)followUpJob);
        Assert.assertNull((Object)followUpJob.getLockOwner());
        Assert.assertNull((Object)followUpJob.getLockExpirationTime());
    }

    public static class SyncDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            executionThread.sync();
        }
    }
}

