/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.List;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AuthorizationQueryAuthorizationsTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected AuthorizationService authorizationService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
    }

    @Test
    public void testQuerySingleCorrectPermission() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.PROCESS_DEFINITION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).count());
    }

    @Test
    public void testQuerySingleIncorrectPermission() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.BATCH);
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.BATCH).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.CREATE_INSTANCE).count());
    }

    @Test
    public void testQueryPermissionsWithWrongResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.APPLICATION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Authorization accessResult = (Authorization)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.ACCESS).singleResult();
        List retryJobPDResult = this.authorizationService.createAuthorizationQuery().hasPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB).list();
        List retryJobPIResult = this.authorizationService.createAuthorizationQuery().hasPermission((Permission)ProcessInstancePermissions.RETRY_JOB).list();
        Assert.assertNotNull((Object)accessResult);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.ACCESS).count());
        Assert.assertTrue((boolean)retryJobPDResult.isEmpty());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB).count());
        Assert.assertTrue((boolean)retryJobPIResult.isEmpty());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)ProcessInstancePermissions.RETRY_JOB).count());
    }

    @Test
    public void testQueryPermissionWithMixedResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.APPLICATION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.BATCH).hasPermission((Permission)Permissions.ACCESS).count());
    }

    @Test
    public void testQueryPermissionsWithMixedResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.addPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.PROCESS_DEFINITION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.PROCESS_DEFINITION).hasPermission((Permission)ProcessDefinitionPermissions.READ).hasPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB).count());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.PROCESS_DEFINITION).hasPermission((Permission)ProcessDefinitionPermissions.READ).count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.PROCESS_DEFINITION).hasPermission((Permission)Permissions.READ).hasPermission((Permission)Permissions.ACCESS).count());
    }

    @Test
    public void testQueryCorrectAndIncorrectPersmission() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.addPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.PROCESS_DEFINITION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).hasPermission((Permission)Permissions.ACCESS).count());
    }

    protected void cleanupAfterTest() {
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

