/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ResourceTypes;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.camunda.bpm.engine.test.api.runtime.FailingDelegate;
import org.camunda.bpm.engine.test.api.variables.JavaSerializable;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoryByteArrayTest {
    protected static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml";
    protected static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    protected static final String WORKER_ID = "aWorkerId";
    protected static final long LOCK_TIME = 10000L;
    protected static final String TOPIC_NAME = "externalTaskTopic";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ExternalTaskService externalTaskService;
    protected String taskId;

    @Before
    public void initServices() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
    }

    @After
    public void tearDown() {
        if (this.taskId != null) {
            this.taskService.deleteTask(this.taskId, true);
        }
    }

    @Test
    public void testHistoricVariableBinaryForFileValues() {
        BpmnModelInstance instance = this.createProcess();
        this.testRule.deploy(instance);
        FileValue fileValue = this.createFile();
        this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValueTyped("fileVar", (TypedValue)fileValue));
        String byteArrayValueId = ((HistoricVariableInstanceEntity)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayValueId));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testHistoricVariableBinary() {
        byte[] binaryContent = "some binary content".getBytes();
        HashMap<String, byte[]> variables = new HashMap<String, byte[]>();
        variables.put("binaryVariable", binaryContent);
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskId = task.getId();
        this.taskService.setVariablesLocal(this.taskId, variables);
        String byteArrayValueId = ((HistoricVariableInstanceEntity)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayValueId));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testHistoricDetailBinaryForFileValues() {
        BpmnModelInstance instance = this.createProcess();
        this.testRule.deploy(instance);
        FileValue fileValue = this.createFile();
        this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValueTyped("fileVar", (TypedValue)fileValue));
        String byteArrayValueId = ((HistoricDetailVariableInstanceUpdateEntity)this.historyService.createHistoricDetailQuery().singleResult()).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayValueId));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testHistoricDecisionInputInstanceBinary() {
        this.testRule.deploy(DECISION_PROCESS, DECISION_SINGLE_OUTPUT_DMN);
        this.startProcessInstanceAndEvaluateDecision(new JavaSerializable("foo"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getHistoryService().createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputInstances = historicDecisionInstance.getInputs();
        Assert.assertEquals((long)1L, (long)inputInstances.size());
        String byteArrayValueId = ((HistoricDecisionInputInstanceEntity)inputInstances.get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayValueId));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testHistoricDecisionOutputInstanceBinary() {
        this.testRule.deploy(DECISION_PROCESS, DECISION_SINGLE_OUTPUT_DMN);
        this.startProcessInstanceAndEvaluateDecision(new JavaSerializable("foo"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getHistoryService().createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputInstances = historicDecisionInstance.getOutputs();
        Assert.assertEquals((long)1L, (long)outputInstances.size());
        String byteArrayValueId = ((HistoricDecisionOutputInstanceEntity)outputInstances.get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayValueId));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testAttachmentContentBinaries() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskId = task.getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment("web page", this.taskId, "someprocessinstanceid", "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(attachment.getContentId()));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testHistoricExceptionStacktraceBinary() {
        BpmnModelInstance instance = this.createFailingProcess();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("Process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLogEventEntity entity = (HistoricJobLogEventEntity)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        Assert.assertNotNull((Object)entity);
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(entity.getExceptionByteArrayId()));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testHistoricExternalTaskJobLogStacktraceBinary() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        try {
            throw new RuntimeSqlException("test cause");
        }
        catch (RuntimeException e) {
            String exceptionStackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            String errorMessage = e.getMessage();
            Assert.assertNotNull((Object)exceptionStackTrace);
            this.externalTaskService.handleFailure(task.getId(), WORKER_ID, errorMessage, exceptionStackTrace, 5, 3000L);
            HistoricExternalTaskLogEntity entity = (HistoricExternalTaskLogEntity)this.historyService.createHistoricExternalTaskLogQuery().errorMessage(errorMessage).singleResult();
            Assert.assertNotNull((Object)entity);
            ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(entity.getErrorDetailsByteArrayId()));
            this.checkBinary(byteArrayEntity);
            return;
        }
    }

    protected void checkBinary(ByteArrayEntity byteArrayEntity) {
        Assert.assertNotNull((Object)byteArrayEntity);
        Assert.assertNotNull((Object)byteArrayEntity.getCreateTime());
        Assert.assertEquals((Object)ResourceTypes.HISTORY.getValue(), (Object)byteArrayEntity.getType());
    }

    protected FileValue createFile() {
        String fileName = "text.txt";
        String encoding = "crazy-encoding";
        String mimeType = "martini/dry";
        FileValue fileValue = (FileValue)Variables.fileValue((String)fileName).file("ABC".getBytes()).encoding(encoding).mimeType(mimeType).create();
        return fileValue;
    }

    protected BpmnModelInstance createProcess() {
        return Bpmn.createExecutableProcess((String)"Process").startEvent().userTask("user").endEvent().done();
    }

    protected BpmnModelInstance createFailingProcess() {
        return ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask("failing").camundaAsyncAfter()).camundaAsyncBefore()).camundaClass(FailingDelegate.class)).endEvent().done();
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision(Object input) {
        return this.engineRule.getRuntimeService().startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("input1", input));
    }

    protected Date nowPlus(long millis) {
        return new Date(ClockUtil.getCurrentTime().getTime() + millis);
    }
}

