/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.After;

public class TimerRecalculationTest
extends PluggableProcessEngineTestCase {
    private Set<String> jobIds = new HashSet<String>();

    @After
    public void tearDown() {
        this.clearMeterLog();
        for (String jobId : this.jobIds) {
            this.clearJobLog(jobId);
            this.clearJob(jobId);
        }
        this.jobIds = new HashSet<String>();
    }

    public void testUnknownId() {
        try {
            this.managementService.recalculateJobDuedate("unknownID", false);
            TimerRecalculationTest.fail((String)"The recalculation with an unknown job ID should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.assertTextPresent("No job found with id 'unknownID", pe.getMessage());
        }
    }

    public void testEmptyId() {
        try {
            this.managementService.recalculateJobDuedate("", false);
            TimerRecalculationTest.fail((String)"The recalculation with an unknown job ID should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.assertTextPresent("The job id is mandatory: jobId is empty", pe.getMessage());
        }
    }

    public void testNullId() {
        try {
            this.managementService.recalculateJobDuedate(null, false);
            TimerRecalculationTest.fail((String)"The recalculation with an unknown job ID should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.assertTextPresent("The job id is mandatory: jobId is null", pe.getMessage());
        }
    }

    @Deployment
    public void testFinishedJob() {
        HashMap<String, Date> variables1 = new HashMap<String, Date>();
        variables1.put("dueDate", new Date());
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables1);
        TimerRecalculationTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        JobQuery jobQuery = this.managementService.createJobQuery().executable();
        TimerRecalculationTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.recalculateJobDuedate(jobId, false);
        this.managementService.executeJob(jobId);
        TimerRecalculationTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        this.assertProcessEnded(pi1.getProcessInstanceId());
        try {
            this.managementService.recalculateJobDuedate(jobId, false);
            TimerRecalculationTest.fail((String)"The recalculation of a finished job should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.assertTextPresent("No job found with id '" + jobId, pe.getMessage());
        }
    }

    public void testEverLivingJob() {
        Job job = this.historyService.cleanUpHistoryAsync(true);
        this.jobIds.add(job.getId());
        this.tryRecalculateUnsupported(job, "history-cleanup");
    }

    @Deployment
    public void testMessageJob() {
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.jobIds.add(job.getId());
        this.tryRecalculateUnsupported(job, "async-continuation");
    }

    protected void tryRecalculateUnsupported(Job job, String type) {
        try {
            this.managementService.recalculateJobDuedate(job.getId(), false);
            TimerRecalculationTest.fail((String)"The recalculation with an unsupported type should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.assertTextPresent("Only timer jobs can be recalculated, but the job with id '" + job.getId() + "' is of type '" + type, pe.getMessage());
        }
    }

    protected void clearMeterLog() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }

    protected void clearJobLog(final String jobId) {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                return null;
            }
        });
    }

    protected void clearJob(final String jobId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(jobId);
                if (job != null) {
                    commandContext.getJobManager().delete((DbEntity)job);
                }
                return null;
            }
        });
    }
}

